#!/usr/bin/python

import urllib
import sys
import os
from xml.dom import minidom
from Results import Ui_ResultsWindow
from Search import Ui_SearchWindow
from PyQt4.QtCore import *
from PyQt4.QtGui import *

RADIO_TIME_SEARCH_URL = 'http://opml.radiotime.com/Search.ashx?formats=wma:mp3:aac&query=%s'

def populate_results(url, results, resultsWindow, append):

    safeurl = urllib.quote(url, safe="%/:=&?~#+!$,;'@()*[]")
    if append:
        resultsWindow.history.append(safeurl)
    if len(resultsWindow.history) > 1:
        resultsWindow.pushButtonBack.setEnabled(True)
    else:
        resultsWindow.pushButtonBack.setEnabled(False)
    dom = minidom.parse(urllib.urlopen(safeurl))
    for node in dom.getElementsByTagName('outline'):
        results.append({
            'text' : node.getAttribute('text'),
            'URL'  : node.getAttribute('URL'),
            'type' : node.getAttribute('type'),
            'key'  : node.getAttribute('key')
        })
    i = 0
    while i < len(results):
        resultsWindow.listWidgetResults.addItem(results[i].get('text'))
        if results[i].get('key') != '' and results[i].get('URL') == '':
            item = resultsWindow.listWidgetResults.item(i)
            font = item.font()
            font.setBold(True)
            item.setFont(font)
        elif results[i].get('type') == 'link':
            resultsWindow.listWidgetResults.item(i).setForeground(Qt.cyan)
        i = i + 1
    resultsWindow.listWidgetResults.setCurrentRow(0)
    resultsWindow.index = 0

class SearchWindow(QMainWindow, Ui_SearchWindow):

    def __init__(self, parent=None):
        super(SearchWindow, self).__init__(parent)
        self.setupUi(self)
        self.resultsWindow = ResultsWindow(self)
        if os.path.isfile('/opt/RadiotimeToGo/radiotime_logo_400.png'):
            pixmap = QPixmap('/opt/RadiotimeToGo/radiotime_logo_400.png')
        else:
            pixmap = QPixmap('radiotime_logo_400.png')

        self.results = []
        self.textLabelLogo.setPixmap(pixmap)

    def on_pushButtonSearch_released(self):
        self.results = []
        self.resultsWindow.listWidgetResults.clear()
        self.resultsWindow.history = []
        url = RADIO_TIME_SEARCH_URL % self.lineEditSearch.text()
        #print url

        populate_results(url, self.results, self.resultsWindow, True)
        if len(self.results) == 0:
            self.results.append({ 'text' : 'Nothing found' })
        self.resultsWindow.updatePushButton(0)

        try:
            self.resultsWindow.setAttribute(Qt.WA_Maemo5StackedWindow)
        except:
               pass
        self.resultsWindow.show()

class ResultsWindow(QMainWindow, Ui_ResultsWindow):

    def __init__(self, parent=None):
        super(ResultsWindow, self).__init__(parent)
        self.setupUi(self)
        self.index = -1
        self.history = []
        self.pushButtonBack.setEnabled(False)

    def updatePushButton(self, row):
        if ui.results[row].get('type') == "audio":
            self.pushButtonListen.setEnabled(True)
            self.pushButtonListen.setText('Listen')
        elif ui.results[row].get('type') == "link":
            self.pushButtonListen.setText('Browse')
            self.pushButtonListen.setEnabled(True)
        else:
            self.pushButtonListen.setEnabled(False)

    def on_listWidgetResults_itemClicked(self, item):
        # change button text to reflect the action based on selection
        self.index = self.listWidgetResults.row(item)
        self.updatePushButton(self.index)

    def on_pushButtonListen_pressed(self):
        if self.index >= 0:
            #print "%s : %s" % (ui.results[self.index].get('text'), ui.results[self.index].get('URL'))
            if ui.results[self.index].get('type') == "link":
                # print "browsing container"
                url = ui.results[self.index].get('URL')
                ui.results = []
                self.listWidgetResults.clear()
                populate_results(url, ui.results, self, True)
                self.updatePushButton(0)
            else:
                if os.path.isfile('/opt/kmplayer/bin/kmplayer'):
                    os.system('/opt/kmplayer/bin/kmplayer %s &' % ui.results[self.index].get('URL'))
                elif os.path.isfile('/Applications/VLC.app/Contents/MacOS/VLC'):
                    os.system('/Applications/VLC.app/Contents/MacOS/VLC %s &' % ui.results[self.index].get('URL'))
                elif os.path.isfile('c:/program files/VideoLAN/vlc/vlc.exe'):
                    os.system('"c:/program files/VideoLAN/vlc/vlc.exe" %s' % ui.results[self.index].get('URL'))


    def on_pushButtonBack_pressed(self):
        self.history.pop()
        ui.results = []
        self.listWidgetResults.clear()
        populate_results(self.history[len(self.history)-1], ui.results, self, False)
        self.updatePushButton(0)
        
if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = SearchWindow()
    try:
        ui.setAttribute(Qt.WA_Maemo5StackedWindow)
    except:
           pass
    ui.show()
    sys.exit(app.exec_())
