/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UTILS_H
#define UTILS_H

#include <QtCore/qobject.h>

class QDeclarativeContext;
class QTranslator;

class Utils : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString emptyString READ emptyString NOTIFY emptyStringChanged)

public:
    Utils(QDeclarativeContext *context, QObject *parent = 0);

    Q_INVOKABLE void setUiTranslation(const QString &translation);

    QString emptyString();

Q_SIGNALS:
    void emptyStringChanged();

private:
    QDeclarativeContext *rootContext;
    QTranslator *translator;
};

#endif // UTILS_H
