/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "utils.h"

#include <QtCore/qtranslator.h>
#include <QtDeclarative/qdeclarativecontext.h>
#include <QtGui/qapplication.h>

Utils::Utils(QDeclarativeContext *context, QObject *parent)
    : QObject(parent)
    , rootContext(context)
    , translator(new QTranslator(this))
{
    rootContext->setContextProperty("utils", this);

    setUiTranslation(QString::fromAscii("qml_en"));
}

void Utils::setUiTranslation(const QString &translation)
{
    if (translator->load(QString::fromAscii(":/i18n/%1.qm").arg(translation)))
        qApp->installTranslator(translator);

    Q_EMIT emptyStringChanged();
}

QString Utils::emptyString()
{
    return QString::null;
}
