/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QtCore/qresource.h>
#include <QtDeclarative/qdeclarativecontext.h>
#include <QtDeclarative/qdeclarativeengine.h>
#include <QtDeclarative/qdeclarativeview.h>
#include <QtGui/qapplication.h>

#include "bibletextmodel.h"
#include "utils.h"

#define XSTR(s) STR(s)
#define STR(s) #s

int main(int argc, char **argv)
{
    QApplication app(argc, argv);

    // TODO: use lazy-loading
    QResource::registerResource(QString::fromAscii(XSTR(BIBLE_INSTALLATION_ROOT)) + "chinese-union-simplified.rcc");
    QResource::registerResource(QString::fromAscii(XSTR(BIBLE_INSTALLATION_ROOT)) + "king-james.rcc");

    QDeclarativeView view;
#if defined(Q_WS_MAEMO_5)
    view.setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
#endif
    view.setWindowTitle(QString::fromAscii("Raamatta"));

    QDeclarativeContext *context = view.engine()->rootContext();

    BibleTextModel model;
    context->setContextProperty("bibleTextModel", &model);

    Utils utils(context);

    view.setSource(QUrl("qrc:/main.qml"));
    view.showFullScreen();

    QObject::connect(view.engine(), SIGNAL(quit()), qApp, SLOT(quit()));

    return app.exec();
}
