/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bibletextmodel.h"

#include <QtCore/qfile.h>
#include <QtCore/qtextstream.h>

BibleTextModel::BibleTextModel(QObject *parent)
    : QStringListModel(parent)
{
    setBibleTranslation(QString::fromAscii("king-james"));
}

void BibleTextModel::setBibleText(int book, int chapter)
{
    QFile file(QString::fromAscii(":/bible/%1/%2-%3").arg(translation).arg(book).arg(chapter));
    if (file.open(QIODevice::ReadOnly)) {
        QTextStream out(&file);
        QStringList list;
        while (!out.atEnd())
            list << out.readLine();
        setStringList(list);
    }
}

void BibleTextModel::setBibleTranslation(const QString &translation)
{
    this->translation = translation;
}
