/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import Qt 4.7

Rectangle {
    property bool buttonEnabled
    property int buttonTextSize
    property string buttonText

    signal clicked

    border.color: "#cccccc"; border.width: 1
    radius: 5
    gradient: Gradient {
        GradientStop { position: 0.0; color: "#efefef" }
        GradientStop { position: 1.0; color: "#dddddd" }
    }

    Text {
        text: buttonText
        color: buttonEnabled ? "black" : "#ffffff"
        font { pixelSize: buttonTextSize; bold: true }
        anchors.centerIn: parent
    }

    MouseArea {
        anchors.fill: parent
        onClicked: { parent.clicked(); }
    }
}
