/****************************************************************************
 *  settingsextension.h
 *
 *  Copyright (c) 2010 by Prokhin Alexey <alexey.prokhin@yandex.ru>
 *
 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
 *****************************************************************************/

#ifndef SETTINGSEXTENSION_H
#define SETTINGSEXTENSION_H

#include "icq_global.h"
#include <qutim/settingswidget.h>
#include <qutim/dataforms.h>
#include <qutim/config.h>

namespace qutim_sdk_0_3 {

namespace oscar {

class LIBOSCAR_EXPORT SettingsExtension
{
public:
    SettingsExtension();
	virtual ~SettingsExtension();
	virtual void loadSettings(DataItem &item, Config cfg) = 0;
	virtual void saveSettings(const DataItem &item, Config cfg) = 0;
};

} } // namespace qutim_sdk_0_3::oscar

Q_DECLARE_INTERFACE(qutim_sdk_0_3::oscar::SettingsExtension, "org.qutim.oscar.SettingsExtension");

#endif // SETTINGSEXTENSION_H
