#include <QFileDialog>
#include "quickwidgetsettings.hpp"
#include "quickwidget.hpp"
#include "ui_quickwidgetsettings.h"

QuickWidgetSettings::QuickWidgetSettings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::QuickWidgetSettings)
{
    ui->setupUi(this);
    connect(ui->fileButton, SIGNAL(clicked()), this, SLOT(getQml()));
}

QuickWidgetSettings::~QuickWidgetSettings()
{
    delete ui;
}

void QuickWidgetSettings::accept() {
    QFile f(ui->fileEdit->text());
    QSize size;
    bool rotate = ui->autoRotateCheckBox->isChecked();
    if (ui->sizingCheckBox->isChecked()) {
        bool wok, hok;
        int width = ui->widthEdit->text().toInt(&wok);
        int height = ui->heightEdit->text().toInt(&hok);
        if ( wok && hok && width < 800 && width > 10 && height < 400 && height > 10) {
            size.setWidth(width);
            size.setHeight(height);
        }
    }
    if (f.exists())
    {
      QuickWidget::createAndShowNew(ui->fileEdit->text(), size, rotate);
    }

    QDialog::accept();
}

void QuickWidgetSettings::getQml()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"),
                                                    QDir::homePath(),
                                                    tr("QML files (*.qml)"));
    ui->fileEdit->setText(fileName);
}
