#include <QApplication>
//#include <QDeclarativeEngine>
#include <QDeclarativeComponent>
#include <q-extras/qemaemo5dynamicwidgethelper.h>
#include <q-extras/qtsingleapplication.h>
#include <q-extras/qesettingsmanager.h>
#include "ProcessObject.h"
#include "quickwidget.hpp"
#include "quickwidgetsettings.hpp"
#include "appeventlistener.hpp"

int main(int argc, char *argv[])
{
    QApplication::setApplicationName("Quick Widgets");
    QApplication::setOrganizationName("Marquarding");
    // APP_VERSION and APP_BETA are defined in the .pro file
    QApplication::setApplicationVersion(QString(APP_VERSION)
#if APP_BETA
        + " beta"
#endif
        );

    QtSingleApplication app(argc, argv);
    qmlRegisterType<ProcessObject>("quickwidgets", 1,0, "Process");

    qDebug() << "Launched quick widgets app";

    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        if (app.arguments().contains("in-background"))
        {
            qDebug() << "Closing that other instance.";
            app.sendMessage(APP_MESSAGE_CLOSE);
        }
        else
        {
            qDebug() << "Asking it to offer to create a new widget.";
            app.sendMessage(APP_MESSAGE_ADDWIDGET);
            return 0;
        }
    }

    app.setQuitOnLastWindowClosed(false);
    AppEventListener::instance();

    if (app.arguments().contains("forget-widgets"))
    {
        qDebug() << "We were asked to forget all widgets!";
        QeMaemo5DynamicWidgetHelper::globalInstance()->forgetAllWidgets();
    }
    else
    {
        qDebug() << "Restoring all widgets";
        QeMaemo5DynamicWidgetHelper::globalInstance()->restoreWidgets<QuickWidget>();
    }

    if (!app.arguments().contains("in-background"))
    {
        // setting for new widget
        QuickWidgetSettings settingsDialog;
        settingsDialog.exec();
        //app.sendMessage(APP_MESSAGE_ADDWIDGET);
    }
    return app.exec();
}
