#ifndef QUICKWIDGET_HPP
#define QUICKWIDGET_HPP

#include <QtCore>
#include <QtGui>
#include <q-extras/qemaemo5dynamicwidgethelper.h>

class QDeclarativeView;
class QuickWidgetWrapper;


class QuickWidget : public QeMaemo5DynamicHomescreenWidget
{
    Q_OBJECT

private:
    void initView(const QString& fileName, const QSize& size=QSize());
    QSize size_;
    QDeclarativeView* view_;
    QuickWidgetWrapper* wrapper_;

protected:
//    void showSettingsDialog();
    bool restoreWidgetState();
    void errorWidget();
    bool x11Event(XEvent *event);
    void paintEvent(QPaintEvent *event);

public slots:
  void resizer(QSize size);

public:
    static QuickWidget *createAndShowNew(const QString& fileName, const QSize& size=QSize());

    explicit QuickWidget(QWidget *parent = 0);
    Q_INVOKABLE bool onHomescreen() { return isVisibleOnCurrentHomescreen(); }
    ~QuickWidget();

};

class QuickWidgetWrapper : public QObject
{
    Q_OBJECT

Q_SIGNALS:
    void onHomeScreenChanged();

public:
    QuickWidgetWrapper(QuickWidget *owner) : m_owner(owner) {;}
    Q_PROPERTY(bool isActiveWindow READ onHomeScreen NOTIFY onHomeScreenChanged);

    bool onHomeScreen() const { return homeScreen; }

    void setOnHomeScreen(bool active)
    {
        if (active == homeScreen)
            return;
        homeScreen = active;
        emit onHomeScreenChanged();
    }


private:
    QuickWidget *m_owner;
    bool homeScreen;


};

#endif // QuickWidget_HPP
