import Qt 4.7
import quickwidgets 1.0

Item {
     width: childrenRect.width
     height: childrenRect.height

     Rectangle {
     	  id: bg
          anchors.fill: txt
     	  color: "blue"
	  opacity: 0.8
	  radius: 5
     }
     Text {
     	  id: txt
	  smooth: true
	  font.pointSize: 12
	  wrapMode: Text.Wrap
     	  text: "Active Mem: MB"
	  verticalAlignment: Text.AlignVCenter
	  horizontalAlignment: Text.AlignHCenter
	  //width: parent.width
	  //height: parent.height
	  color: "white"
     }
     function parse(out) {
     	  var x = out.match(/[0-9]+/gi);
	  console.log(x)
     	  return "Active Mem: "+Math.round(x/1024)+ " MB"
     }
     Process {
     	  id: process
	  command: "sh -c \"cat /proc/meminfo | /bin/grep 'Active:'\""
	  onCompleted: { txt.text = parse(stdout) }
	  onFailed: { bg.color = "red"; txt.text = stderr }
     }
     Timer {
     	  running: runtime.isActiveWindow
     	  repeat: true
	  interval: 5000
	  onTriggered: { process.run() }
     }
}