/*
	quick-launch header
	
	@author	Daniele Maio (b0unc3) 
	@date	16/02/2010
	@update 17/10/2010
	@ver	0.9
	
*/
#ifndef __QUICK_LAUNCH_STATUS_MENU_ITEM_H__
#define __QUICK_LAUNCH_STATUS_MENU_ITEM_H__

#include <libhildondesktop/libhildondesktop.h>
#include <gconf/gconf-client.h>
#include <hildon/hildon.h>


G_BEGIN_DECLS
#define QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM            (quick_launch_status_menu_item_get_type ())
#define QUICK_LAUNCH_STATUS_MENU_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM, QuickLaunchStatusMenuItem))
#define QUICK_LAUNCH_STATUS_MENU_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM, QuickLaunchStatusMenuItemClass))
#define QUICK_LAUNCH_IS_STATUS_MENU_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM))
#define QUICK_LAUNCH_IS_STATUS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM))
#define QUICK_LAUNCH_STATUS_MENU_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM, QuickLaunchStatusMenuItemClass))
typedef struct _QuickLaunchStatusMenuItem QuickLaunchStatusMenuItem;

typedef struct _QuickLaunchStatusMenuItemClass
 QuickLaunchStatusMenuItemClass;

typedef struct _QuickLaunchStatusMenuItemPrivate
 QuickLaunchStatusMenuItemPrivate;

struct _QuickLaunchStatusMenuItem {
	HDStatusMenuItem parent;

	QuickLaunchStatusMenuItemPrivate *priv;
};

struct _QuickLaunchStatusMenuItemClass {
	HDStatusMenuItemClass parent;
};

GType quick_launch_status_menu_item_get_type (void);


/**/

#define APPS_DIR	"/usr/share/applications/hildon/"
#define SERVICES_DIR	"/usr/share/dbus-1/services/"
#define APP_NAME	"quicklaunch"
#define GCONF_DIR 	"/apps/Maemo/"
#define APP_GCONF_KEY	GCONF_DIR"quicklaunch/"
#define LOCALES_DIR	"/usr/share/locale"
#define ICON_PATH 	"/usr/share/pixmaps/quicklaunch-search.png"


static gchar 		*names[4];
static gchar		*icons[4];
static gchar 		*ossos[4];
gchar			*bins[4];
GtkWidget 		*btns[4];
static gchar 		*group_name[4] = { "first", "second", "third", "fourth" };
static GtkWidget 	*confirm;
static GtkWidget 	*window;
static GtkWidget 	*shutter,*pkey;
static GConfClient	*client;
HildonDialog 		*d;

void parse_info (GConfClient* client, gboolean big_icon);
gboolean load_app(GtkWidget *widget , gpointer data);
gboolean app_search_button_release(GtkWidget* widget, GdkEventButton *event);
gboolean app_search_filter_app_list_func(GtkTreeModel* model, GtkTreeIter* iter, gpointer data);
/**/

G_END_DECLS
#endif
