#include <glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <libhal.h>
#include <mce/dbus-names.h>
#include <gconf/gconf-client.h>
#include <sys/types.h>
#include <regex.h>


#include "quick-launch.h"


const char *hal_key = NULL;
DBusError dbus_err;
static LibHalContext *halctx;
static gchar *cam_shutter_udi = "/org/freedesktop/Hal/devices/platform_cam_shutter";



static gboolean
is_running(int w)
{
    FILE *process_listing;
    char line[130];
    int counter = 0;

    char *pattern;
    if ( w == 0 )
	    pattern = "quick-launch-dialog";
    else pattern = "camera-ui";

    int regex_result;
    regex_t re;


    regcomp(&re, pattern, REG_EXTENDED|REG_NOSUB);
    process_listing=popen("ps ax", "r");

    while ( fgets( line, sizeof line, process_listing))
    {
        regex_result=regexec(&re, line, (size_t) 0, NULL, 0);


        if (regex_result==0)
        {
            return TRUE; 
        }
    }
    
    return FALSE;

}

static gboolean
is_locked()
{
	GError *error = NULL;
        DBusGConnection *connection;
        DBusGProxy *proxy;
        gchar *state = NULL;

	g_print ( "in i;l\n");

	connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
	if (!connection) {
		g_printerr ("Failed to open connection to system bus: %s\n", error->message);
		g_clear_error (&error);
		return FALSE;
	}
	
	proxy = dbus_g_proxy_new_for_name (connection, MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF);
	if (!proxy)
		return FALSE;

	if (!dbus_g_proxy_call (proxy, MCE_TKLOCK_MODE_GET, &error, G_TYPE_INVALID, G_TYPE_STRING, &state, G_TYPE_INVALID)) {
		if (error->domain == DBUS_GERROR && error->code == DBUS_GERROR_REMOTE_EXCEPTION) 
			g_printerr ("Caught remote method exception %s: %s", dbus_g_error_get_name (error), error->message);
		else
	    	g_printerr ("Failed to call method: %s\n", error->message);
		g_clear_error (&error);
	}
	if (state) {
		g_print("current state = %s\n",state);
		if ( g_strcmp0("locked",state) == 0 ) {
			g_free (state);

        		g_object_unref (proxy);
        		dbus_g_connection_flush (connection);
        		dbus_g_connection_unref (connection);
			return TRUE;
		} else if ( g_strcmp0("unlocked",state) == 0 ) {
			g_free (state);

			g_object_unref (proxy);
			dbus_g_connection_flush (connection);
			dbus_g_connection_unref (connection);
			return FALSE;
		}
	} else
		g_print ("Unable to get Call state");

	g_free (state);

	g_object_unref (proxy);
	dbus_g_connection_flush (connection);
	dbus_g_connection_unref (connection);
	

	return FALSE;
}

static void set_hal_uid (GConfClient *client)
{
	gchar *sval;
	gchar *pval;
	
	//remove ancient property_watch
	libhal_device_remove_property_watch (halctx, cam_shutter_udi, &dbus_err);
	
	if (gconf_entry_get_value (g_strdup_printf("%sshutter",APP_GCONF_KEY)) != NULL) {
		if ( gconf_client_get_bool (GCONF_CLIENT(client),g_strdup_printf("%sshutter",APP_GCONF_KEY),  NULL) )
			libhal_device_add_property_watch(halctx, cam_shutter_udi, &dbus_err);
	} 
	
	printf("hal_key changed to = %s\n",hal_key);

	
}

static void cond ( LibHalContext *ctx,
		const char *interface_name,
		const char *lock_owner,
		int num_locks)
{
	g_print("in cond , if=%s , lo=%s, nl=%d\n",interface_name,lock_owner,num_locks);
	gint argc;
	gchar **argv;
	pid_t pid;
	GError *error;
	
	
	
	
	system("killall -9 camera-ui");
	if ( !is_locked() && !is_running(0) ) { //execute only if the screen is unlocked
	
		if ( !libhal_device_get_property_bool ( ctx, cam_shutter_udi, "button.state.value", NULL ) ) { //shutter is open
			g_print("screen active\n");
			g_print("not locked,not running, shutter open \n");
		
			if (g_shell_parse_argv("/usr/bin/quick-launch-dialog",&argc,&argv,NULL)) {
				if ( g_spawn_async(NULL,argv,NULL,(GSpawnFlags)G_SPAWN_SEARCH_PATH,NULL,NULL,&pid,&error) ) {
					g_print("close pid id:%d\n",pid);
					g_spawn_close_pid (pid);
					return FALSE;
				} else return FALSE;
			} else return FALSE;
			
			if (error)
			{
				hildon_banner_show_information(NULL, NULL, "Execution failed");
				g_error_free(error);
				return FALSE;
			}
		} else return FALSE;
			
	} else g_print("screen locked!\n");
}


int main ( int argc, char *argv[] )
{
	GMainLoop *loop = g_main_loop_new(NULL,FALSE);
	halctx = libhal_ctx_new();
	GConfClient* client;
	DBusConnection *dbus_sys;

	
	g_type_init();
	
	dbus_sys = dbus_bus_get(DBUS_BUS_SYSTEM, &dbus_err);
	if ( dbus_error_is_set(&dbus_err) || dbus_sys==NULL ) {
        	printf("system dbus init fail\n");
        	return 1;
    	}
	dbus_connection_setup_with_g_main(dbus_sys, NULL);
	if( !libhal_ctx_set_dbus_connection(halctx, dbus_sys) )
	{
		printf("hal dbus connection fail\n");
		return 1;
	}
	if( !libhal_ctx_init(halctx, &dbus_err) )
	{
		printf("hal init fail: %s\n", dbus_err.message);
		return 1;
    	}


	libhal_ctx_set_device_condition(halctx, cond);
	
	client = gconf_client_get_default();
	
	gconf_client_add_dir(client,
                       g_strdup_printf("%s%s",GCONF_DIR,APP_NAME),
                       GCONF_CLIENT_PRELOAD_NONE,
                       NULL);

  	gconf_client_notify_add(client, g_strdup_printf("%sshutter",APP_GCONF_KEY),
                          set_hal_uid,
                          NULL,
                          NULL, NULL);
	
/*
  	gconf_client_notify_add(client, g_strdup_printf("%spower_key",APP_GCONF_KEY),
                          set_hal_uid,
                          NULL,
                          NULL, NULL);
*/                          
	set_hal_uid (client);

	g_main_loop_run( loop );

	libhal_ctx_shutdown(halctx, &dbus_err);
	libhal_ctx_free(halctx);
	dbus_connection_unref(dbus_sys);
	
	return 0;
}
