/*

queen-beecon.c - Queen Beecon Widget
http://talk.maemo.org/showthread.php?t=45388

Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)

From and idea/application by cpscotti (Clovis Peruchi Scotti)
(Desktop Command Execution Widget http://talk.maemo.org/showthread.php?t=39177)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

[No!No!No!Yes!]
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <hildon/hildon.h>

#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <stdlib.h>
#include <string.h>
#include <time.h> /* For tm. */
#include <sys/wait.h>

#include <conic.h>

#include "queen-beecon-logger.h"
#include "queen-beecon.h"
#include "queen-beecon-progress-animation.h"
#include "queen-beecon-dbus-monitor.h"
#include "queen-beecon-settings-manager.h"
#include "queen-beecon-advanced-tools-dialog.h"
#include "queen-beecon-dbus-service.h"
#include "queen-beecon-service.h"
#include "queen-beecon-exec-async.h"

#include "he-color-dialog.h"
#include "he-font-dialog.h"
#include "dbus-print-message.h"

#define _(String) dgettext("hildon-libs", String)

HD_DEFINE_PLUGIN_MODULE (QueenBeecon, queen_beecon, HD_TYPE_HOME_PLUGIN_ITEM);

static guint queen_beecon_signals[LAST_SIGNAL] = { 0 };

gchar *qbwExecReason[] = {
	"QBW_TIMER_UPDATE",
	"QBW_STARTUP_UPDATE",
	"QBW_SETTINGS_SAVE_RUN",
	"QBW_TEST_DRIVE",
	"QBW_WAKEUP_CLICK",
	"QBW_CLICK",
	"QBW_DESKTOP_SWITCH",
	"QBW_CONNECTION_EVENT",
	"QBW_DBUS_SET_PARAM_UPDATE",
	"QBW_DBUS_WAKEUP",
	"QBW_DBUS_UPDATE_CONTENT",
	"QBW_DBUS_EXEC",
	"QBW_DBUS_MONITOR",
	NULL
};

struct _colorsRGB p_colors[] = {//AP3
		{"Black",	"#000000" },
		{"White", 	"#FFFFFF" },
		{"Gray",	"#808080" },
		{"Lime",	"#00FF00" },
		{"Yellow",	"#FFFF00" },
		{"Red",		"#FF0000" },
		{"Magenta",	"#FF00FF" },
		{"Silver",	"#C0C0C0" },
		{"Olive",	"#808000" },
		{"Purple",	"#800080" },
		{"Maroon",	"#800000" },
		{"Aqua",	"#00FFFF" },
		{"Teal",	"#008080" },
		{"Green",	"#008000" },
		{"Blue",	"#0000FF" },
		{"Navy",	"#000080" },
		{NULL,		"#000000" }
};

gchar * p_justification[] = {//AP3
	"Left","Right","Center","Fill", NULL};//AP1

gchar * p_visible_position[] = {//AP3
	"Hidden","Top Left","Top Center","Top Right","Center Left","Center","Center Right","Bottom Left","Bottom Center","Bottom Right",NULL};//AP1

gchar * p_fonts[] = {//AP1
		"Nokia Sans","NewCourier","NewTimes","Monospace","Nokia Sans Cn","Nokia Sans Maps","Nokia Sans SemiBold","Sans","Serif","SwissA","Tanseek Pro Arabic","Univers OTS Arabic",NULL};//AP1

gchar * p_fonts_types[] = {//AP1
	 "regular", "italic", "bold","bold italic", NULL};//AP1

//widget/touchscreen interaction callbacks
gboolean queen_beecon_button_press (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
	if (self->priv->clicksTimerID) {g_source_remove (self->priv->clicksTimerID);self->priv->clicksTimerID=0;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s widget=%p click=%d x,y(%f,%f)", self, G_STRFUNC, widget, event->type, event->x, event->y);
	if (self->priv->operationalStatus==1 || self->priv->updOnClick) {
		self->priv->isPressed = TRUE;
		//* New: Parameter Variables substitution for using with scripts which holds the type of click issued on touch screen $QBW_IS_FINGER_TAP (true=Touch Screen was tapped with a finger; false=Touch Screen was clicked with stylus)
		//self->priv->isFingerTap = hildon_helper_event_button_is_finger(event);
		if (event->type==GDK_BUTTON_PRESS) self->priv->clicksCount++;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
	return FALSE;
}

gboolean queen_beecon_button_release (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
	if (self->priv->clicksTimerID) {g_source_remove (self->priv->clicksTimerID);self->priv->clicksTimerID=0;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s widget=%p event=%d x,y(%f,%f)", self, G_STRFUNC, widget, event->type, event->x, event->y);
	self->priv->clickX = (gint)event->x;
	self->priv->clickY = (gint)event->y;
	self->priv->clicksTimerID = g_timeout_add( 150, (GSourceFunc)queen_beecon_button_release_exec, self);
	self->priv->isPressed = FALSE;
	gtk_widget_queue_draw (GTK_WIDGET (self));
	return FALSE;
}

gboolean queen_beecon_leave_event (GtkWidget *widget, GdkEventCrossing *event, QueenBeecon *self)
{
	if (self->priv->clicksTimerID) {g_source_remove (self->priv->clicksTimerID);self->priv->clicksTimerID=0;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s widget=%p", self, G_STRFUNC, widget);
	if (self->priv->clickExecInProgress==FALSE) self->priv->clicksCount = 0;
	if (self->priv->operationalStatus==1 || self->priv->updOnClick ) {
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
	return FALSE;
}

gboolean queen_beecon_button_release_exec (QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s", self, G_STRFUNC);
	if (self->priv->clickExecInProgress==TRUE) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) clickExecInProgress=TRUE : No conditions to EXEC", self);
		return FALSE;
	}
	else self->priv->clickExecInProgress = TRUE;

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) Click Execute", self);
	if (self->priv->operationalStatus==1 && self->priv->clicksCount>1) { // Wake up and restore size and operations on double click
		self->priv->isPressed = FALSE;
		self->priv->operationalStatus=0;
		queen_beecon_write_settings (self, TRUE);
		if (self->priv->updOnDBUS && self->priv->dbus_mon_connection==NULL && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS monitor starting, rearm connection, match and filter", self);
			if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
				self->priv->updOnDBUS          = 0;
			}
		}
		if (self->priv->updOnStartup && !self->priv->updOnDBUS) { // do we have to update on startup?
			queen_beecon_update_content (self, qbwExecReason[QBW_WAKEUP_CLICK]);
		} else {
			queen_beecon_update_content_layout (self); // No... only update layout
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) RESET clickExecInProgress...",self);
			self->priv->clickExecInProgress = FALSE;
		}
	} else if (self->priv->updOnClick) {
		self->priv->hotSpotIndex = self->priv->clickX/((gint)self->priv->widWidth/3) + 3*(self->priv->clickY/((gint)self->priv->widHeight/3)) + 1;
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hotSpotIndex = %d self->priv->clicksCount = %d self->priv->clickX = %d self->priv->clickY = %d", self, self->priv->hotSpotIndex, self->priv->clicksCount, self->priv->clickX, self->priv->clickY);
		self->priv->isPressed = FALSE;
		if (self->priv->hotSpotIndex!=0 && self->priv->clicksCount!=0 && self->priv->clickX != -1 && self->priv->clickY != -1) {//Conditions to go?
			queen_beecon_update_content(self, qbwExecReason[QBW_CLICK]);
		} else {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) RESET clickExecInProgress...",self);
			self->priv->clickExecInProgress = FALSE;
		}
	}
	gtk_widget_queue_draw (GTK_WIDGET (self));
	return FALSE;
}

void queen_beecon_check_desktop (GObject *gobject, GParamSpec *pspec, QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
    g_object_get (gobject, "is-on-current-desktop", &self->priv->qbwOnSight, NULL);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Desktop ON/OFF=%d", self, self->priv->qbwOnSight);

    if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
    if (self->priv->qbwOnSight && self->priv->updOnDesktop) {
		queen_beecon_update_content (self, qbwExecReason[QBW_DESKTOP_SWITCH]);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

gboolean queen_beecon_connection_event (ConIcConnection *connection, ConIcConnectionEvent *event, QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", self, G_STRFUNC);
	ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
	const gchar *aux;

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwHttpProxy = %p [%s]", self, self->priv->qbwHttpProxy, self->priv->qbwHttpProxy);
    if (self->priv->qbwHttpProxy)   {g_free(self->priv->qbwHttpProxy);self->priv->qbwHttpProxy = NULL;}
    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwHttpsProxy = %p [%s]", self, self->priv->qbwHttpsProxy, self->priv->qbwHttpsProxy);
    if (self->priv->qbwHttpsProxy)  {g_free(self->priv->qbwHttpsProxy);self->priv->qbwHttpsProxy = NULL;}
    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwIgnoreHosts = %p [%s]", self, self->priv->qbwIgnoreHosts, self->priv->qbwIgnoreHosts);
	if (self->priv->qbwIgnoreHosts) {g_free(self->priv->qbwIgnoreHosts);self->priv->qbwIgnoreHosts = NULL;}
    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwFtpProxy = %p [%s]", self, self->priv->qbwFtpProxy, self->priv->qbwFtpProxy);
    if (self->priv->qbwFtpProxy)    {g_free(self->priv->qbwFtpProxy);self->priv->qbwFtpProxy = NULL;}
    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwSocksProxy = %p [%s]", self, self->priv->qbwSocksProxy, self->priv->qbwSocksProxy);
    if (self->priv->qbwSocksProxy)  {g_free(self->priv->qbwSocksProxy);self->priv->qbwSocksProxy = NULL;}
    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwRTSPProxy = %p [%s]", self, self->priv->qbwRTSPProxy, self->priv->qbwRTSPProxy);
    if (self->priv->qbwRTSPProxy)   {g_free(self->priv->qbwRTSPProxy);self->priv->qbwRTSPProxy = NULL;}
    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwAutoConfigProxy = %p [%s]", self, self->priv->qbwAutoConfigProxy, self->priv->qbwAutoConfigProxy);
    if (self->priv->qbwAutoConfigProxy)  {g_free(self->priv->qbwAutoConfigProxy);self->priv->qbwAutoConfigProxy = NULL;}

    if (status == CON_IC_STATUS_CONNECTED) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) CONNECTED", self);
        switch (con_ic_connection_get_proxy_mode(connection)) {
            case CON_IC_PROXY_MODE_NONE:
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) CON_IC_PROXY_MODE_NONE No proxies defined, it is direct connection", self);
                break;
            case CON_IC_PROXY_MODE_MANUAL:
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) CON_IC_PROXY_MODE_MANUAL", self);
                aux = con_ic_connection_get_proxy_host(connection, CON_IC_PROXY_PROTOCOL_HTTP);
        		if (aux) if (g_strcmp0(aux, "")) self->priv->qbwHttpProxy = g_strdup_printf("%s:%d", aux, con_ic_connection_get_proxy_port(connection, CON_IC_PROXY_PROTOCOL_HTTP));
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) HTTP  proxy [%s] in use", self, self->priv->qbwHttpProxy);

				aux = con_ic_connection_get_proxy_host(connection, CON_IC_PROXY_PROTOCOL_HTTPS);
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) aux=[%s]", self, aux);
                if (aux) if (g_strcmp0(aux, "")) self->priv->qbwHttpsProxy = g_strdup_printf("%s:%d", aux, con_ic_connection_get_proxy_port(connection, CON_IC_PROXY_PROTOCOL_HTTPS));
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) HTTPS proxy [%s] in use", self, self->priv->qbwHttpsProxy);

                aux = con_ic_connection_get_proxy_host(connection, CON_IC_PROXY_PROTOCOL_FTP);
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) aux=[%s]", self, aux);
                if (aux) if (g_strcmp0(aux, "")) self->priv->qbwFtpProxy = g_strdup_printf("%s:%d", aux, con_ic_connection_get_proxy_port(connection, CON_IC_PROXY_PROTOCOL_FTP));
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) FTP   proxy [%s] in use", self, self->priv->qbwFtpProxy);

                aux = con_ic_connection_get_proxy_host(connection, CON_IC_PROXY_PROTOCOL_SOCKS);
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) aux=[%s]", self, aux);
                if (aux) if (g_strcmp0(aux, "")) self->priv->qbwSocksProxy = g_strdup_printf("%s:%d", aux, con_ic_connection_get_proxy_port(connection, CON_IC_PROXY_PROTOCOL_SOCKS));
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) SOCKS proxy [%s] in use", self, self->priv->qbwSocksProxy);

                aux = con_ic_connection_get_proxy_host(connection, CON_IC_PROXY_PROTOCOL_RTSP);
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) aux=[%s]", self, aux);
                if (aux) if (g_strcmp0(aux, "")) self->priv->qbwRTSPProxy = g_strdup_printf("%s:%d", aux, con_ic_connection_get_proxy_port(connection, CON_IC_PROXY_PROTOCOL_RTSP));
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) RTSP  proxy [%s] in use", self, self->priv->qbwRTSPProxy);

            	GSList *qbwIgnoreHosts = con_ic_connection_get_proxy_ignore_hosts(connection);
            	{
        			GSList *iter;
        			gchar *b = NULL;
        			gboolean first = TRUE;
        			for (iter = qbwIgnoreHosts; iter != NULL; iter = g_slist_next(iter)) {
        				if (first) {
        					self->priv->qbwIgnoreHosts = g_strdup_printf("%s", (gchar *)iter->data);
        					first = FALSE;
        				} else {
            				b = self->priv->qbwIgnoreHosts;
        					self->priv->qbwIgnoreHosts = g_strdup_printf("%s;%s", b, (gchar *)iter->data);
            				g_free (b);
        				}
        				g_free(iter->data);
        			}
    				g_slist_free(qbwIgnoreHosts);
            	}
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) IGNORE HOSTS proxy [%s] in use", self, self->priv->qbwIgnoreHosts);

                break;
            case CON_IC_PROXY_MODE_AUTO:
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) CON_IC_PROXY_MODE_AUTO", self);
                self->priv->qbwAutoConfigProxy = g_strdup (con_ic_connection_get_proxy_autoconfig_url(connection));
                qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) AUTO proxy URL [%s] in use", self, self->priv->qbwAutoConfigProxy);
                break;
        }
		self->priv->isConnected = TRUE;
	} else {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DISCONNECTED", self);
        self->priv->isConnected = FALSE;
	}
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return TRUE;
	}
	if(self->priv->updNeworkPolicy != NETWORK__UNRELATED) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NETWORK EVENT Need to trigger content update!", self);
		queen_beecon_update_content(self, qbwExecReason[QBW_CONNECTION_EVENT]);
	}
	return TRUE;
}

//Content/widget creation/update
void queen_beecon_content_create (QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", self, G_STRFUNC);
	self->priv->contents = gtk_event_box_new ();
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_event_box_new ()= %p",self, self->priv->contents);
	gtk_event_box_set_visible_window (GTK_EVENT_BOX (self->priv->contents), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->contents), 0);

	self->priv->tableLayout = gtk_table_new(1, 1, FALSE);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) tableLayout gtk_table_new ()= %p",self, self->priv->tableLayout);

	self->priv->tableHotSpots = gtk_table_new(1, 1, FALSE);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) tableHotSpots gtk_table_new ()= %p",self, self->priv->tableHotSpots);
	gtk_table_set_homogeneous(GTK_TABLE(self->priv->tableHotSpots), TRUE);
	self->priv->hotSpot = gtk_label_new ("");
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) HotSpot = Label(%p)", self, self->priv->hotSpot);
	self->priv->hotSpotEvent = gtk_event_box_new ();
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) gtk_event_box_new HotSpot ()= %p",self, self->priv->hotSpotEvent);
	g_signal_connect (self->priv->hotSpotEvent, "button-release-event", G_CALLBACK (queen_beecon_button_release), self);
	g_signal_connect (self->priv->hotSpotEvent, "button-press-event", G_CALLBACK (queen_beecon_button_press), self);
	g_signal_connect (self->priv->hotSpotEvent, "leave-notify-event", G_CALLBACK (queen_beecon_leave_event), self);
	gtk_widget_set_events(GTK_WIDGET(self->priv->hotSpotEvent), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_LEAVE_NOTIFY_MASK);
	gtk_event_box_set_visible_window (GTK_EVENT_BOX (self->priv->hotSpotEvent), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->hotSpotEvent), 0);
	gtk_container_add (GTK_CONTAINER (self->priv->hotSpotEvent), self->priv->hotSpot);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) gtk_table_attach (w=%p)", self, self->priv->hotSpotEvent);
	gtk_table_attach(GTK_TABLE(self->priv->tableHotSpots), self->priv->hotSpotEvent, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->tableHotSpots, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	queen_beecon_exec_progress_animation(self, QBW_PROGRESS_ANIMATION_INIT);

	// Create Title/Result Label
	self->priv->cmdTitle_lb = gtk_label_new ("Not Updated");
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdTitle_lb gtk_label_new ()= %p",self, self->priv->cmdTitle_lb);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_table_attach self->priv->cmdTitle_lb=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_lb, self->priv->tableLayout);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_lb, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	self->priv->cmdResult_lb = gtk_label_new ("Not Updated");
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdResult_lb gtk_label_new ()= %p",self, self->priv->cmdResult_lb);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_table_attach self->priv->cmdResult_lb=%p self->priv->tableLayout=%p", self, self->priv->cmdResult_lb, self->priv->tableLayout);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->cmdResult_lb), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	GtkWidget *box = gtk_hbox_new (FALSE, 0);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) box gtk_hbox_new ()= %p",self, box);
	gtk_box_pack_start (GTK_BOX (box), self->priv->tableLayout, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self->priv->contents), box);

	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->contents, FALSE, FALSE, 0);

	gtk_widget_show_all (self->priv->homeWidget);
}

void queen_beecon_update_content_layout (QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", self, G_STRFUNC);
	GdkColor color;
	PangoFontDescription *fd = NULL;//AP1
	gboolean isCmdImage = FALSE, isResImage = FALSE;
	gint rsImgZoomW=0, rsImgZoomH=0;
	gint cmImgZoomW=0, cmImgZoomH=0;
	gchar *rsImgFilename = NULL, *auxrsImgFilename = NULL, *sysrsImgFilename = NULL, *cmdImgFilename = NULL, *auxcmdImgFilename = NULL, *syscmdImgFilename = NULL;
	gchar *noImgFilename = g_strdup_printf("%s%s", SYSTEM_PUBLIC_ICON_DIR, "queen-beecon-noimg.png");

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) No Image filename=[%s]", self, noImgFilename);

	if(self->priv->instanceCmd == NULL || self->priv->instanceTitle == NULL) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdTitle_lb), "Error:");
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), "No commands");
		return;
	}

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->hotSpot), self->priv->widWidth, self->priv->widHeight);

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
	gtk_label_set_markup (GTK_LABEL (self->priv->cmdTitle_lb), self->priv->instanceTitle);

	if (self->priv->cmdResult_img) {gtk_widget_destroy(GTK_WIDGET(self->priv->cmdResult_img)); self->priv->cmdResult_img = NULL;}
	if (self->priv->cmdTitle_img) {gtk_widget_destroy(GTK_WIDGET(self->priv->cmdTitle_img)); self->priv->cmdTitle_img = NULL;}

	if (self->priv->operationalStatus==1) { // Widget instance is disabled and minimized on screen
		// Let's define widget geometry and size
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled Updating widget geometry w=%0.0f h=%0.0f",self, (float)60, (float)60);
		gtk_widget_set_size_request (GTK_WIDGET (self), (int)60, (int)60);//AP
		gtk_window_resize (GTK_WINDOW (self), (int)60, (int)60);//AP

		gtk_widget_set_size_request(GTK_WIDGET(self->priv->hotSpot), 60, 60);

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled Let's process TITLE Output: Do we need result Image or Text?", self);
		syscmdImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, "queen-beecon-zzz.png", NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled syscmdImgFilename = %s", self, syscmdImgFilename);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled noImgFilename = %s", self, noImgFilename);
		GdkPixbuf      *cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (syscmdImgFilename, -1, -1, TRUE, NULL);
		if (!cmdPixBuf) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, -1, -1, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled cmdPixBuf = %p", self, cmdPixBuf);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled self->priv->cmdTitle_img = %p", self, self->priv->cmdTitle_img);
		self->priv->cmdTitle_img = gtk_image_new_from_pixbuf (cmdPixBuf);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdTitle_img gtk_image_new_from_pixbuf (cmdPixBuf)= %p", self, self->priv->cmdTitle_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_img), 60, 60);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_img),0.5,0.1);
		g_object_unref (cmdPixBuf);
		g_free(syscmdImgFilename);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_table_attach self->priv->cmdTitle_img=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_img, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
		if (!self->priv->widgetVisible) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img)); %p", self, self->priv->cmdTitle_img);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));
		}
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img)); %p", self, self->priv->cmdResult_img);
		if (self->priv->cmdResult_img) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));// Visible

		// Update Results Layout (Label/image Font + Colors + Alignment + Position + ...)
		fd = pango_font_description_from_string("Nokia,Sans 9");//AP1
		gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdTitle_lb), fd);//AP1
		gdk_color_parse("#FFFFFF", &color);
		gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdTitle_lb), GTK_STATE_NORMAL, &color); // White text
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), 60, 60);
		gtk_label_set_angle(GTK_LABEL(self->priv->cmdTitle_lb), 0);//
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),0.5,1.0); // Bottom Center aligned
		gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 1, 1);//AP1
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb));
		if (!self->priv->widgetVisible) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb)); %p", self, self->priv->cmdTitle_lb);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));
		}

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb)); %p", self, self->priv->cmdResult_lb);
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));// Visible

		g_free(noImgFilename);noImgFilename=NULL;
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Done drawing disabled instance", self);
		return;
	}

	// Let's define widget geometry and size
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Updating widget geometry w=%0.0f h=%0.0f",self, self->priv->widWidth, self->priv->widHeight);
	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP
	gtk_window_resize (GTK_WINDOW (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), self->priv->widWidth, self->priv->widHeight);
	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_lb), self->priv->widWidth, self->priv->widHeight);

	// Update Results Layout (Label/image Font + Colors + Alignment + Position + ...)
	fd = pango_font_description_from_string(self->priv->resExtFont);//AP1
	gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdResult_lb), fd);//AP1

	gdk_color_parse(self->priv->resExtFgRGB,&color);
	gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdResult_lb), GTK_STATE_NORMAL, &color);
	if (self->priv->resVisibilityPosition) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) resVisibilityPosition self->priv->cmdResult_lb Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->resVisibilityPosition, ((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_lb),((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
	}
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdResult_lb), 2, 2);//AP1
	gtk_label_set_angle(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resTextAngle*90.00);//
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resJustify);
	if (self->priv->resVisibilityPosition && self->priv->widgetVisible) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) showing self->priv->cmdResult_lb=%p", self, self->priv->cmdResult_lb);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_lb));
	} else {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hiding self->priv->cmdResult_lb=%p", self, self->priv->cmdResult_lb);
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));
	}
	//v Results Image
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Let's process RESULT Output: Do we need result Image or Text?", self);
	if (self->priv->widgetType!=0) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm SNIPPET (resImgFilename=%s)", self, self->priv->resImgFilename);
		if (self->priv->resImgFilename[0]!='\0' && self->priv->resImgFilename[0]!=';') {
			if (self->priv->resImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
				rsImgFilename = g_strconcat (self->priv->resImgFilename, NULL);
			} else {
				rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->resImgFilename, NULL);
				auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->resImgFilename, NULL);
				sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->resImgFilename, NULL);
			}
			gint w=48,h=48;
			GdkPixbufFormat *resPixBufFmt = NULL;
			if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
			if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
			rsImgZoomW=self->priv->resImgZoom==0?-1:self->priv->resImgZoom==1?self->priv->widWidth:(self->priv->resImgZoom-1)*w*5/100;
			rsImgZoomH=self->priv->resImgZoom==0?-1:self->priv->resImgZoom==1?self->priv->widHeight:(self->priv->resImgZoom-1)*h*5/100;
			isResImage=TRUE;
		}
	} else {//AP3
		switch (self->priv->cmdExitStatus) {
		case -1:
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm BEECON (lt0=%s)", self, self->priv->beecon_lt0_ImgFilename);
			if (self->priv->beecon_lt0_ImgFilename[0]!='\0' && self->priv->beecon_lt0_ImgFilename[0]!=';') {
				if (self->priv->beecon_lt0_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_lt0_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_lt0_ImgZoom==0?-1:self->priv->beecon_lt0_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_lt0_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_lt0_ImgZoom==0?-1:self->priv->beecon_lt0_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_lt0_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 0:
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm BEECON (eq0=%s)", self, self->priv->beecon_eq0_ImgFilename);
			if (self->priv->beecon_eq0_ImgFilename[0]!='\0' && self->priv->beecon_eq0_ImgFilename[0]!=';') {
				if (self->priv->beecon_eq0_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_eq0_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_eq0_ImgZoom==0?-1:self->priv->beecon_eq0_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_eq0_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_eq0_ImgZoom==0?-1:self->priv->beecon_eq0_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_eq0_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 1:
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm BEECON (eq1=%s)", self, self->priv->beecon_eq1_ImgFilename);
			if (self->priv->beecon_eq1_ImgFilename[0]!='\0' && self->priv->beecon_eq1_ImgFilename[0]!=';') {
				if (self->priv->beecon_eq1_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_eq1_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_eq1_ImgZoom==0?-1:self->priv->beecon_eq1_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_eq1_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_eq1_ImgZoom==0?-1:self->priv->beecon_eq1_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_eq1_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 2:
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm BEECON (ge2=%s)", self, self->priv->beecon_ge2_ImgFilename);
			if (self->priv->beecon_ge2_ImgFilename[0]!='\0' && self->priv->beecon_ge2_ImgFilename[0]!=';') {
				if (self->priv->beecon_ge2_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_ge2_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_ge2_ImgZoom==0?-1:self->priv->beecon_ge2_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_ge2_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_ge2_ImgZoom==0?-1:self->priv->beecon_ge2_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_ge2_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		default:
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm BEECON (idxge2=%s)", self, self->priv->beecon_idxge2_ImgFilename);
			if (self->priv->beecon_idxge2_ImgFilename[0]!='\0' && self->priv->beecon_idxge2_ImgFilename[0]!=';') {
				if (self->priv->beecon_idxge2_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strdup_printf("%s.%d", self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
				} else {
					rsImgFilename = g_strdup_printf("%s%s%s.%d", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
					auxrsImgFilename = g_strdup_printf("%s%s%s.%d", HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
					sysrsImgFilename = g_strdup_printf("%s%s.%d", SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_idxge2_ImgZoom==0?-1:self->priv->beecon_idxge2_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_idxge2_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_idxge2_ImgZoom==0?-1:self->priv->beecon_idxge2_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_idxge2_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		}
	}//AP3
	if (isResImage) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) rsImgZoomW=%d rsImgZoomH=%d", self, rsImgZoomW, rsImgZoomH);
		GdkPixbuf     *rsPixBuf = NULL;
		if (auxrsImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (auxrsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) rsPixBuf = %p auxrsImgFilename = %s", self, rsPixBuf, auxrsImgFilename);
		if (!rsPixBuf) if (rsImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (rsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) rsPixBuf = %p rsImgFilename = %s", self, rsPixBuf, rsImgFilename);
		if (!rsPixBuf) if (sysrsImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (sysrsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) rsPixBuf = %p sysrsImgFilename = %s", self, rsPixBuf, sysrsImgFilename);
		if (!rsPixBuf) if (noImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file (noImgFilename, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) rsPixBuf = %p noImgFilename = %s", self, rsPixBuf, noImgFilename);

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdResult_img = %p", self, self->priv->cmdResult_img);
		GdkPixbuf *rotPixBuf = gdk_pixbuf_rotate_simple (rsPixBuf, self->priv->resImgAngle*90);
		g_object_unref (rsPixBuf); rsPixBuf=rotPixBuf;
		self->priv->cmdResult_img = gtk_image_new_from_pixbuf (rsPixBuf);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdResult_img gtk_image_new_from_pixbuf (rsPixBuf)= %p", self, self->priv->cmdResult_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_img), self->priv->widWidth, self->priv->widHeight);
		if (self->priv->resImgVisibilityPosition) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) resImgVisibilityPosition self->priv->cmdResult_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->resImgVisibilityPosition, ((self->priv->resImgVisibilityPosition-1)%3)*0.5,((self->priv->resImgVisibilityPosition-1)/3)*0.5);
			gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_img),((self->priv->resImgVisibilityPosition-1)%3)*0.5,((self->priv->resImgVisibilityPosition-1)/3)*0.5);
		}
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdResult_img = %p", self, self->priv->cmdResult_img);
		g_object_unref (rsPixBuf);
		g_free(rsImgFilename);
		g_free(auxrsImgFilename);
		g_free(sysrsImgFilename);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_table_attach self->priv->cmdResult_img=%p self->priv->tableLayout=%p", self, self->priv->cmdResult_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->cmdResult_img), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		if (self->priv->resImgVisibilityPosition && self->priv->widgetVisible) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) showing self->priv->cmdResult_img=%p", self, self->priv->cmdResult_img);
			gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_img));
		} else {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hiding self->priv->cmdResult_img=%p", self, self->priv->cmdResult_img);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));//AP3
		}
	}
	//^ Results Image

	// Update Command Layout (Label/image Font + Colors + Alignment + Position + ...)
	fd = pango_font_description_from_string(self->priv->cmdExtFont);//AP1
	gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdTitle_lb), fd);//AP1

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), self->priv->widWidth, self->priv->widHeight);
	gdk_color_parse(self->priv->cmdExtFgRGB,&color);
	gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdTitle_lb), GTK_STATE_NORMAL, &color);
	if (self->priv->cmdVisibilityPosition) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdVisibilityPosition self->priv->cmdTitle_lb Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdVisibilityPosition, ((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	}
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 2, 2);//AP1
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdJustify);
	gtk_label_set_angle(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdTextAngle*90.00);//
	if (self->priv->cmdVisibilityPosition && self->priv->widgetVisible) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) showing self->priv->cmdTitle_lb=%p", self, self->priv->cmdTitle_lb);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb));
	} else {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hiding self->priv->cmdTitle_lb=%p", self, self->priv->cmdTitle_lb);
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));//AP3
	}

	//v Command Image
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Let's process TITLE Output: Do we need result Image or Text?", self);
	if (self->priv->cmdImgFilename[0]!='\0' && self->priv->cmdImgFilename[0]!=';') {
		if (self->priv->cmdImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
			cmdImgFilename = g_strconcat (self->priv->cmdImgFilename, NULL);
		} else {
			cmdImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->cmdImgFilename, NULL);
			auxcmdImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->cmdImgFilename, NULL);
			syscmdImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->cmdImgFilename, NULL);
		}
		isCmdImage=TRUE;

		gint w=48,h=48;
		GdkPixbufFormat *cmdPixBufFmt = NULL;
		if (auxcmdImgFilename) cmdPixBufFmt = gdk_pixbuf_get_file_info(auxcmdImgFilename,&w,&h);
		if (!cmdPixBufFmt) cmdPixBufFmt = gdk_pixbuf_get_file_info(cmdImgFilename,&w,&h);
		cmImgZoomW=self->priv->cmdImgZoom==0?-1:self->priv->cmdImgZoom==1?self->priv->widWidth:(self->priv->cmdImgZoom-1)*w*5/100;
		cmImgZoomH=self->priv->cmdImgZoom==0?-1:self->priv->cmdImgZoom==1?self->priv->widHeight:(self->priv->cmdImgZoom-1)*h*5/100;
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmImgZoomW=%d cmImgZoomH=%d", self, cmImgZoomW, cmImgZoomH);
		GdkPixbuf *cmdPixBuf = NULL;
		if (auxcmdImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (auxcmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdPixBuf = %p auxcmdImgFilename = %s", self, cmdPixBuf, auxcmdImgFilename);
		if (!cmdPixBuf) if (cmdImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (cmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdPixBuf = %p cmdImgFilename = %s", self, cmdPixBuf, cmdImgFilename);
		if (!cmdPixBuf) if (syscmdImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (syscmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdPixBuf = %p syscmdImgFilename = %s", self, cmdPixBuf, syscmdImgFilename);
		if (!cmdPixBuf) if (noImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file(noImgFilename, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdPixBuf = %p noImgFilename = %s", self, cmdPixBuf, noImgFilename);

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdTitle_img = %p", self, self->priv->cmdTitle_img);
		GdkPixbuf *rotPixBuf = gdk_pixbuf_rotate_simple (cmdPixBuf, self->priv->cmdImgAngle*90);
		g_object_unref (cmdPixBuf); cmdPixBuf=rotPixBuf;
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdPixBuf = %p", self, cmdPixBuf);
		self->priv->cmdTitle_img = gtk_image_new_from_pixbuf (cmdPixBuf);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdTitle_img gtk_image_new_from_pixbuf (cmdPixBuf)= %p", self, self->priv->cmdTitle_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_img), self->priv->widWidth, self->priv->widHeight);
		if (self->priv->cmdImgVisibilityPosition) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmdImgVisibilityPosition self->priv->cmdTitle_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdImgVisibilityPosition, ((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
			gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_img),((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		}
		g_object_unref (cmdPixBuf);
		g_free(cmdImgFilename);
		g_free(auxcmdImgFilename);
		g_free(syscmdImgFilename);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) gtk_table_attach self->priv->cmdTitle_img=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_img, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		if (self->priv->cmdImgVisibilityPosition && self->priv->widgetVisible) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) showing self->priv->cmdTitle_img=%p", self, self->priv->cmdTitle_img);
			gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
		} else {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hiding self->priv->cmdTitle_img=%p", self, self->priv->cmdTitle_img);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));//AP3
		}
	}
	//^ Command Image
	g_free(noImgFilename);noImgFilename=NULL;
}

void queen_beecon_blend_gradient(gint width, gint height, cairo_t *cr, cairo_pattern_t *pat, const gchar *colStr, double alphaUp, double alphaDown, gboolean isPressed)
{
	GdkColor color,color1;
	gdk_color_parse("#FFFFFF", &color1);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) queen_beecon_blend_gradient cr=%p pat=%p colStr=%s rgb(%d,%d,%d) alphaUp=%0.2f alphaDown=%0.2f isPressed=%d", NULL, cr, pat, colStr, color.red, color.green, color.blue, alphaUp, alphaDown, isPressed);
	gdk_color_parse(colStr, &color);
	if (!isPressed) {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, color1.red, color1.green, color1.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 4.0/height /*0.05*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 1.0-4.0/height /*0.95*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, 0, 0, 0, alphaUp);
	} else {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, 0, 0, 0, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 4.0/height /*0.05*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 1.0-4.0/height /*0.95*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, color1.red, color1.green, color1.blue, alphaDown);
	}
}

void queen_beecon_draw_canvas(GtkWidget *widget)
{
	QueenBeecon *self = QUEEN_BEECON (widget);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	cairo_t *cr=NULL;
	gint width, height, x, y;
	gint radius = 5;

	if (!self->priv->widgetVisible) return;

	width = widget->allocation.width;
	height = widget->allocation.height;
	x = widget->allocation.x;
	y = widget->allocation.y;

	if (self->priv->operationalStatus==1) { // Widget instance is hidden or disabled/minimized on screen... don't draw canvas
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Disabled drawing small canvas (snippet like) canvas...", self);
		cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
		cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

		cairo_set_source_rgba (cr, 0, 0, 0, .7);
		cairo_fill_preserve(cr);

		cairo_set_source_rgba (cr, 1, 1, 1, 1);
		cairo_set_line_width (cr, 1);
		cairo_stroke (cr);

		cairo_destroy(cr);
		return;
	}

	if (self->priv->hideCanvas && !self->priv->isPressed) return; // Don't draw canvas if not needed
	if (self->priv->hideClickCanvas && self->priv->isPressed) return; // Don't draw canvas if not needed

	cairo_pattern_t *pat = cairo_pattern_create_linear(width/2, 0, width/2, height-1);

	cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));

	if (self->priv->widgetType!=0) {
		queen_beecon_blend_gradient (width, height, cr, pat, self->priv->snippetExtBgRGB, 0.90, 0.65, self->priv->isPressed);
	} else {
		switch (self->priv->cmdExitStatus) {
		case -1:
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_lt0_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
			break;
		case 0:
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_eq0_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
			break;
		case 1:
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_eq1_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
			break;
		case 2:
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_ge2_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
			break;
		default:
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_idxge2_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
			break;
		}
	}//AP3

	cairo_set_line_join(cr, CAIRO_LINE_JOIN_ROUND);//AP3

//	if (self->priv->widgetType==0) {// Is Beecon ... draw cell
	if (self->priv->isPressed) {// Is pressed ... draw cell
		gint l= width / 4;//AP3
		gint h= height / 2;//AP3

		cairo_move_to(cr, x, y + h - 1);
		cairo_line_to(cr, x + l - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 3 - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 4 - 1, y + h - 1);
		cairo_line_to(cr, x + l * 3 - 1 , y);
		cairo_line_to(cr, x + l - 1 , y);
		cairo_line_to(cr, x, y + h - 1);
	}//AP3
//	if (self->priv->widgetType!=0 || self->priv->isPressed) {// Is snippet os isPressed ... draw rectangle
//	if (self->priv->widgetType!=0 || self->priv->isPressed) {// Is snippet os isPressed ... draw rectangle
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
//	}

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

	cairo_set_source(cr, pat);
	cairo_fill_preserve(cr);

	cairo_set_source_rgba (cr, 1, 1, 1, 1);
	cairo_set_line_width (cr, 1);
	cairo_stroke (cr);

	cairo_pattern_destroy(pat);
	cairo_destroy(cr);
}

static gboolean queen_beecon_async_startup_exec(QueenBeecon *self)
{
	queen_beecon_update_content (self, qbwExecReason[QBW_STARTUP_UPDATE]); // Yes ...
	return FALSE;
}

static gboolean queen_beecon_resize_hack(QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s", self, G_STRFUNC);
	if (!self->priv->widgetID) {
		hildon_banner_show_informationf (NULL, NULL, "(%p) QBW RESIZE HACK unsuccessful", self);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) RESIZE HACK unsuccessful", self);
		return FALSE;
	}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) REALIZE HACK calling queen_beecon_read_settings (self)", self);
	queen_beecon_read_settings (self, TRUE, FALSE, NULL);

	if (self->priv->updOnDBUS && self->priv->dbus_mon_connection==NULL && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS monitor starting, rearm connection, match and filter", self);
		if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
			self->priv->updOnDBUS          = 0;
		}
	}

	if( (self->priv->updateTimerID == 0) && (self->priv->delaySeconds > 0)) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
		self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
	}

	queen_beecon_exec_progress_animation(self, QBW_PROGRESS_ANIMATION_STOP);

	queen_beecon_update_content_layout (self);

	if (self->priv->updOnStartup && self->priv->operationalStatus==0) { // do we have to update on startup?
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) RESIZE HACK timered queen_beecon_update_content (self)", self);
		self->priv->startupExecTimerID = g_timeout_add (100, (GSourceFunc)queen_beecon_async_startup_exec, self);
	}
#ifdef NONONONONO
    GParamSpec** pspecs;
    GParamSpec* pspec;
    const gchar* property;
    GType type;
    guint i, n_properties;
    pspecs = g_object_class_list_properties (G_OBJECT_GET_CLASS(self), &n_properties);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) PROPERTY g_object_class_list_properties pspecs = %p n_properties = %d", self, pspecs, n_properties);
    for (i = 0; i < n_properties; i++) {
        pspec = pspecs[i];
        type = G_PARAM_SPEC_TYPE (pspec);
        property = g_param_spec_get_name (pspec);
    	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) PROPERTY property=[%s] type=[%d] ", self, property, type);
    	if (       !g_strcmp0(property,"can-focus")
    			|| !g_strcmp0(property,"has-focus")
    			|| !g_strcmp0(property,"is-focus")
    			) {
    		gboolean value;
    		g_object_get(self,property,&value,NULL);
    		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) PROPERTY property=[%s] value=[%d] ", self, property, value);
    	}
    }
#endif // NONONONONO
	return FALSE;
}

gboolean queen_beecon_update_content (QueenBeecon *self, const gchar *impulse)
{
	gint i;
	for (i=QBW_TIMER_UPDATE;qbwExecReason[i];i++) if (impulse==qbwExecReason[i]) break;
	if (i==QBW_LAST) i=QBW_TIMER_UPDATE;
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s [%s]", self, G_STRFUNC, qbwExecReason[i]);

	g_object_get (self, "is-on-current-desktop", &self->priv->qbwOnSight, NULL);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Desktop ON/OFF=%d", self, self->priv->qbwOnSight);

    if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm sleeping ... don't bother!", self);
		goto cancelOperation;
	}

	if(self->priv->updOnSight){
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) updOnSight [is-on-current-desktop=%d]",self, self->priv->qbwOnSight);
		if (!self->priv->qbwOnSight) {
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) I'm not On Sight!", self);
			goto cancelOperation;
		}
	}

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_CONNECTED && self->priv->isConnected == FALSE) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) updNeworkPolicy NETWORK__ONLY_CONNECTED && isConnected == FALSE",self);
		queen_beecon_update_content_layout (self); // Only update layout
		goto cancelOperation;
	}

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_DISCONNECTED && self->priv->isConnected == TRUE) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) updNeworkPolicy NETWORK__ONLY_DISCONNECTED && isConnected == TRUE",self);
		queen_beecon_update_content_layout (self); // Only update layout
		goto cancelOperation;
	}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) TEST execInProgress... %d", self, self->priv->execInProgress);
	if (self->priv->execInProgress==TRUE) {// Exec is already in progress ... don't do anything
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Exec already in progress...", self);
		//goto cancelOperation;
		return TRUE;
	} else {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) SET execInProgress...",self);
		self->priv->execInProgress = TRUE;
	}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) EXEC(%s) PREXPAND [%s]", self, qbwExecReason[i], self->priv->instanceCmd);
	gchar *instanceCmdSubst = queen_beecon_g_command_param_subst(self, self->priv->instanceCmd, qbwExecReason[i]);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) EXEC(%s) EXPANDED [%s]", self, qbwExecReason[i], instanceCmdSubst);

	//Start animation
    queen_beecon_exec_progress_animation(self, QBW_PROGRESS_ANIMATION_START);

	//Execute
    queen_beecon_async_execute(instanceCmdSubst, self);

	g_free(instanceCmdSubst);

	return(TRUE);

cancelOperation:
	self->priv->hotSpotIndex = 0;
	self->priv->clicksCount=0;
	self->priv->clickX = -1;
	self->priv->clickY = -1;
	//self->priv->isFingerTap=FALSE;
	return self->priv->operationalStatus==1?FALSE:TRUE; //
}

void queen_beecon_dispose (GObject *object)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", object, G_STRFUNC);
	G_OBJECT_CLASS (queen_beecon_parent_class)->dispose (object);
}

void queen_beecon_finalize (GObject *object)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", object, G_STRFUNC);
	QueenBeecon *self = QUEEN_BEECON (object);

	queen_beecon_exec_progress_animation(self, QBW_PROGRESS_ANIMATION_DEINIT);

	/* Remove update timer callback */
	if (self->priv->updateTimerID) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->updateTimerID = %d", self, self->priv->updateTimerID);
		g_source_remove (self->priv->updateTimerID); self->priv->updateTimerID = 0;
	}

	/* Remove startup exec timer callback */
	if (self->priv->startupExecTimerID) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->startupExecTimerID = %d", self, self->priv->startupExecTimerID);
		g_source_remove (self->priv->startupExecTimerID); self->priv->startupExecTimerID = 0;
	}

	/* Remove click timer callback */
	if (self->priv->clicksTimerID) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->clicksTimerID = %d", self, self->priv->clicksTimerID);
		g_source_remove (self->priv->clicksTimerID); self->priv->clicksTimerID = 0;
	}

	/* Remove animation timer callback */
	if (self->priv->timeout_id) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->timeout_id = %d", self, self->priv->timeout_id);
		g_source_remove( self->priv->timeout_id );self->priv->timeout_id = 0;
	}

	/* Remove child watch function for executed process */
	if (self->priv->child_watch_id) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->child_watch_id = %d", self, self->priv->child_watch_id);
		g_source_remove( self->priv->child_watch_id );
	}

	/* Remove io watch function for executed process */
	if (self->priv->io_watch_id) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->io_watch_id = %d", self, self->priv->io_watch_id);
		g_source_remove( self->priv->io_watch_id );
	}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->connection = %p", self, self->priv->connection);
	g_object_unref (self->priv->connection);

	queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule); // Disable DBUS Monitor

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->qbwDbusId = %p", self, self->priv->qbwDbusId);
	if (self->priv->qbwDbusId != NULL){g_free(self->priv->qbwDbusId);self->priv->qbwDbusId = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->c_titles = %p", self, self->priv->c_titles);
	g_strfreev(self->priv->c_titles); self->priv->c_titles = NULL;
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->c_commands = %p", self, self->priv->c_commands);
	g_strfreev(self->priv->c_commands);self->priv->c_commands = NULL;

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
	if (self->priv->beecon_lt0_ImgFilename != NULL){g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
	if (self->priv->beecon_eq0_ImgFilename != NULL){g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
	if (self->priv->beecon_eq1_ImgFilename != NULL){g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
	if (self->priv->beecon_ge2_ImgFilename != NULL){g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
	if (self->priv->beecon_idxge2_ImgFilename != NULL){g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->snippetExtBgRGB = %p", self, self->priv->snippetExtBgRGB);
	if (self->priv->snippetExtBgRGB != NULL){g_free(self->priv->snippetExtBgRGB);self->priv->snippetExtBgRGB = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_lt0_ExtBgRGB = %p", self, self->priv->beecon_lt0_ExtBgRGB);
	if (self->priv->beecon_lt0_ExtBgRGB != NULL){g_free(self->priv->beecon_lt0_ExtBgRGB);self->priv->beecon_lt0_ExtBgRGB = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq0_ExtBgRGB = %p", self, self->priv->beecon_eq0_ExtBgRGB);
	if (self->priv->beecon_eq0_ExtBgRGB != NULL){g_free(self->priv->beecon_eq0_ExtBgRGB);self->priv->beecon_eq0_ExtBgRGB = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq1_ExtBgRGB = %p", self, self->priv->beecon_eq1_ExtBgRGB);
	if (self->priv->beecon_eq1_ExtBgRGB != NULL){g_free(self->priv->beecon_eq1_ExtBgRGB);self->priv->beecon_eq1_ExtBgRGB = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_ge2_ExtBgRGB = %p", self, self->priv->beecon_ge2_ExtBgRGB);
	if (self->priv->beecon_ge2_ExtBgRGB != NULL){g_free(self->priv->beecon_ge2_ExtBgRGB);self->priv->beecon_ge2_ExtBgRGB = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_idxge2_ExtBgRGB = %p", self, self->priv->beecon_idxge2_ExtBgRGB);
	if (self->priv->beecon_idxge2_ExtBgRGB != NULL){g_free(self->priv->beecon_idxge2_ExtBgRGB);self->priv->beecon_idxge2_ExtBgRGB = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdExtFgRGB = %p", self, self->priv->cmdExtFgRGB);
	if (self->priv->cmdExtFgRGB != NULL){g_free(self->priv->cmdExtFgRGB);self->priv->cmdExtFgRGB = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->resExtFgRGB = %p", self, self->priv->resExtFgRGB);
	if (self->priv->resExtFgRGB != NULL){g_free(self->priv->resExtFgRGB);self->priv->resExtFgRGB = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdExtFont = %p", self, self->priv->cmdExtFont);
	if (self->priv->cmdExtFont != NULL){g_free(self->priv->cmdExtFont);self->priv->cmdExtFont = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->resExtFont = %p", self, self->priv->resExtFont);
	if (self->priv->resExtFont != NULL){g_free(self->priv->resExtFont);self->priv->resExtFont = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
	if (self->priv->cmdImgFilename != NULL){g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
	if (self->priv->resImgFilename != NULL){g_free(self->priv->resImgFilename);self->priv->resImgFilename = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceTitle = %p", self, self->priv->instanceTitle);
	if (self->priv->instanceTitle != NULL){g_free(self->priv->instanceTitle);self->priv->instanceTitle = NULL;}
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceCmd = %p", self, self->priv->instanceCmd);
	if (self->priv->instanceCmd != NULL){g_free(self->priv->instanceCmd);self->priv->instanceCmd = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->progressAnimationBasename = %p", self, self->priv->progressAnimationBasename);
	if (self->priv->progressAnimationBasename!=NULL) {g_free(self->priv->progressAnimationBasename);self->priv->progressAnimationBasename=NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->rememberMe = %p [%s]", self, self->priv->rememberMe, self->priv->rememberMe);
	if (self->priv->rememberMe!=NULL) g_free(self->priv->rememberMe); self->priv->rememberMe = NULL;

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->updOnDBUSMatchRule = %p", self, self->priv->updOnDBUSMatchRule);
	if (self->priv->updOnDBUSMatchRule != NULL){g_free(self->priv->updOnDBUSMatchRule);self->priv->updOnDBUSMatchRule = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->dbusVerboseMsg = %p", self, self->priv->dbusVerboseMsg);
	if (self->priv->dbusVerboseMsg != NULL){g_string_free(self->priv->dbusVerboseMsg,TRUE);self->priv->dbusVerboseMsg = NULL;}

    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwHttpProxy = %p [%s]", self->priv, self->priv->qbwHttpProxy, self->priv->qbwHttpProxy);
    if (self->priv->qbwHttpProxy)   {g_free(self->priv->qbwHttpProxy); self->priv->qbwHttpProxy = NULL;}

    qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwHttpsProxy = %p [%s]", self->priv, self->priv->qbwHttpsProxy, self->priv->qbwHttpsProxy);
	if (self->priv->qbwHttpsProxy)  {g_free(self->priv->qbwHttpsProxy); self->priv->qbwHttpsProxy = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwIgnoreHosts = %p [%s]", self->priv, self->priv->qbwIgnoreHosts, self->priv->qbwIgnoreHosts);
	if (self->priv->qbwIgnoreHosts) {g_free(self->priv->qbwIgnoreHosts); self->priv->qbwIgnoreHosts = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwFtpProxy = %p [%s]", self->priv, self->priv->qbwFtpProxy, self->priv->qbwFtpProxy);
	if (self->priv->qbwFtpProxy)    {g_free(self->priv->qbwFtpProxy); self->priv->qbwFtpProxy = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwSocksProxy = %p [%s]", self->priv, self->priv->qbwSocksProxy, self->priv->qbwSocksProxy);
	if (self->priv->qbwSocksProxy)  {g_free(self->priv->qbwSocksProxy); self->priv->qbwSocksProxy = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwRTSPProxy = %p [%s]", self->priv, self->priv->qbwRTSPProxy, self->priv->qbwRTSPProxy);
	if (self->priv->qbwRTSPProxy)   {g_free(self->priv->qbwRTSPProxy); self->priv->qbwRTSPProxy = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) qbwAutoConfigProxy = %p [%s]", self->priv, self->priv->qbwAutoConfigProxy, self->priv->qbwAutoConfigProxy);
	if (self->priv->qbwAutoConfigProxy) {g_free(self->priv->qbwAutoConfigProxy); self->priv->qbwAutoConfigProxy = NULL;}

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) END OF queen_beecon_finalize",object);
	G_OBJECT_CLASS (queen_beecon_parent_class)->finalize (object);
}

void queen_beecon_realize (GtkWidget *widget)
{
	QueenBeecon *self = QUEEN_BEECON (widget);
	GdkScreen *screen = NULL;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (queen_beecon_parent_class)->realize (widget);
	self->priv->widgetID = hd_home_plugin_item_get_applet_id (HD_HOME_PLUGIN_ITEM (widget));

	char *last_dash = strrchr (self->priv->widgetID, '-');
	self->priv->qbwDbusId = NULL;
	self->priv->qbwDbusId = g_strdup_printf("id%s",&last_dash[1]);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s QBW Instance ID=%s", self, G_STRFUNC, self->priv->qbwDbusId);
	queen_beecon_register_dbus_service (self, self->priv->qbwDbusId);//id);
}

gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s(%d) area(x%d,y%d,w%d,h%d) %d more events",widget, G_STRFUNC, event->type, event->area.x, event->area.y, event->area.width, event->area.height, event->count);

	// Let's draw the canvas with basic background shapes Beecon, Snippet...
	queen_beecon_draw_canvas (GTK_WIDGET (widget));

	return GTK_WIDGET_CLASS (queen_beecon_parent_class)->expose_event (widget, event);
}

void queen_beecon_class_init (QueenBeeconClass *klass)
{
	qbw_logger(QBW_LOGGER_INIT, QBW_LOGGER_VNULL, "");
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", klass, G_STRFUNC);
	GError *error = NULL;

	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->dispose = queen_beecon_dispose;
	object_class->finalize = queen_beecon_finalize;

	widget_class->realize = queen_beecon_realize;
	widget_class->expose_event = queen_beecon_expose_event;

	g_type_class_add_private (klass, sizeof (QueenBeeconPrivate));

	queen_beecon_signals[SIG_CONTENT_UPDATED] = g_signal_new("sig_content_updated",
									QUEEN_BEECON_TYPE,
									G_SIGNAL_RUN_LAST,
									G_STRUCT_OFFSET (QueenBeeconClass, queen_beecon_dbus_sig_content_updated),
									NULL, NULL,
									g_cclosure_marshal_VOID__INT,
									G_TYPE_NONE, 1,
									G_TYPE_INT);

	klass->settingsOn = FALSE;

	klass->housekeeping = FALSE;

	klass->dbus_registered = FALSE;

	klass->dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) dbus_g_bus_get dc=%p",klass, klass->dbus_conn);
	if (error) {
		hildon_banner_show_informationf (NULL, NULL, "(%p) QBW Failed to open connection to session bus:\n%s", klass, error->message);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Failed to open connection to session bus: %s", klass, error->message);
		g_clear_error (&error);
		return;
	}

	klass->bus_proxy = dbus_g_proxy_new_for_name (klass->dbus_conn, DBUS_SERVICE_DBUS, DBUS_PATH_DBUS, DBUS_INTERFACE_DBUS);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) dbus_g_proxy_new_for_name px=%p",klass, klass->bus_proxy);

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) dbus_g_object_type_install_info=%p",klass, &dbus_glib_queen_beecon_object_info);
	dbus_g_object_type_install_info (QUEEN_BEECON_TYPE, &dbus_glib_queen_beecon_object_info);
}

void queen_beecon_class_finalize (QueenBeeconClass *klass)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", NULL, G_STRFUNC);

	if (klass->bus_proxy) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) org_freedesktop_DBus_release_name px=%p svc=%s",klass, klass->bus_proxy, QBW_DBUS_SERVICE);
		org_freedesktop_DBus_release_name (klass->bus_proxy, QBW_DBUS_SERVICE, NULL, NULL);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) unref proxy px=%p",klass, klass->bus_proxy);
		g_object_unref (klass->bus_proxy);
	}

	if (klass->dbus_conn) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) unref dbus_conn dc=%p",klass, klass->dbus_conn);
		dbus_g_connection_unref (klass->dbus_conn);
	}
}

void queen_beecon_init (QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", self, G_STRFUNC);
	self->priv = QUEEN_BEECON_GET_PRIVATE (self);

	GtkClipboard *clipboard = NULL;
	/* Allow clipboard data to be stored even when the application is closed: */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_can_store (clipboard, NULL, 0);

	self->priv->dMM = FALSE;
	self->priv->widgetID = NULL;

	self->priv->clickExecInProgress = FALSE;
	self->priv->clicksTimerID = 0;
	self->priv->clicksCount = 0;
	self->priv->clickX = -1;
	self->priv->clickY = -1;
	self->priv->hotSpotIndex = 0;

	self->priv->cmdExitStatus = -1;
	self->priv->startupExecTimerID = 0;
	self->priv->updateTimerID = 0;
	self->priv->timeout_id = 0;
	self->priv->child_watch_id = 0;
	self->priv->io_watch_id = 0;

	self->priv->startupAnimation = TRUE;
	self->priv->animationInProgress = TRUE;

	self->priv->qbwOnSight = 0;

	self->priv->isPressed = FALSE;
	self->priv->widXOrigin=-1;
	self->priv->widYOrigin=-1;

	self->priv->widWidth = 1;
	self->priv->widHeight = 1;

	self->priv->connection = con_ic_connection_new ();
	g_signal_connect (self->priv->connection, "connection-event", G_CALLBACK (queen_beecon_connection_event), self);
	g_object_set (self->priv->connection, "automatic-connection-events", TRUE, NULL);
	self->priv->isConnected = FALSE;

	self->priv->qbwHttpProxy   = NULL;
	self->priv->qbwHttpsProxy  = NULL;
	self->priv->qbwIgnoreHosts = NULL;
	self->priv->qbwFtpProxy    = NULL;
	self->priv->qbwSocksProxy  = NULL;
	self->priv->qbwRTSPProxy   = NULL;
	self->priv->qbwAutoConfigProxy = NULL;

	self->priv->dbus_mon_connection = NULL;
	self->priv->updOnDBUS = FALSE;

	self->priv->beeExecuting_img = NULL;
	self->priv->execAuxOutput = NULL;
	self->priv->execInProgress = FALSE;
	self->priv->dbusVerboseMsg = NULL;

	self->priv->cmdTitle_lb = NULL;
	self->priv->cmdTitle_img = NULL;
	self->priv->cmdResult_lb = NULL;
	self->priv->cmdResult_img = NULL;

	self->priv->rememberMe = NULL;

	self->priv->beecon_lt0_ImgFilename = NULL;
	self->priv->beecon_eq0_ImgFilename = NULL;
	self->priv->beecon_eq1_ImgFilename = NULL;
	self->priv->beecon_ge2_ImgFilename = NULL;
	self->priv->beecon_idxge2_ImgFilename = NULL;
	self->priv->cmdExtFont = NULL;
	self->priv->resExtFont = NULL;
	self->priv->cmdImgFilename = NULL;
	self->priv->resImgFilename = NULL;
	self->priv->instanceTitle = NULL;
	self->priv->instanceCmd = NULL;

	self->priv->snippetExtBgRGB = NULL;
	self->priv->beecon_lt0_ExtBgRGB = NULL;
	self->priv->beecon_eq0_ExtBgRGB = NULL;
	self->priv->beecon_eq1_ExtBgRGB = NULL;
	self->priv->beecon_ge2_ExtBgRGB = NULL;
	self->priv->beecon_idxge2_ExtBgRGB = NULL;
	self->priv->cmdExtFgRGB = NULL;
	self->priv->resExtFgRGB = NULL;

	self->priv->progressAnimationFrames = QBW_PROGRESS_ANIMATION_FRAMES_DEFAULT;
	self->priv->progressAnimationTimer = QBW_PROGRESS_ANIMATION_FRAMES_TIMER_MSECS/QBW_PROGRESS_ANIMATION_FRAMES_TIMER_STEPS_MSECS;
	self->priv->progressAnimationPos = 4; //Center
	self->priv->progressAnimationBasename = NULL;

	// Create/Prepare primary and secondary image directories
	gchar *auxdirname = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, NULL);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) opening/creating private auxdirname %s", self, auxdirname);
	if(!g_mkdir_with_parents (auxdirname, 0755)) { // Let's create our directory if not already existing
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) problems creating/opening private auxdirname %s", self, auxdirname);
	} else
		g_free(auxdirname);

	gchar *dirname = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, NULL);
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) opening/creating private dirname %s", self, dirname);
	if(!g_mkdir_with_parents (dirname, 0755)) {// Let's create our directory if not already existing
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) problems creating/opening private dirname %s", self, dirname);
	} else
		g_free(dirname);
	//EO Create/Prepare primary and secondary image directories

	// Initialize settings button
	hd_home_plugin_item_set_settings (&self->parent, TRUE);
	g_signal_connect (&self->parent, "show-settings", G_CALLBACK (queen_beecon_settings), self);

	gtk_window_set_default_size (GTK_WINDOW (self), 800, 420);

	GdkGeometry hints;
	hints.min_width = (int)(1);//AP3
	hints.min_height = (int)(1);//AP3
	hints.max_width = (int)(800);//AP3
	hints.max_height = (int)(420);//AP3
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(1), (int)(1));//AP3
	gtk_window_resize (GTK_WINDOW (self), (int)(1), (int)(1));//AP3

	self->priv->homeWidget = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);
	gtk_widget_show (self->priv->homeWidget);

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) INIT calling queen_beecon_content_create (self)", self);
	queen_beecon_content_create (self);

	g_timeout_add (100, (GSourceFunc)queen_beecon_resize_hack, self);

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) INIT Let's arm notify::is-on-current-desktop", self);
	g_signal_connect (self, "notify::is-on-current-desktop", G_CALLBACK (queen_beecon_check_desktop), self);
}

QueenBeecon* queen_beecon_new (void)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V0, "(%p) %s", NULL, G_STRFUNC);
	return g_object_new (QUEEN_BEECON_TYPE, NULL);
}

void on_interval_picker_value_changed(HildonPickerButton *button, GtkWidget *interval)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", NULL, G_STRFUNC);
	int cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (button));
	//cmdSel == 9?gtk_widget_show (GTK_WIDGET(interval)):gtk_widget_hide (GTK_WIDGET(interval));
	cmdSel == 9 ? gtk_widget_set_sensitive (GTK_WIDGET(interval), TRUE):gtk_widget_set_sensitive (GTK_WIDGET(interval), FALSE);
}

void color_button_clicked_cb(HildonButton *button, struct _colorAux *data)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", NULL, G_STRFUNC);
	GtkWidget *dialog;

	dialog = he_color_dialog_new_with_color(data->WC);
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "Accept", NULL);
		he_color_dialog_get_color (HE_COLOR_DIALOG(dialog), data->WC);
		gtk_widget_modify_bg (GTK_WIDGET (data->WP), GTK_STATE_NORMAL, data->WC);gtk_widget_modify_bg (GTK_WIDGET (data->WP), GTK_STATE_PRELIGHT, data->WC);
	}
	gtk_widget_destroy (dialog);
}

void font_button_clicked_cb(HildonButton *button, gpointer data)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", NULL, G_STRFUNC);
	GtkWidget *dialog;
	gchar *value;
	value = g_strdup(hildon_button_get_value (button));

	dialog = he_font_dialog_new_with_font(value);
	g_free(value);
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "Accept", NULL);
		hildon_button_set_value (button, he_font_dialog_get_font (HE_FONT_DIALOG(dialog)));
	}
	gtk_widget_destroy (dialog);
}

void widthPlusOneBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	gdouble w = gtk_range_get_value(GTK_RANGE(self->priv->widthSelectW));
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %f - %f", self, w, w+1.0);
	w = w + 1.0;
	gtk_range_set_value(GTK_RANGE(self->priv->widthSelectW), w);
}
void widthMinusOneBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	gdouble w = gtk_range_get_value(GTK_RANGE(self->priv->widthSelectW));
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %f - %f", self, w, w-1.0);
	w = w - 1.0;
	gtk_range_set_value(GTK_RANGE(self->priv->widthSelectW), w);
}
void heightPlusOneBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	gdouble w = gtk_range_get_value(GTK_RANGE(self->priv->heightSelectW));
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %f - %f", self, w, w+1.0);
	w = w + 1.0;
	gtk_range_set_value(GTK_RANGE(self->priv->heightSelectW), w);
}
void heightMinusOneBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	gdouble w = gtk_range_get_value(GTK_RANGE(self->priv->heightSelectW));
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %f - %f", self, w, w-1.0);
	w = w - 1.0;
	gtk_range_set_value(GTK_RANGE(self->priv->heightSelectW), w);
}
void widthValue_changed_cb ( GtkHScale * entry, QueenBeecon *self )
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	gdouble w = gtk_range_get_value(GTK_RANGE(self->priv->widthSelectW));
	gchar *ws = g_strdup_printf(" %d ",(gint)w);
	gtk_label_set_text(GTK_LABEL (self->priv->widthEntryW), ws);
	g_free(ws);ws=NULL;
}
void heightValue_changed_cb ( GtkHScale * entry, QueenBeecon *self )
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s", self, G_STRFUNC);
	gdouble w = gtk_range_get_value(GTK_RANGE(self->priv->heightSelectW));
	gchar *ws = g_strdup_printf(" %d ",(gint)w);
	gtk_label_set_text(GTK_LABEL (self->priv->heightEntryW), ws);
	g_free(ws);ws=NULL;
}

//Separate window dialogs
void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s", self, G_STRFUNC);

	if (QUEEN_BEECON_GET_CLASS(self)->settingsOn) { // Test'n'Set Critical Region settings dialog already open !!!Not properly atomic ... but!!!
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) settingsOn = TRUE ... SKIP SETTINGS!", self);
		return;
	} else {
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) settingsOn = FALSE ... OPEN SETTINGS!", self);
		QUEEN_BEECON_GET_CLASS(self)->settingsOn = TRUE;
	}

	gboolean settingsRunning = TRUE, reloadInstanceSettings = TRUE;
	int i;
	HildonGtkInputMode input_mode;
	self->priv->selectorW = NULL,
	self->priv->cmdSelectorW = NULL; //for command list

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Ingresso in Settings reloadInstanceSettings=%d", self, reloadInstanceSettings);
	while(reloadInstanceSettings) { // First time we go free and easy
		reloadInstanceSettings = FALSE; // Door wide shut!
		settingsRunning = TRUE;
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) settingsRunning in outer settings diaolg loop= %d",self, settingsRunning);
		gchar *dTitle = g_strdup_printf("Queen BeeCon Widget Settings [%s]", self->priv->qbwDbusId);
		self->priv->dialogW = gtk_dialog_new_with_buttons (dTitle, NULL, GTK_DIALOG_DESTROY_WITH_PARENT, //
																										 _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT,
																										 "Save & Run", NON_GTK_RESPONSE_SAVE_AND_RUN,
																										 "Add Cmd", NON_GTK_RESPONSE_ADD_CMD,
																										 "Edit Cmd", NON_GTK_RESPONSE_EDIT_CMD,
																										 "Advanced", NON_GTK_RESPONSE_ADVANCED,
																										 NULL);
		g_free(dTitle);

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Building settings dialog %p", self, self->priv->dialogW);
		self->priv->settingsAreaW = gtk_dialog_get_content_area (GTK_DIALOG (self->priv->dialogW));
		self->priv->scrollW = hildon_pannable_area_new ();
		g_object_set (self->priv->scrollW, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
		g_object_set (self->priv->scrollW, "mov-mode", HILDON_MOVEMENT_MODE_BOTH, NULL);

		self->priv->content_areaW = gtk_vbox_new (FALSE, 0);
		hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (self->priv->scrollW), self->priv->content_areaW);
		gtk_container_add (GTK_CONTAINER (self->priv->settingsAreaW), self->priv->scrollW);
		gtk_window_set_default_size (GTK_WINDOW (self->priv->dialogW), -1, 400);

		queen_beecon_read_settings(self, FALSE, FALSE, NULL);

		self->priv->widCmdTypeBoxW = gtk_hbox_new (FALSE, 0);
		//BEGIN Command Selector
		self->priv->widgetTypeW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), "Beecon");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), "Snippet");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), 0, self->priv->widgetType);//AP1

		self->priv->widgetTypeSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1

		hildon_button_set_title (HILDON_BUTTON (self->priv->widgetTypeSelectorW), "Type");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->widgetTypeSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->widgetTypeSelectorW), HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->widgetTypeSelectorW, FALSE, FALSE, 0);//AP

		self->priv->widgetVisibleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), "Hidden");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), "Visible");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), 0, self->priv->widgetVisible);//AP1

		self->priv->widgetVisibleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->widgetVisibleSelectorW), "Show");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->widgetVisibleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->widgetVisibleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->widgetVisibleSelectorW, FALSE, FALSE, 0);//AP

		self->priv->widgetOperationalStatusW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), "Enabled");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), "Disabled");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), 0, self->priv->operationalStatus);//AP1

		self->priv->widgetOperationalStatusSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->widgetOperationalStatusSelectorW), "Status");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->widgetOperationalStatusSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->widgetOperationalStatusSelectorW), HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->widgetOperationalStatusSelectorW, FALSE, FALSE, 0);//AP

		self->priv->selectorW = hildon_touch_selector_new_text ();
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Created command selector %p self->priv->c_size = %d", self, self->priv->selectorW, self->priv->c_size);
		for(i=0;i<self->priv->c_size;i++)
		{
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->selectorW), self->priv->c_titles[i]);
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Append Titles [%s]", self, self->priv->c_titles[i]);
			if(g_strcmp0(self->priv->c_titles[i],self->priv->instanceTitle) == 0) {
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Commands [%s]", self, self->priv->c_commands[i]);
				if(g_strcmp0(self->priv->c_commands[i],self->priv->instanceCmd) == 0) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Active [%s]-[%s]-[%s]", self, self->priv->c_titles[i], self->priv->c_commands[i], self->priv->instanceCmd);
					hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0, i);
				}
			}
		}
		self->priv->cmdSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdSelectorW), "Command Selection");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdSelectorW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), HILDON_TOUCH_SELECTOR (self->priv->selectorW));
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->cmdSelectorW, TRUE, TRUE, 0);//AP
		//END

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widCmdTypeBoxW);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Widget Size & Position Tuning", self);
		self->priv->widgetSizeLabelW = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (self->priv->widgetSizeLabelW), "Widget Size &amp; Position Tuning");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widgetSizeLabelW);//AP1

		self->priv->widthBoxW = gtk_vbox_new (FALSE, 0);

		self->priv->widthLabelW = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (self->priv->widthLabelW), "Width: <small>(10-800 Pixels)</small>");
		gtk_misc_set_alignment (GTK_MISC (self->priv->widthLabelW), 0, 0.5);
		gtk_misc_set_padding (GTK_MISC (self->priv->widthLabelW), HILDON_MARGIN_DOUBLE, 0);
		gtk_box_pack_start (GTK_BOX (self->priv->widthBoxW), self->priv->widthLabelW, FALSE, FALSE, 0);

		GtkWidget *hwidthBoxW = gtk_hbox_new (FALSE, 0);

		self->priv->widthSelectW = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_WIDTH_ALL, (gdouble)1.0);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) widWidth %f", self, self->priv->widWidth);
		gtk_scale_set_digits(GTK_SCALE(self->priv->widthSelectW),0);
		gtk_scale_set_draw_value(GTK_SCALE(self->priv->widthSelectW),FALSE);
		gtk_range_set_value(GTK_RANGE(self->priv->widthSelectW), self->priv->widWidth);
		gtk_box_pack_start (GTK_BOX (hwidthBoxW), self->priv->widthSelectW, TRUE, TRUE, 0);

		gchar *ww = g_strdup_printf(" %d ",(gint)self->priv->widWidth);
		self->priv->widthEntryW = gtk_label_new (ww);
		g_free(ww);ww=NULL;
		g_signal_connect (self->priv->widthSelectW, "value-changed", G_CALLBACK (widthValue_changed_cb), self);
		gtk_box_pack_start (GTK_BOX(hwidthBoxW), self->priv->widthEntryW, FALSE, FALSE, 0);//AP

		GtkWidget *widthMinusOnePxBt = hildon_button_new_with_text (HILDON_SIZE_AUTO_HEIGHT |
	                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
											  "",
	                                          NULL);
		hildon_button_set_value (HILDON_BUTTON (widthMinusOnePxBt), " -1 px");
		hildon_button_set_alignment (HILDON_BUTTON (widthMinusOnePxBt), 0, 0.5, 0, 0);//AP1
		g_signal_connect (widthMinusOnePxBt, "clicked", G_CALLBACK (widthMinusOneBt_clicked_cb), self);
	    gtk_box_pack_start (GTK_BOX (hwidthBoxW), widthMinusOnePxBt, FALSE, FALSE, 0);

		GtkWidget *widthPlusOnePxBt = hildon_button_new_with_text (HILDON_SIZE_AUTO_HEIGHT |
	                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
											  "",
	                                          NULL);
		hildon_button_set_value (HILDON_BUTTON (widthPlusOnePxBt), "+1 px");
		hildon_button_set_alignment (HILDON_BUTTON (widthPlusOnePxBt), 0, 0.5, 0, 0);//AP1
		g_signal_connect (widthPlusOnePxBt, "clicked", G_CALLBACK (widthPlusOneBt_clicked_cb), self);
	    gtk_box_pack_start (GTK_BOX (hwidthBoxW), widthPlusOnePxBt, FALSE, FALSE, 0);

		gtk_box_pack_start (GTK_BOX (self->priv->widthBoxW), hwidthBoxW, FALSE, FALSE, 0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widthBoxW);

		//layout opts heightBox //AP
		self->priv->heightBoxW = gtk_vbox_new (FALSE, 0);//AP

		self->priv->heightLabelW = gtk_label_new ("");//AP

		gtk_label_set_markup (GTK_LABEL (self->priv->heightLabelW), "Height: <small>(10-420 Pixels)</small>");
		gtk_misc_set_alignment (GTK_MISC (self->priv->heightLabelW), 0, 0.5);//AP
		gtk_misc_set_padding (GTK_MISC (self->priv->heightLabelW), HILDON_MARGIN_DOUBLE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->heightBoxW), self->priv->heightLabelW, FALSE, FALSE, 0);//AP

		GtkWidget *hheightBoxW = gtk_hbox_new (FALSE, 0);

		self->priv->heightSelectW = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_HEIGHT_ALL, (gdouble)1.0);//AP
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) widHeight %f", self, self->priv->widHeight);
		gtk_scale_set_digits(GTK_SCALE(self->priv->heightSelectW),0);
		gtk_scale_set_draw_value(GTK_SCALE(self->priv->heightSelectW),FALSE);
		gtk_range_set_value(GTK_RANGE(self->priv->heightSelectW), self->priv->widHeight);//AP
		gtk_box_pack_start (GTK_BOX (hheightBoxW), self->priv->heightSelectW, TRUE, TRUE, 0);//AP

		gchar *wh = g_strdup_printf(" %d ",(gint)self->priv->widHeight);
		self->priv->heightEntryW = gtk_label_new (wh);
		g_free(wh);wh=NULL;
		g_signal_connect (self->priv->heightSelectW, "value-changed", G_CALLBACK (heightValue_changed_cb), self);
		gtk_box_pack_start (GTK_BOX(hheightBoxW), self->priv->heightEntryW, FALSE, FALSE, 0);//AP

		GtkWidget *heightMinusOnePxBt = hildon_button_new_with_text (HILDON_SIZE_AUTO_HEIGHT |
	                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
											  "",
	                                          NULL);
		hildon_button_set_value (HILDON_BUTTON (heightMinusOnePxBt), " -1 px");
		hildon_button_set_alignment (HILDON_BUTTON (heightMinusOnePxBt), 0, 0.5, 0, 0);//AP1
		g_signal_connect (heightMinusOnePxBt, "clicked", G_CALLBACK (heightMinusOneBt_clicked_cb), self);
	    gtk_box_pack_start (GTK_BOX (hheightBoxW), heightMinusOnePxBt, FALSE, FALSE, 0);

		GtkWidget *heightPlusOnePxBt = hildon_button_new_with_text (HILDON_SIZE_AUTO_HEIGHT |
	                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
											  "",
	                                          NULL);
		hildon_button_set_value (HILDON_BUTTON (heightPlusOnePxBt), "+1 px");
		hildon_button_set_alignment (HILDON_BUTTON (heightPlusOnePxBt), 0, 0.5, 0, 0);//AP1
		g_signal_connect (heightPlusOnePxBt, "clicked", G_CALLBACK (heightPlusOneBt_clicked_cb), self);
	    gtk_box_pack_start (GTK_BOX (hheightBoxW), heightPlusOnePxBt, FALSE, FALSE, 0);

		gtk_box_pack_start (GTK_BOX (self->priv->heightBoxW), hheightBoxW, FALSE, FALSE, 0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->heightBoxW);//AP

		self->priv->widPositionBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->widPositionLabelW = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (self->priv->widPositionLabelW), "<small>Tune (X,Y)</small>");
		gtk_misc_set_alignment (GTK_MISC (self->priv->widPositionLabelW), 0, 0.8);//AP1
		gtk_misc_set_padding (GTK_MISC (self->priv->widPositionLabelW), HILDON_MARGIN_DOUBLE, 0);//AP1

		// Check if we have moved our widget window through settings for fine tuning
		gint widXOrigin, widYOrigin;
		gtk_window_get_position (GTK_WINDOW (self), &widXOrigin, &widYOrigin); // Remember our position ... maybe we need to move a little bit

		self->priv->widPositionXW = gtk_hscale_new_with_range ((gdouble)widXOrigin-5, (gdouble)widXOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(self->priv->widPositionXW), widXOrigin);//AP1

		self->priv->widPositionYW = gtk_hscale_new_with_range ((gdouble)widYOrigin-5, (gdouble)widYOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(self->priv->widPositionYW), widYOrigin);//AP1

		gtk_box_pack_start (GTK_BOX (self->priv->widPositionBoxW), self->priv->widPositionLabelW, FALSE, FALSE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widPositionBoxW), self->priv->widPositionXW, TRUE, TRUE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widPositionBoxW), self->priv->widPositionYW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widPositionBoxW);//AP1

		self->priv->widgetBgLabelW = gtk_label_new ("Status Background Colors & Images");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widgetBgLabelW);//AP1

		self->priv->hidCanvSnipBgBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->checkBtHideCanvasW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtHideCanvasW), "Hide Bg");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hideCanvas %d", self, self->priv->hideCanvas);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtHideCanvasW), self->priv->hideCanvas);
		gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), self->priv->checkBtHideCanvasW, TRUE, TRUE, 0);//AP

		self->priv->checkBtHideClkCanvasW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtHideClkCanvasW), "Hide Click Bg");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) hideClickCanvas %d", self, self->priv->hideClickCanvas);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtHideClkCanvasW), self->priv->hideClickCanvas);
		gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), self->priv->checkBtHideClkCanvasW, TRUE, TRUE, 0);//AP

		struct _colorAux snI;
		GtkWidget *buttonsn = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												"Snippet",
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonsn), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), buttonsn, FALSE, FALSE, 0);

		GtkWidget *snipPVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (snipPVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->snippetExtBgRGB=%s",self,self->priv->snippetExtBgRGB);
		gdk_color_parse(self->priv->snippetExtBgRGB, &self->priv->snippetBgRGBC);
		GtkWidget *snipPVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (snipPVEvt), snipPVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (snipPVEvt), GTK_STATE_NORMAL, &self->priv->snippetBgRGBC);gtk_widget_modify_bg (GTK_WIDGET (snipPVEvt), GTK_STATE_PRELIGHT, &self->priv->snippetBgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), snipPVEvt, FALSE, FALSE, 0);

        snI.WC = &self->priv->snippetBgRGBC; snI.WP = snipPVEvt;  snI.FG = FALSE;
        g_signal_connect (buttonsn, "clicked", G_CALLBACK (color_button_clicked_cb), &snI);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->hidCanvSnipBgBoxW);//AP1

		self->priv->beeconExitStatusesLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Beecon Statuses: Image, Scale, Background Color", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beeconExitStatusesLabelW), "<small>Beecon Statuses: Image, Scale, Background Color</small>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beeconExitStatusesLabelW), 0.5, 0.5);
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeconExitStatusesLabelW);//AP1

		//BEGIN beecon images image
		self->priv->beelt0BoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->beelt0BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_lt0_ImgLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) lt0", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_lt0_ImgLabelW), "<span foreground=\"red\"><b>&lt;0</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_lt0_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxxW), self->priv->beecon_lt0_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beelt0BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_lt0_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_lt0_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_lt0_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_lt0_ImgEntryW), self->priv->beecon_lt0_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beecon_lt0_ImgEntryW, TRUE, TRUE, 0);//AP

		self->priv->beecon_lt0_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), 0, self->priv->beecon_lt0_ImgZoom);//AP1
		self->priv->beecon_lt0_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_lt0_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_lt0_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_lt0_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beecon_lt0_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

		struct _colorAux lt0;
		GtkWidget *buttonlt0 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonlt0), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), buttonlt0, FALSE, FALSE, 0);

		GtkWidget *lt0PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (lt0PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_lt0_ExtBgRGB=%s",self,self->priv->beecon_lt0_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_lt0_ExtBgRGB, &self->priv->lt0_BgRGBC);
		GtkWidget *lt0PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (lt0PVEvt), lt0PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (lt0PVEvt), GTK_STATE_NORMAL, &self->priv->lt0_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (lt0PVEvt), GTK_STATE_PRELIGHT, &self->priv->lt0_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), lt0PVEvt, FALSE, FALSE, 0);

        lt0.WC = &self->priv->lt0_BgRGBC; lt0.WP = lt0PVEvt;  lt0.FG = FALSE;
        g_signal_connect (buttonlt0, "clicked", G_CALLBACK (color_button_clicked_cb), &lt0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beelt0BoxW);//AP1

		self->priv->beeeq0BoxW = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image

		self->priv->beeeq0BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_eq0_ImgLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) eq0", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_eq0_ImgLabelW), "<span foreground=\"red\"><b>=0</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_eq0_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxxW), self->priv->beecon_eq0_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beeeq0BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_eq0_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_eq0_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_eq0_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_eq0_ImgEntryW), self->priv->beecon_eq0_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beecon_eq0_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_eq0_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), 0, self->priv->beecon_eq0_ImgZoom);//AP1
		self->priv->beecon_eq0_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_eq0_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_eq0_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_eq0_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beecon_eq0_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

		struct _colorAux eq0;
		GtkWidget *buttoneq0 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttoneq0), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), buttoneq0, FALSE, FALSE, 0);

		GtkWidget *eq0PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (eq0PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq0_ExtBgRGB=%s",self,self->priv->beecon_eq0_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_eq0_ExtBgRGB, &self->priv->eq0_BgRGBC);
		GtkWidget *eq0PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (eq0PVEvt), eq0PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (eq0PVEvt), GTK_STATE_NORMAL, &self->priv->eq0_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (eq0PVEvt), GTK_STATE_PRELIGHT, &self->priv->eq0_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), eq0PVEvt, FALSE, FALSE, 0);

        eq0.WC = &self->priv->eq0_BgRGBC; eq0.WP = eq0PVEvt; eq0.FG = FALSE;
        g_signal_connect (buttoneq0, "clicked", G_CALLBACK (color_button_clicked_cb), &eq0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeeq0BoxW);//AP1

		self->priv->beeeq1BoxW = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		self->priv->beeeq1BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_eq1_ImgLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) eq1", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_eq1_ImgLabelW), "<span foreground=\"red\"><b>=1</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_eq1_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxxW), self->priv->beecon_eq1_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beeeq1BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_eq1_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_eq1_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_eq1_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_eq1_ImgEntryW), self->priv->beecon_eq1_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beecon_eq1_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_eq1_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), 0, self->priv->beecon_eq1_ImgZoom);//AP1
		self->priv->beecon_eq1_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_eq1_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_eq1_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_eq1_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beecon_eq1_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

		struct _colorAux eq1;
		GtkWidget *buttoneq1 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttoneq1), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), buttoneq1, FALSE, FALSE, 0);

		GtkWidget *eq1PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (eq1PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq1_ExtBgRGB=%s",self,self->priv->beecon_eq1_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_eq1_ExtBgRGB, &self->priv->eq1_BgRGBC);
		GtkWidget *eq1PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (eq1PVEvt), eq1PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (eq1PVEvt), GTK_STATE_NORMAL, &self->priv->eq1_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (eq1PVEvt), GTK_STATE_PRELIGHT, &self->priv->eq1_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), eq1PVEvt, FALSE, FALSE, 0);

        eq1.WC = &self->priv->eq1_BgRGBC; eq1.WP = eq1PVEvt; eq1.FG = FALSE;
        g_signal_connect (buttoneq1, "clicked", G_CALLBACK (color_button_clicked_cb), &eq1);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeeq1BoxW);//AP1

		self->priv->beege2BoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->beege2BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_ge2_ImgLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) ge2", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_ge2_ImgLabelW), "<span foreground=\"red\"><b>=2</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_ge2_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxxW), self->priv->beecon_ge2_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beege2BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_ge2_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_ge2_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_ge2_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_ge2_ImgEntryW), self->priv->beecon_ge2_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beecon_ge2_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_ge2_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), 0, self->priv->beecon_ge2_ImgZoom);//AP1
		self->priv->beecon_ge2_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_ge2_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_ge2_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_ge2_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beecon_ge2_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

		struct _colorAux ge2;
		GtkWidget *buttonge2 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonge2), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), buttonge2, FALSE, FALSE, 0);

		GtkWidget *ge2PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (ge2PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_ge2_ExtBgRGB=%s",self,self->priv->beecon_ge2_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_ge2_ExtBgRGB, &self->priv->ge2_BgRGBC);
		GtkWidget *ge2PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (ge2PVEvt), ge2PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (ge2PVEvt), GTK_STATE_NORMAL, &self->priv->ge2_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (ge2PVEvt), GTK_STATE_PRELIGHT, &self->priv->ge2_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), ge2PVEvt, FALSE, FALSE, 0);

        ge2.WC = &self->priv->ge2_BgRGBC; ge2.WP = ge2PVEvt; ge2.FG = FALSE;
        g_signal_connect (buttonge2, "clicked", G_CALLBACK (color_button_clicked_cb), &ge2);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beege2BoxW);//AP1

		self->priv->beeidxge2BoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->beeidxge2BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_idxge2_ImgLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) ge3", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_idxge2_ImgLabelW), "<span foreground=\"red\"><b>&#8805;3</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_idxge2_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxxW), self->priv->beecon_idxge2_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beeidxge2BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_idxge2_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_idxge2_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_idxge2_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_idxge2_ImgEntryW), self->priv->beecon_idxge2_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beecon_idxge2_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_idxge2_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				gchar *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), 0, self->priv->beecon_idxge2_ImgZoom);//AP1
		self->priv->beecon_idxge2_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_idxge2_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_idxge2_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_idxge2_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beecon_idxge2_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

		struct _colorAux idxge2;
		GtkWidget *buttonidxge2 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonidxge2), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), buttonidxge2, FALSE, FALSE, 0);

		GtkWidget *idxge2PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (idxge2PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_idxge2_ExtBgRGB=%s",self,self->priv->beecon_idxge2_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_idxge2_ExtBgRGB, &self->priv->idxge2_BgRGBC);
		GtkWidget *idxge2PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (idxge2PVEvt), idxge2PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (idxge2PVEvt), GTK_STATE_NORMAL, &self->priv->idxge2_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (idxge2PVEvt), GTK_STATE_PRELIGHT, &self->priv->idxge2_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), idxge2PVEvt, FALSE, FALSE, 0);

        idxge2.WC = &self->priv->idxge2_BgRGBC; idxge2.WP = idxge2PVEvt; idxge2.FG = FALSE;
        g_signal_connect (buttonidxge2, "clicked", G_CALLBACK (color_button_clicked_cb), &idxge2);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeidxge2BoxW);//AP1

		//BEGIN
		//layout opts

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Command Title Settings", self);
		self->priv->LayoutCmdLabelW = gtk_label_new ("Command Title Settings");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->LayoutCmdLabelW);//AP1

		self->priv->cmdImgVisPosBoxW = gtk_hbox_new (FALSE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd img file", self);
		self->priv->titleImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->titleImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->titleImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->titleImgEntryW), self->priv->cmdImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->titleImgEntryW, TRUE, TRUE, 0);//AP1
		//END title image

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd img angle", self);
		self->priv->cmdImgAngleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW), "0°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW), "90°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW), "180°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW), "270°");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW), 0, self->priv->cmdImgAngle);//AP1

		self->priv->cmdImgAngleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdImgAngleSelectorW), "Angle");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdImgAngleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdImgAngleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->cmdImgAngleSelectorW, FALSE, FALSE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd img zoom", self);
		self->priv->beecon_cmdImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), 0, self->priv->cmdImgZoom);//AP1
		self->priv->beecon_cmdImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_cmdImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_cmdImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_cmdImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->beecon_cmdImgZoomSelectorW, FALSE, FALSE, 0);//AP

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd img visi", self);
		self->priv->cmdImgVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW), 0, self->priv->cmdImgVisibilityPosition);//AP1

		self->priv->cmdImgVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdImgVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdImgVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdImgVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->cmdImgVisibilityPositionSelectorW, FALSE, FALSE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->cmdImgVisPosBoxW);//AP1

//---------
		self->priv->cmdExtFontBoxW = gtk_hbox_new (FALSE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd font", self);

		GtkWidget *buttoncfo = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												"Title",
												self->priv->cmdExtFont);
		hildon_button_set_image (HILDON_BUTTON (buttoncfo), gtk_image_new_from_stock (GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU));
		hildon_button_set_alignment (HILDON_BUTTON (buttoncfo), 0, 0.5, 0, 0);
        g_signal_connect (buttoncfo, "clicked", G_CALLBACK (font_button_clicked_cb), NULL);
		gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), buttoncfo, TRUE, TRUE, 0);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd color", self);

		struct _colorAux fgc;
		GtkWidget *buttonfgc = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Fg");
		hildon_button_set_image (HILDON_BUTTON (buttonfgc), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), buttonfgc, FALSE, FALSE, 0);

		GtkWidget *fgcPVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (fgcPVLabel), "     ");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdExtFgRGB=%s",self,self->priv->cmdExtFgRGB);
		gdk_color_parse(self->priv->cmdExtFgRGB, &self->priv->cmdFgRGBC);
		GtkWidget *fgcPVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (fgcPVEvt), fgcPVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (fgcPVEvt), GTK_STATE_NORMAL, &self->priv->cmdFgRGBC);gtk_widget_modify_bg (GTK_WIDGET (fgcPVEvt), GTK_STATE_PRELIGHT, &self->priv->cmdFgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), fgcPVEvt, FALSE, FALSE, 0);

        fgc.WC = &self->priv->cmdFgRGBC; fgc.WP = fgcPVEvt; fgc.FG = TRUE;
        g_signal_connect (buttonfgc, "clicked", G_CALLBACK (color_button_clicked_cb), &fgc);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->cmdExtFontBoxW);//AP1
//---------

		self->priv->cmdPosColJusBoxW = gtk_hbox_new (TRUE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd visib", self);
		self->priv->cmdVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW), 0, self->priv->cmdVisibilityPosition);//AP1

		self->priv->cmdVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdPosColJusBoxW), self->priv->cmdVisibilityPositionSelectorW, TRUE, TRUE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd angle", self);
		self->priv->cmdTextAngleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "0°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "90°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "180°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "270°");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), 0, self->priv->cmdTextAngle);//AP1

		self->priv->cmdTextAngleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdTextAngleSelectorW), "Angle");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdTextAngleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdTextAngleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdPosColJusBoxW), self->priv->cmdTextAngleSelectorW, TRUE, TRUE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cmd justify", self);
		self->priv->cmdJustifyW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW), 0, self->priv->cmdJustify);//AP1

		self->priv->cmdJustifySelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdJustifySelectorW), "Justification");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdJustifySelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdJustifySelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdPosColJusBoxW), self->priv->cmdJustifySelectorW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->cmdPosColJusBoxW);//AP1
//----------------------------
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Command Results Settings", self);
		self->priv->LayoutResLabelW = gtk_label_new ("Command Results Settings");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->LayoutResLabelW);//AP1

		self->priv->resImgVisPosBoxW = gtk_hbox_new (FALSE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res img file", self);
		self->priv->resultsImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->resultsImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->resultsImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->resultsImgEntryW), self->priv->resImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->resultsImgEntryW, TRUE, TRUE, 0);//AP1
		//END results image

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res img angle", self);
		self->priv->resImgAngleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW), "0°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW), "90°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW), "180°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW), "270°");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW), 0, self->priv->resImgAngle);//AP1

		self->priv->resImgAngleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resImgAngleSelectorW), "Angle");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resImgAngleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resImgAngleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->resImgAngleSelectorW, FALSE, FALSE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res img zoom", self);
		self->priv->beecon_resImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), 0, self->priv->resImgZoom);//AP1
		self->priv->beecon_resImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_resImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_resImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_resImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->beecon_resImgZoomSelectorW, FALSE, FALSE, 0);//AP

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res img visi", self);
		self->priv->resImgVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW), 0, self->priv->resImgVisibilityPosition);//AP1

		self->priv->resImgVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resImgVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resImgVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resImgVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->resImgVisibilityPositionSelectorW, FALSE, FALSE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->resImgVisPosBoxW);//AP1

//---------
		self->priv->resExtFontBoxW = gtk_hbox_new (FALSE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res font", self);

		GtkWidget *buttonrfo = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												"Results",
												self->priv->resExtFont);
		hildon_button_set_image (HILDON_BUTTON (buttonrfo), gtk_image_new_from_stock (GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU));
		hildon_button_set_alignment (HILDON_BUTTON (buttonrfo), 0, 0.5, 0, 0);
        g_signal_connect (buttonrfo, "clicked", G_CALLBACK (font_button_clicked_cb), NULL);
		gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), buttonrfo, TRUE, TRUE, 0);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res color", self);

		struct _colorAux fgr;
		GtkWidget *buttonfgr = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Fg");
		hildon_button_set_image (HILDON_BUTTON (buttonfgr), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), buttonfgr, FALSE, FALSE, 0);

		GtkWidget *fgrPVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (fgrPVLabel), "     ");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->resExtFgRGB=%s",self,self->priv->resExtFgRGB);
		gdk_color_parse(self->priv->resExtFgRGB, &self->priv->resFgRGBC);
		GtkWidget *fgrPVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (fgrPVEvt), fgrPVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (fgrPVEvt), GTK_STATE_NORMAL, &self->priv->resFgRGBC);gtk_widget_modify_bg (GTK_WIDGET (fgrPVEvt), GTK_STATE_PRELIGHT, &self->priv->resFgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), fgrPVEvt, FALSE, FALSE, 0);

        fgr.WC = &self->priv->resFgRGBC; fgr.WP = fgrPVEvt; fgr.FG = TRUE;
        g_signal_connect (buttonfgr, "clicked", G_CALLBACK (color_button_clicked_cb), &fgr);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->resExtFontBoxW);//AP1
//---------

		self->priv->resVisColJusBoxW = gtk_hbox_new (TRUE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res visib", self);
		self->priv->resVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW), 0, self->priv->resVisibilityPosition);//AP1

		self->priv->resVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resVisColJusBoxW), self->priv->resVisibilityPositionSelectorW, TRUE, TRUE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res angle", self);
		self->priv->resTextAngleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "0°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "90°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "180°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "270°");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), 0, self->priv->resTextAngle);//AP1

		self->priv->resTextAngleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resTextAngleSelectorW), "Angle");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resTextAngleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resTextAngleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resVisColJusBoxW), self->priv->resTextAngleSelectorW, TRUE, TRUE, 0);//AP1

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) res justify", self);
		self->priv->resJustifyW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resJustifyW), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resJustifyW), 0, self->priv->resJustify);//AP1

		self->priv->resJustifySelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resJustifySelectorW), "Justification");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resJustifySelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resJustifySelectorW), HILDON_TOUCH_SELECTOR (self->priv->resJustifyW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resVisColJusBoxW), self->priv->resJustifySelectorW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->resVisColJusBoxW);//AP1

		//BEGIN Progress Animation controls
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS Event Monitoring", self);
		self->priv->progrAnimLabelW = gtk_label_new ("Progress Animation");
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->progrAnimLabelW);

		self->priv->progrAnimBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->progrAnimFramesSelectorW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->progrAnimFramesSelectorW), "Disabled");//AP1
		for (i=1;i<=QBW_PROGRESS_ANIMATION_FRAMES_MAX;i++) {
			gchar *f=g_strdup_printf("%d",i);
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->progrAnimFramesSelectorW), f);//AP1
			g_free(f);
		}
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->progrAnimFramesSelectorW), 0, self->priv->progressAnimationFrames);//AP1

		self->priv->progrAnimFramesW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->progrAnimFramesW), "Frames");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->progrAnimFramesW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->progrAnimFramesW), HILDON_TOUCH_SELECTOR (self->priv->progrAnimFramesSelectorW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->progrAnimBoxW), self->priv->progrAnimFramesW, FALSE, FALSE, 0);//AP

		self->priv->progrAnimTimerSelectorW = hildon_touch_selector_new_text ();//AP1
		for (i=0;i<=40;i++) {
			gchar *f=g_strdup_printf("%d",i*QBW_PROGRESS_ANIMATION_FRAMES_TIMER_STEPS_MSECS);
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->progrAnimTimerSelectorW), f);//AP1
			g_free(f);
		}
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->progrAnimTimerSelectorW), 0, self->priv->progressAnimationTimer);//AP1

		self->priv->progrAnimTimerW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->progrAnimTimerW), "mSecs");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->progrAnimTimerW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->progrAnimTimerW), HILDON_TOUCH_SELECTOR (self->priv->progrAnimTimerSelectorW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->progrAnimBoxW), self->priv->progrAnimTimerW, FALSE, FALSE, 0);//AP

		self->priv->progrAnimPosSelectorW = hildon_touch_selector_new_text ();//AP1
		for(i=1;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->progrAnimPosSelectorW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->progrAnimPosSelectorW), 0, self->priv->progressAnimationPos);//AP1

		self->priv->progrAnimPosW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->progrAnimPosW), "Default Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->progrAnimPosW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->progrAnimPosW), HILDON_TOUCH_SELECTOR (self->priv->progrAnimPosSelectorW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->progrAnimBoxW), self->priv->progrAnimPosW, FALSE, FALSE, 0);//AP

		self->priv->checkAnimClkXYW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkAnimClkXYW), "@Click X,Y");
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkAnimClkXYW), self->priv->progressAnimationAtClickXY);
		gtk_box_pack_start (GTK_BOX (self->priv->progrAnimBoxW), self->priv->checkAnimClkXYW, TRUE, TRUE, 0);//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->progrAnimBoxW);

		self->priv->progrAnimBasenameW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->progrAnimBasenameW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->progrAnimBasenameW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->progrAnimBasenameW), self->priv->progressAnimationBasename);
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->progrAnimBasenameW);


		//BEGIN Update Policy
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Update Policy", self);
		self->priv->updPolicyLabelW = gtk_label_new ("Update Policy");
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updPolicyLabelW);

		self->priv->updBoxW = gtk_hbox_new (TRUE, 0);//AP1

		self->priv->checkBtStartupW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtStartupW), "@Startup");
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtStartupW), self->priv->updOnStartup);
		gtk_box_pack_start (GTK_BOX (self->priv->updBoxW), self->priv->checkBtStartupW, TRUE, TRUE, 0);//AP1

		self->priv->checkBtClickW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtClickW), "@Click");
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtClickW), self->priv->updOnClick);
		gtk_box_pack_start (GTK_BOX (self->priv->updBoxW), self->priv->checkBtClickW, TRUE, TRUE, 0);//AP1

		self->priv->checkBtDesktopW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtDesktopW), "@Desktop");
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtDesktopW), self->priv->updOnDesktop);
		gtk_box_pack_start (GTK_BOX (self->priv->updBoxW), self->priv->checkBtDesktopW, TRUE, TRUE, 0);//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updBoxW);//AP1

		self->priv->intervalNetBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->intervalSelectorW = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "Disable");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "30 Sec");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "1 Min");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "5 Mins");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "30 Mins");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "1 Hour");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "6 Hours");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "12 Hours");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "1 Day");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "Custom(Secs)");

		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), 0, self->priv->delayIndex);

		self->priv->intervalSelBtW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->intervalSelBtW), "@Interval");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->intervalSelBtW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->intervalSelBtW), HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW));
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->intervalSelBtW, TRUE, TRUE, 0);//AP1

		self->priv->intervalCustomEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_widget_set_size_request (GTK_WIDGET (self->priv->intervalCustomEntryW), (int)100, (int)-1);//AP
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->intervalCustomEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->intervalCustomEntryW), input_mode);
		gchar *cusIntervalEntryStr = g_strdup_printf("%u", self->priv->customIntervalSecs);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cusIntervalEntryStr = %s", self, cusIntervalEntryStr);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->intervalCustomEntryW), cusIntervalEntryStr);
		g_free(cusIntervalEntryStr);
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->intervalCustomEntryW, FALSE, FALSE, 0);//AP1
		self->priv->delayIndex == 9 ? gtk_widget_set_sensitive (GTK_WIDGET(self->priv->intervalCustomEntryW), TRUE):gtk_widget_set_sensitive (GTK_WIDGET(self->priv->intervalCustomEntryW), FALSE);

		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->delayIndex = %d", self, self->priv->delayIndex);
		g_signal_connect (G_OBJECT (self->priv->intervalSelBtW), "value-changed",G_CALLBACK (on_interval_picker_value_changed), HILDON_ENTRY (self->priv->intervalCustomEntryW));

		self->priv->networkPolicySelW = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), "Disabled");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), "@Connected");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), "@Disconnected");
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), 0, self->priv->updNeworkPolicy);

		self->priv->networkPolBtW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->networkPolBtW), "Network");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->networkPolBtW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->networkPolBtW), HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW));
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->networkPolBtW, TRUE, TRUE, 0);//AP1

		self->priv->checkBtSightW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtSightW), "@Sight");
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtSightW), self->priv->updOnSight);
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->checkBtSightW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->intervalNetBoxW);

		//BEGIN DBUS Event Monitoring
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS Event Monitoring", self);
		self->priv->monDBUSLabelW = gtk_label_new ("DBUS Event Monitoring");
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->monDBUSLabelW);

		self->priv->DBUSBoxW = gtk_hbox_new (TRUE, 0);//AP1

		self->priv->updOnDBUSSelectorW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), "Disabled");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), "Enabled");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), 0, self->priv->updOnDBUS);//AP1

		self->priv->updOnDBUSW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->updOnDBUSW), "DBUS Monitor");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->updOnDBUSW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->updOnDBUSW), HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->DBUSBoxW), self->priv->updOnDBUSW, TRUE, TRUE, 0);//AP

		self->priv->updOnDBUSbusSelectorW = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), "System");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), "Session");
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), 0, self->priv->updOnDBUSBus);

		self->priv->updOnDBUSbusW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->updOnDBUSbusW), "DBUS Type");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->updOnDBUSbusW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->updOnDBUSbusW), HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW));
		gtk_box_pack_start (GTK_BOX (self->priv->DBUSBoxW), self->priv->updOnDBUSbusW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->DBUSBoxW);

		self->priv->updOnDBUSMatchRuleBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->updOnDBUSMatchRuleLabelW = gtk_label_new ("");
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Match Rule", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->updOnDBUSMatchRuleLabelW), "<span foreground=\"red\" font=\"13\">Match Rule: </span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->updOnDBUSMatchRuleLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->updOnDBUSMatchRuleBoxW), self->priv->updOnDBUSMatchRuleLabelW, FALSE, FALSE, 0);//AP

		self->priv->updOnDBUSMatchRuleW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->updOnDBUSMatchRuleW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->updOnDBUSMatchRuleW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->updOnDBUSMatchRuleW), self->priv->updOnDBUSMatchRule);
		gtk_box_pack_start (GTK_BOX (self->priv->updOnDBUSMatchRuleBoxW), self->priv->updOnDBUSMatchRuleW, TRUE, TRUE, 0);//AP

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updOnDBUSMatchRuleBoxW);

		//BEGIN Remember Me Value
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Remember Me Value", self);
		self->priv->rememberMeLabelW = gtk_label_new ("Remember Me Value");
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->rememberMeLabelW);

		self->priv->rememberMeW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->rememberMeW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->rememberMeW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->rememberMeW), self->priv->rememberMe);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->rememberMeW);

		gtk_widget_show_all (self->priv->dialogW);
		//END

		//BEGIN settings processing
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) settingsRunning out= %d",self, settingsRunning);
		while ( settingsRunning ) {
			int setDialogReturn = 0;
			self->priv->currentDialog=self->priv->dialogW;
			setDialogReturn = gtk_dialog_run (GTK_DIALOG (self->priv->dialogW));
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) setDialogReturn() = %d",self, setDialogReturn);
			if ( setDialogReturn == GTK_RESPONSE_ACCEPT || setDialogReturn == NON_GTK_RESPONSE_SAVE_AND_RUN || setDialogReturn == NON_GTK_RESPONSE_ADVANCED ) {
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) setDialogReturn = %d", self, setDialogReturn);
				if (setDialogReturn == NON_GTK_RESPONSE_ADVANCED) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED call PRO dialog",self);
					self->priv->goProW = hildon_note_new_confirmation (GTK_WINDOW(self->priv->dialogW), "WARNING! Settings need to be saved before proceeding with Advanced Functions.\n\nAre you really sure you want to go \"PRO\"?");
					gint retcode = gtk_dialog_run (GTK_DIALOG (self->priv->goProW));
					gtk_widget_destroy (self->priv->goProW);
					if (retcode != GTK_RESPONSE_OK) {
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED got scared!!! Beat it! :)",self);
						continue;
					}
				}
				int cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) GTK_RESPONSE_ACCEPT cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);
				if(cmdSel < self->priv->c_size && cmdSel >= 0) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Fetching cmdSel in internal command list", self);
					g_free(self->priv->instanceTitle);self->priv->instanceTitle=NULL;
					self->priv->instanceTitle = strdup(self->priv->c_titles[cmdSel]);
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
					g_free(self->priv->instanceCmd);self->priv->instanceCmd=NULL;
					self->priv->instanceCmd = strdup(self->priv->c_commands[cmdSel]);
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
				}

				self->priv->widgetType = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), 0);//AP2

				self->priv->widgetVisible = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), 0);//AP2

				guint prevOperationalStatus = self->priv->operationalStatus;
				self->priv->operationalStatus = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), 0);//AP2

				self->priv->hideCanvas = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtHideCanvasW));
				self->priv->hideClickCanvas = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtHideClkCanvasW));

				g_free(self->priv->snippetExtBgRGB); self->priv->snippetExtBgRGB = gdk_color_to_string(&self->priv->snippetBgRGBC);

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
				self->priv->beecon_lt0_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_lt0_ImgEntryW)));
				g_free(self->priv->beecon_lt0_ExtBgRGB); self->priv->beecon_lt0_ExtBgRGB = gdk_color_to_string(&self->priv->lt0_BgRGBC);

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
				self->priv->beecon_eq0_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_eq0_ImgEntryW)));
				g_free(self->priv->beecon_eq0_ExtBgRGB); self->priv->beecon_eq0_ExtBgRGB = gdk_color_to_string(&self->priv->eq0_BgRGBC);

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
				self->priv->beecon_eq1_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_eq1_ImgEntryW)));
				g_free(self->priv->beecon_eq1_ExtBgRGB); self->priv->beecon_eq1_ExtBgRGB = gdk_color_to_string(&self->priv->eq1_BgRGBC);

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
				self->priv->beecon_ge2_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_ge2_ImgEntryW)));
				g_free(self->priv->beecon_ge2_ExtBgRGB); self->priv->beecon_ge2_ExtBgRGB = gdk_color_to_string(&self->priv->ge2_BgRGBC);

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
				self->priv->beecon_idxge2_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_idxge2_ImgEntryW)));
				g_free(self->priv->beecon_idxge2_ExtBgRGB); self->priv->beecon_idxge2_ExtBgRGB = gdk_color_to_string(&self->priv->idxge2_BgRGBC);

				self->priv->widXOrigin = gtk_range_get_value(GTK_RANGE(self->priv->widPositionXW));
				self->priv->widYOrigin = gtk_range_get_value(GTK_RANGE(self->priv->widPositionYW));

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Window Position Previous x=%d y=%d Current x=%d y=%d ", self, widXOrigin, widYOrigin, self->priv->widXOrigin, self->priv->widYOrigin);
				if (self->priv->widXOrigin != widXOrigin || self->priv->widYOrigin != widYOrigin) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Fine Tuning Window Position x=%d y=%d", self, self->priv->widXOrigin, self->priv->widYOrigin);
					gtk_window_move (GTK_WINDOW (self), (int)(self->priv->widXOrigin), (int)(self->priv->widYOrigin));//AP
				}

				self->priv->widWidth = gtk_range_get_value(GTK_RANGE(self->priv->widthSelectW));
				self->priv->widHeight = gtk_range_get_value(GTK_RANGE(self->priv->heightSelectW));

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
				g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->titleImgEntryW)));
				self->priv->cmdImgAngle = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdImgAngleW), 0);//AP2
				self->priv->cmdImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), 0);//AP2
				g_free(self->priv->cmdExtFgRGB); self->priv->cmdExtFgRGB = gdk_color_to_string(&self->priv->cmdFgRGBC);
				self->priv->cmdTextAngle = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), 0);//AP2
				self->priv->cmdVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW), 0);//AP2
				self->priv->cmdImgVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW), 0);//AP2
				self->priv->cmdJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW), 0);//AP2
				g_free(self->priv->cmdExtFont); self->priv->cmdExtFont = g_strdup(hildon_button_get_value (HILDON_BUTTON(buttoncfo)));

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
				g_free(self->priv->resImgFilename);self->priv->resImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->resultsImgEntryW)));
				self->priv->resImgAngle = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resImgAngleW), 0);//AP2
				self->priv->resImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), 0);//AP2
				g_free(self->priv->resExtFgRGB); self->priv->resExtFgRGB = gdk_color_to_string(&self->priv->resFgRGBC);
				self->priv->resTextAngle = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), 0);//AP2
				self->priv->resVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW), 0);//AP2
				self->priv->resImgVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW), 0);//AP2
				self->priv->resJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resJustifyW), 0);//AP2
				g_free(self->priv->resExtFont); self->priv->resExtFont = g_strdup(hildon_button_get_value (HILDON_BUTTON(buttonrfo)));

				// Fetch Progress animation settings
				self->priv->progressAnimationFrames = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->progrAnimFramesSelectorW), 0);
				self->priv->progressAnimationTimer = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->progrAnimTimerSelectorW), 0);
				self->priv->progressAnimationPos = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->progrAnimPosSelectorW), 0);
				g_free(self->priv->progressAnimationBasename); self->priv->progressAnimationBasename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->progrAnimBasenameW)));
				self->priv->progressAnimationAtClickXY = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkAnimClkXYW));

				// DBUS Monitort mode need previous state
				guint  prev_updOnDBUS          = self->priv->updOnDBUS;
				guint  prev_updOnDBUSBus       = self->priv->updOnDBUSBus;
				gchar *prev_updOnDBUSMatchRule = g_strdup(self->priv->updOnDBUSMatchRule);

				self->priv->updOnDBUS = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), 0);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->updOnDBUS = %d (1=Enabled 0=Disabled)", self, self->priv->updOnDBUS);
				self->priv->updOnDBUSBus =  hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), 0); //(0=system/1=session)
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->updOnDBUSBus = %d (0=System 1=Session)", self, self->priv->updOnDBUSBus);
				g_free(self->priv->updOnDBUSMatchRule);
				self->priv->updOnDBUSMatchRule = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->updOnDBUSMatchRuleW)));
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->updOnDBUSMatchRule = %p [%s]", self, self->priv->updOnDBUSMatchRule, self->priv->updOnDBUSMatchRule);

				if (self->priv->updOnDBUS!=prev_updOnDBUS ||
						self->priv->updOnDBUSBus!=prev_updOnDBUSBus ||
						g_strcmp0(prev_updOnDBUSMatchRule, self->priv->updOnDBUSMatchRule)) { // Hase something changed here?
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS monitor active, disarm connection, match and filter", self);
					queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, prev_updOnDBUSBus, prev_updOnDBUSMatchRule);
				}
				if (self->priv->updOnDBUS && self->priv->operationalStatus==0) { //Is DBUS Monitor active and Instance active?
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS monitor starting, rearm connection, match and filter", self);
					if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
						self->priv->updOnDBUS          = 0;
						reloadInstanceSettings = TRUE;
					}
				}
				if (self->priv->operationalStatus!=0) { //Instance is disabled, disarm DBUS Monitor
					queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule);
				}

				g_free(prev_updOnDBUSMatchRule); //Not needed any more

				g_free(self->priv->rememberMe);	self->priv->rememberMe = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->rememberMeW)));

				self->priv->updOnStartup = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtStartupW));
				self->priv->updOnClick = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtClickW));
				self->priv->updOnDesktop = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtDesktopW));
				self->priv->updOnSight = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtSightW));

				self->priv->delayIndex = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), 0);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) got self->priv->delayIndex %u",self, self->priv->delayIndex);
				gchar *cusIntervalEntryStrX;
				gchar *cusIntervalEntryStrY = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->intervalCustomEntryW)));
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) cusIntervalEntryStrY %s",self, cusIntervalEntryStrY);
				self->priv->customIntervalSecs = strtol(cusIntervalEntryStrY, &cusIntervalEntryStrX, 0);
				g_free(cusIntervalEntryStrY);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->delayIndex %u",self, self->priv->delayIndex);

				guint prevDelaySeconds = self->priv->delaySeconds;
				if (self->priv->delayIndex == 9) { // Custom Seconds
					self->priv->delaySeconds = self->priv->customIntervalSecs;
				} else {// Indexed Timer
					self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);
				}
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->delaySeconds %u",self, self->priv->delaySeconds);

				if(self->priv->delaySeconds != prevDelaySeconds ||
						self->priv->delaySeconds==0 ||
						self->priv->operationalStatus==1 ||
						(prevOperationalStatus == 1 && self->priv->operationalStatus==0)) { // Do we need to reset and rearm timer?
					if (self->priv->updateTimerID) {
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
						g_source_remove (self->priv->updateTimerID);
					}
					if (self->priv->delaySeconds > 0 && self->priv->operationalStatus==0) {
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) re-arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
						self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
					}
				}

				self->priv->updNeworkPolicy = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), 0);

				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) GTK_RESPONSE_ACCEPT write settings()",self);
				queen_beecon_write_settings (self, TRUE);

				if (setDialogReturn == NON_GTK_RESPONSE_ADVANCED) {
					guint  prev_updOnDBUSBus       = self->priv->updOnDBUSBus;
					gchar *prev_updOnDBUSMatchRule = g_strdup(self->priv->updOnDBUSMatchRule);

					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED gone PRO call PRO dialog",self);
					if (!queen_beecon_advanced_dialog(self, hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0))) {
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED nothing relevant happened ... just refresh command selector and nothing else to do",self);

						gint cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0);
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);
						self->priv->selectorW = hildon_touch_selector_new_text ();
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED new selector %p", self, self->priv->selectorW);
						for(i=0;i<self->priv->c_size;i++) {
							qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED rebuilding selector c_titles[%d] = %s", self, i, self->priv->c_titles[i]);
							hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->selectorW), self->priv->c_titles[i]);
						}
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED cmdSelector %p selector %p", self, self->priv->cmdSelectorW, self->priv->selectorW);
						hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), HILDON_TOUCH_SELECTOR (self->priv->selectorW));
						hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0, cmdSel);
						hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), cmdSel);
						g_free(prev_updOnDBUSMatchRule);
						continue;
					}
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED something happened... let's queen_beecon_update_content_layout",self);
					queen_beecon_update_content_layout (self);
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADVANCED reloadInstanceSettings=TRUE",self);
					reloadInstanceSettings=TRUE;
					if (self->priv->updateTimerID) { // New instance loaded, we assume timers need reset
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) removing self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
						g_source_remove (self->priv->updateTimerID);
					}
					if (self->priv->delaySeconds > 0 && self->priv->operationalStatus==0) { // New instance loaded, we assume timers need rearm if instance is enabled
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) re-arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
						self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
					}

					queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, prev_updOnDBUSBus, prev_updOnDBUSMatchRule);

					if (self->priv->updOnDBUS && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
						qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) DBUS monitor starting, rearm connection, match and filter", self);
						if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
							self->priv->updOnDBUS          = 0;
						}
					}

					g_free(prev_updOnDBUSMatchRule);
				}
				if (setDialogReturn == NON_GTK_RESPONSE_SAVE_AND_RUN) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_SAVE_AND_RUN update content requested! self->priv->operationalStatus=%d",self, self->priv->operationalStatus);
					if (self->priv->operationalStatus==0) {// Wake up and restore size and operations
						queen_beecon_update_content (self, qbwExecReason[QBW_SETTINGS_SAVE_RUN]);
					} else {
						hildon_banner_show_information (NULL, NULL, "WARNING! Widget is disabled, command NOT executed!");
					}
				} else { //GTK_RESPONSE_ACCEPT == NON_GTK_RESPONSE_SAVE
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) GTK_RESPONSE_ACCEPT update content layout",self);
					queen_beecon_update_content_layout (self);
				}
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) settingsRunning = 0",self);
				settingsRunning = FALSE;
			} else if(setDialogReturn == NON_GTK_RESPONSE_ADD_CMD || setDialogReturn == NON_GTK_RESPONSE_EDIT_CMD ) { // ADD/EDIT COMMAND
				gint cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_xxxx_CMD cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);

				gint prevRollCall = self->priv->c_size; // Let's count how many command we have before operation
				if( setDialogReturn == NON_GTK_RESPONSE_ADD_CMD ) { // New command input
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_ADD_CMD call edit/add dialog",self);
					if (!queen_beecon_edit_add_dialog(self, TRUE, 0)) continue; // ADD/EDIT Dialog Cancelled ... just yield and loop again
				} else { // If current active selection then edit command
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_EDIT_CMD call edit/add dialog command [%d]",self, cmdSel);
					if (!queen_beecon_edit_add_dialog(self, FALSE, cmdSel)) continue; // ADD/EDIT Dialog Cancelled ... just yield and loop again
				}
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_xxxx_CMD write settings()",self);
				queen_beecon_write_settings (self, FALSE); // We write commands to config file

				self->priv->selectorW = hildon_touch_selector_new_text ();
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_xxxx_CMD new selector %p", self, self->priv->selectorW);
				for(i=0;i<self->priv->c_size;i++) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_xxxx_CMD rebuilding selector c_titles[%d] = %s", self, i, self->priv->c_titles[i]);
					hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->selectorW), self->priv->c_titles[i]);
				}
				if (self->priv->c_size < prevRollCall) {// TRUE if command has been deleted
					cmdSel = 0;
				} else if (self->priv->c_size > prevRollCall) {// TRUE if command has been added
					cmdSel = self->priv->c_size - 1;
				}
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) NON_GTK_RESPONSE_xxxx_CMD cmdSelector %p selector %p", self, self->priv->cmdSelectorW, self->priv->selectorW);
				hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), HILDON_TOUCH_SELECTOR (self->priv->selectorW));
				hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0, cmdSel);
			    hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), cmdSel);
				//END ADD/EDIT COMMAND
			} else
				settingsRunning = FALSE;
		}
		gtk_widget_destroy (self->priv->dialogW);
	}
	//END
	gtk_widget_queue_draw (GTK_WIDGET (self));//AP3

	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) settingsOn = FALSE exit critical region",self);
	QUEEN_BEECON_GET_CLASS(self)->settingsOn = FALSE; // Reset settingsON critical region
}

gboolean queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V1, "(%p) %s new=%d curr=%d",self, G_STRFUNC, new, curr);
	GtkWidget *dialog = NULL;
	HildonGtkInputMode input_mode;
	gchar *title = NULL;
	gboolean needWrite = TRUE;

	if ( new ) {// ADD Title
		title = g_strconcat ("Add new command", NULL);
		dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, NULL);
	} else {// EDIT Title
		if (curr>=0) {
			title = g_strconcat ("Edit ", self->priv->c_titles[curr] ," List Command", NULL);
			dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, _("wdgt_bd_delete"), NON_GTK_RESPONSE_DELETE_CMD, NULL);
		} else {
			title = g_strconcat ("Edit ", self->priv->instanceTitle ," Instance Command (Use button to add it to list)", NULL);
			dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, "Add to List", NON_GTK_RESPONSE_ADD_CMD, NULL);
		}
	}
	GtkWidget *content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	//BEGIN title
	GtkWidget *titleBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *titleLabel = gtk_label_new ("Title:");
	gtk_misc_set_alignment (GTK_MISC (titleLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (titleLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, titleLabel);

	GtkWidget *titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (titleEntry));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (titleEntry), input_mode);
	gtk_box_pack_start (GTK_BOX (titleBox), titleLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (titleBox), titleEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), titleBox);

	//BEGIN command
	GtkWidget *commandBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *commandLabel = gtk_label_new ("Command:");
	gtk_misc_set_alignment (GTK_MISC (commandLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (commandLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, commandLabel);

	GtkWidget *commandEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (commandEntry));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (commandEntry), input_mode);
	gtk_box_pack_start (GTK_BOX (commandBox), commandLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (commandBox), commandEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), commandBox);
	//END BUILD DIALOG

	if(!new) {// EDIT
		if (curr>=0) { // Edit List command
			hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->c_titles[curr]);
			hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->c_commands[curr]);
		} else { // Edit Instance command
			hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->instanceTitle);
			hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->instanceCmd);
		}
	}

	//END

	gtk_widget_show_all (dialog);
	int dialogRunResponse = gtk_dialog_run (GTK_DIALOG (dialog));

	switch(dialogRunResponse) {
		case GTK_RESPONSE_ACCEPT:
			if(g_strcmp0((gchar *)"",hildon_entry_get_text (HILDON_ENTRY (titleEntry))) == 0)
				hildon_entry_set_text(HILDON_ENTRY (titleEntry), "[No Title]");
			if ( new ) // ADD
				AddCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE);
			else // EDIT
				EditCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE, curr);
			break;
		case NON_GTK_RESPONSE_ADD_CMD:
			AddCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE);
			break;
		case NON_GTK_RESPONSE_DELETE_CMD:
			DelCommand(self, curr); // DELETE command in list
			break;
		default:
			needWrite = FALSE;
	}
	gtk_widget_destroy (dialog);
	g_free(title);
	return ( needWrite );
}

//Auxiliary functions
void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V2, "(%p) AddCommand title=[%s] command=[%s] doInstantiate=%d", self, s_title, s_command, doInstantiate);
	int i;

	gchar **newTitles = malloc( sizeof(gchar*)*(self->priv->c_size+2) );
	gchar **newCommands = malloc( sizeof(gchar*)*(self->priv->c_size+2) );

	for(i=0;i<self->priv->c_size;i++) {
		newTitles[i] = g_strdup(self->priv->c_titles[i]);
		newCommands[i] = g_strdup(self->priv->c_commands[i]);
	}

	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;
	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	newTitles[self->priv->c_size] = s_title;
	newCommands[self->priv->c_size] = s_command;

	newTitles[self->priv->c_size+1] = NULL;
	newCommands[self->priv->c_size+1] = NULL;

	if (doInstantiate) {
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);	self->priv->instanceTitle = NULL;
		self->priv->instanceTitle = strdup(newTitles[self->priv->c_size]);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);	self->priv->instanceCmd = NULL;
		self->priv->instanceCmd = strdup(newCommands[self->priv->c_size]);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	}

	self->priv->c_size += 1;

	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;
}

void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate, int index)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V2, "(%p) EditCommand title=[%s] command=[%s] index=[%d]", self, s_title, s_command, index);
	//Clean old
	if (index>=0) { // Command is one of the listed commands
		g_free(self->priv->c_titles[index]);
		self->priv->c_titles[index] = s_title;

		g_free(self->priv->c_commands[index]);
		self->priv->c_commands[index] = s_command;
	}

	if (doInstantiate) {
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);
		self->priv->instanceTitle = g_strdup(s_title);

		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);
		self->priv->instanceCmd = g_strdup(s_command);
	}
}

void DelCommand(QueenBeecon *self, int index)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V2, "(%p) %s index=%d", self, G_STRFUNC, index);
	int i;

	gchar **newTitles = malloc( sizeof(gchar*)*(self->priv->c_size) );
	gchar **newCommands = malloc( sizeof(gchar*)*(self->priv->c_size) );

	for(i=0;i<self->priv->c_size;i++) {
		//index is the delete target
		if(i < index) {
			newTitles[i] = g_strdup(self->priv->c_titles[i]);
			newCommands[i] = g_strdup(self->priv->c_commands[i]);
		} else if(i > index) {
			newTitles[i-1] = g_strdup(self->priv->c_titles[i]);
			newCommands[i-1] = g_strdup(self->priv->c_commands[i]);
		}
	}
	newTitles[self->priv->c_size-1] = NULL;
	newCommands[self->priv->c_size-1] = NULL;

	//clear old
	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;

	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	//assign new
	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;

	if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);
	self->priv->instanceTitle = NULL;

	if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);
	self->priv->instanceCmd = NULL;

	if(self->priv->c_size > 1) {
		self->priv->instanceTitle = g_strdup(newTitles[0]);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		self->priv->instanceCmd = g_strdup(newCommands[0]);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	}

	self->priv->c_size -= 1;//decrement size
}

guint GetSeconds(guint index)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s index=%d", NULL, G_STRFUNC, index);
	if(index > 0 && index < 9) {
		guint intervalTimes[] = {0, 30, 60, 300, 1800, 3600, 21600, 43200, 86400};
		return intervalTimes[index];
	}
	return 0;
}
