/*
 * This file is a part of Queen Beecon Widget
 * http://talk.maemo.org/showthread.php?t=45388
 * queen-beecon-logger: Logger Utility for QBW widget
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef QUEEN_BEECON_LOGGER_H
#define QUEEN_BEECON_LOGGER_H

#define QBW_LOGFILE "queen_beecon.log"
typedef enum {
	QBW_LOGGER_VNULL,
	QBW_LOGGER_V0,
	QBW_LOGGER_V1,
	QBW_LOGGER_V2,
	QBW_LOGGER_V3,
	QBW_LOGGER_V4,
	QBW_LOGGER_VMAX,
} QbwLoggerVerbosity;

typedef enum {
	QBW_LOGGER_INIT,
	QBW_LOGGER_LOG,
	QBW_LOGGER_CHANGE_VERBOSITY,
	QBW_LOGGER_FLUSH,
	QBW_LOGGER_DEINIT,
	QBW_LOGGER_RESET_LOGFILE
} QbwLoggerAction;

#define QBW_LOGGER_DEFAULT_VERBOSITY QBW_LOGGER_VNULL;

void qbw_logger(QbwLoggerAction action, QbwLoggerVerbosity verbosity, const gchar *fmt, ...);

#endif /* QUEEN_BEECON_LOGGER_H */
