/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-logger: Logger Utility for QBW widget
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define G_LOG_DOMAIN "QBW"

#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <sys/stat.h>
#include "queen-beecon.h"
#include "queen-beecon-logger.h"

static QbwLoggerVerbosity loggerVerbosity=QBW_LOGGER_VMAX;

void qbw_logger(QbwLoggerAction action, QbwLoggerVerbosity verbosity, const gchar *fmt, ...)
{
	if (action==QBW_LOGGER_LOG && (loggerVerbosity==QBW_LOGGER_VNULL || verbosity>loggerVerbosity)) return;
	int i;
	if (action!=QBW_LOGGER_LOG) g_warning ("(%p) %s(%d,%d)", NULL, G_STRFUNC, action, verbosity);
	static FILE *logFile=NULL;
	gchar *dirname, *logFilename, *initVerbFilename;
	switch (action) {
	case QBW_LOGGER_INIT:
		loggerVerbosity = QBW_LOGGER_DEFAULT_VERBOSITY;
		dirname = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, NULL);
		g_mkdir_with_parents (dirname, 0755);
		g_free(dirname);
		logFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, QBW_LOGFILE, NULL);
		logFile = fopen (logFilename, "w");
		g_free(logFilename);
		for (i=QBW_LOGGER_VNULL+1;i<QBW_LOGGER_VMAX;i++) {
			struct stat buf;
			initVerbFilename = g_strdup_printf("%s%s%s.v%d", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, QBW_LOGFILE, i-1);
			//g_warning ("(%p) Check V? file [%s]", NULL, initVerbFilename);
			if (!stat(initVerbFilename, &buf)) {
				//g_warning ("(%p) Found V? file [%s]", NULL, initVerbFilename);
				loggerVerbosity=i;
			}
			g_free(initVerbFilename);
		}
		break;
	case QBW_LOGGER_LOG:
		if (logFile) {
			va_list args;
			va_start (args, fmt);
			gchar *msg = g_strdup_vprintf(fmt, args);
			va_end (args);
			GTimeVal tv;
			g_get_current_time (&tv);
			gchar *msg1 = g_strdup_printf("[%lu.%06lu.v%d] %s\n", tv.tv_sec, tv.tv_usec, verbosity-1,msg);
			i=fputs (msg1, logFile);
			if (loggerVerbosity==QBW_LOGGER_VMAX-1) fflush(logFile);
			g_warning("*[%d]%s",i,msg1);
			g_free(msg);
			g_free(msg1);
		}
		break;
	case QBW_LOGGER_CHANGE_VERBOSITY:
		loggerVerbosity = verbosity;
		break;
	case QBW_LOGGER_FLUSH:
		if (logFile) fflush(logFile);
		break;
	case QBW_LOGGER_DEINIT:
		if (logFile) fclose (logFile);
		logFile = NULL;
		break;
	case QBW_LOGGER_RESET_LOGFILE:
		logFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, QBW_LOGFILE, NULL);
		if (logFile) freopen (logFilename, "w", logFile);
		g_free(logFilename);
		break;
	}
}
