/*

queen-beecon.c - Queen Beecon Widget
http://talk.maemo.org/showthread.php?t=

Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)

From and idea/application by cpscotti (Clovis Peruchi Scotti)
(Desktop Command Execution Widget http://talk.maemo.org/showthread.php?t=39177)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

[No!No!No!Yes!]

*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "queen-beecon.h"
#include <hildon/hildon.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <stdlib.h>

#include <conic.h>

#define HOME_DIR g_get_home_dir()

#define _(String) dgettext("hildon-libs", String)

#define QUEEN_BEECON_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, QUEEN_BEECON_TYPE, QueenBeeconPrivate))

#define QUEEN_BEECON_SETTINGS_FILE "/.queen_beecon"
#define QUEEN_BEECON_SETTINGS_VERSION 1.0

//main settings window
#define NON_GTK_RESPONSE_ADD_CMD 10
#define NON_GTK_RESPONSE_EDIT_CMD 20
#define NON_GTK_RESPONSE_DELETE_CMD 30
#define NON_GTK_RESPONSE_SEND_TO_BACK 40
//save is GTK_RESPONSE_OK

#define NETWORK__UNRELATED 0
#define NETWORK__ONLY_CONNECTED 1
#define NETWORK__ONLY_DISCONNECTED 2

#define SIZE_WIDTH_ALL 800
#define SIZE_HEIGHT_ALL 400//AP3
#define SIZE_BEECON_RATIO 2 * 1.7//AP3

struct _colorsRGB
{
	gchar *colorName;
	gchar *colorRGB;
} p_colors[] = {//AP3
		{"Black",	"#000000" },
		{"White", 	"#FFFFFF" },
		{"Gray",	"#808080" },
		{"Lime",	"#00FF00" },
		{"Yellow",	"#FFFF00" },
		{"Red",		"#FF0000" },
		{"Magenta",	"#FF00FF" },
		{"Silver",	"#C0C0C0" },
		{"Olive",	"#808000" },
		{"Purple",	"#800080" },
		{"Maroon",	"#800000" },
		{"Aqua",	"#00FFFF" },
		{"Teal",	"#008080" },
		{"Green",	"#008000" },
		{"Blue",	"#0000FF" },
		{"Navy",	"#000080" },
		{NULL,		"#000000" }
};

gchar * p_justification[] = {//AP3
	"Left","Right","Center","Fill", NULL};//AP1

gchar * p_visible_position[] = {//AP3
	"Hidden","Top Left","Top Center","Top Right","Center Left","Center","Center Right","Bottom Left","Bottom Center","Bottom Right",NULL};//AP1

gchar * p_fonts[] = {//AP1
		"Nokia,Sans","NewCourier","NewTimes","Monospace","Nokia,Sans,Cn","Nokia,Sans,Maps","Nokia,Sans,SemiBold","Sans","Serif","SwissA","Tanseek,Pro,Arabic","Univers,OTS,Arabic",NULL};//AP1

gchar * p_fonts_types[] = {//AP1
	 "Regular", "Italic", "Bold","Italic Bold", NULL};//AP1

void queen_beecon_write_settings (QueenBeecon *self, gboolean newAll, gboolean newInstance, gboolean removeInstance);
gboolean queen_beecon_update_content (QueenBeecon *self);

//Dialogs prototypes:
void queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr);
void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self);

//Auxiliary functions' prototypes:
void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command);
void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, int index);
void DelCommand(QueenBeecon *self, int index);
guint GetSeconds(guint index);

struct _QueenBeeconPrivate
{

	GtkWidget 		*homeWidget;
	GtkWidget 		*event;
	GtkWidget 		*contents;

	GtkWidget 		*cmdTitle_lb;
	GtkWidget 		*cmdResult_lb;

	gboolean 		isPressed;

	/* widget's instance identification str */
	gchar 			*widgetID;

	//config data

	//global data
		gchar 		**c_titles;
		gchar 		**c_commands;
		guint 		c_size;

	//instance data
		gboolean 		updOnClick;
		gboolean 		updOnDesktop;
		guint 			updNeworkPolicy;

		gint			widXOrigin;
		gint			widYOrigin;
		gdouble 		widWidth;
		gdouble 		widHeight;//AP

		guint 			snippetBgRGB;
		guint 			beecon_lt0_BgRGB;
		guint 			beecon_eq0_BgRGB;
		guint 			beecon_eq1_BgRGB;
		guint 			beecon_ge2_BgRGB;

		guint	 		widgetType;//AP3
		gint 			cmdExitStatus;//AP3

		GtkWidget 		*tableLayout;

		guint 			cmdFgRGB;
		guint 			cmdVisibilityPosition;//AP3
		guint 			cmdJustify;//AP3
		guint 			cmdFontName;//AP1
		gdouble 		cmdFontSize;//AP1

		guint 			resFgRGB;
		guint 			resVisibilityPosition;//AP3
		GtkWidget 		*resPos;
		guint 			resJustify;//AP3
		guint 			resFontName;//AP1
		gdouble 		resFontSize;//AP1

		gchar 			*instanceTitle;
		gchar 			*instanceCmd;

		//Update on timer data
		guint 			delaySeconds;
		guint 			delayIndex;//index of delaySeconds in the array defined inside "queen_beecon_settings"

		//timer process id; used to stop when closing app or changing delay
		guint 			updateTimerID;

		//network connection query ptr
		ConIcConnection	*connection;
		gboolean 		isConnected;
};

HD_DEFINE_PLUGIN_MODULE (QueenBeecon, queen_beecon, HD_TYPE_HOME_PLUGIN_ITEM);


//Settings file functions

void queen_beecon_read_settings ( QueenBeecon *self )
{
g_warning("(%p) queen_beecon_read_settings",self);
	gchar *filename;
	gboolean fileExists;
	GKeyFile *keyFile;

	gboolean noSettingsFlag;
	gboolean noInstanceKeysFlag;

	noSettingsFlag = FALSE;
	noInstanceKeysFlag = FALSE;

	if(self->priv->widgetID == NULL)
	{
g_warning("(%p) Widget instance not initialized, not reading settings..", self);
		return;
	}


	keyFile = g_key_file_new();
g_warning("(%p) keyfile %p", self, keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
g_warning("(%p) fileExists %d", self, fileExists);


	if (fileExists) {
		GError *error=NULL;

		gdouble settingsVer = g_key_file_get_double (keyFile, "config", "version", &error);
g_warning("(%p) settingsVer %f", self, settingsVer);
		if (error || settingsVer != QUEEN_BEECON_SETTINGS_VERSION) {
g_warning("(%p) Settings file missing or incompatible version", self);
			noSettingsFlag = TRUE;
			noInstanceKeysFlag = TRUE;
			g_error_free (error);
			error = NULL;
		}
		else
		{
			/*gets "global" data/commands list */
			//BEGIN get list
			g_strfreev(self->priv->c_commands);
			self->priv->c_commands = (gchar **) g_key_file_get_string_list (keyFile, "config", "c_commands", &(self->priv->c_size) ,&error);
g_warning("(%p) c_size=%d", self, self->priv->c_size);
gint i;	for (i=0;i<self->priv->c_size;i++) g_warning("(%p) c_commands[%d]=%s", self, i, self->priv->c_commands[i]);
			if (error) {
g_warning("(%p) ERROR g_key_file_get_string_list (keyFile, \"config\", \"c_commands\", ...)", self);
				noSettingsFlag = TRUE;
				g_error_free (error);
				error = NULL;
			}

			guint consistencyCheck = -1;
			g_strfreev(self->priv->c_titles);
			self->priv->c_titles = g_key_file_get_string_list (keyFile, "config", "c_titles", &consistencyCheck ,&error);
g_warning("(%p) consistencyCheck=%d", self, consistencyCheck);
gint j;	for (j=0;j<consistencyCheck;j++) g_warning("(%p) c_titles[%d]=%s", self, j, self->priv->c_titles[j]);
			if (error) {
g_warning("(%p) ERROR g_key_file_get_string_list (keyFile, \"config\", \"c_titles\", ...)", self);
				noSettingsFlag = TRUE;
				g_error_free (error);
				error = NULL;
			}

			if(consistencyCheck != self->priv->c_size)
			{
g_warning("(%p) Settings file corrupted!", self);
				noSettingsFlag = TRUE;
			}
			//END


			/*getting instance specific data*/
			//BEGIN
			self->priv->widgetType = g_key_file_get_integer (keyFile, self->priv->widgetID, "widgetType", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->widgetType = 0;//0=Beecon

g_warning("(%p) no widgetType on key file, assuming %d", self, self->priv->widgetType);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->snippetBgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "snippetBgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->snippetBgRGB = 0;//0=Black

g_warning("(%p) no snippetBgRGB on key file, assuming %d", self, self->priv->snippetBgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->beecon_lt0_BgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "beecon_lt0_BgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->beecon_lt0_BgRGB = 2;//2=Gray

g_warning("(%p) no beecon_lt0_BgRGB on key file, assuming %d", self, self->priv->beecon_lt0_BgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->beecon_eq0_BgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "beecon_eq0_BgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->beecon_eq0_BgRGB = 3;//3=Green

g_warning("(%p) no beecon_eq0_BgRGB on key file, assuming %d", self, self->priv->beecon_eq0_BgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->beecon_eq1_BgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "beecon_eq1_BgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->beecon_eq1_BgRGB = 4;//4=yellow

g_warning("(%p) no beecon_eq1_BgRGB on key file, assuming %d", self, self->priv->beecon_eq1_BgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->beecon_ge2_BgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "beecon_ge2_BgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->beecon_ge2_BgRGB = 5;//5=red

g_warning("(%p) no beecon_ge2_BgRGB on key file, assuming %d", self, self->priv->beecon_ge2_BgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->widWidth = g_key_file_get_double (keyFile, self->priv->widgetID, "widWidth", &error);
			if (error) {
				//no value? assume std
				noInstanceKeysFlag = TRUE;
				self->priv->widWidth = 50.0;

g_warning("(%p) no widWidth on key file, assuming %f", self, self->priv->widWidth);

				g_error_free (error);
				error = NULL;
			}

			self->priv->widHeight = g_key_file_get_double (keyFile, self->priv->widgetID, "widHeight", &error);
			if (error) {
				//no value? assume std
				noInstanceKeysFlag = TRUE;
				self->priv->widHeight = 50.0 / SIZE_BEECON_RATIO;//Ready for beecon

g_warning("(%p) no widHeight on key file, assuming %f", self, self->priv->widHeight);//AP3
				g_error_free (error);
				error = NULL;
			}

			self->priv->cmdFgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "cmdFgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->cmdFgRGB = 1;//1-White

g_warning("(%p) no cmdFgRGB on key file, assuming %d", self, self->priv->cmdFgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->cmdVisibilityPosition = g_key_file_get_integer (keyFile, self->priv->widgetID, "cmdVisibilityPosition", &error);//AP2
			if (error) {//AP2
				//no value? assume std//AP2
				noInstanceKeysFlag = TRUE;//AP2
				self->priv->cmdVisibilityPosition = 1;//1=top-left

g_warning("(%p) no cmdVisibilityPosition on key file, assuming %d", self, self->priv->cmdVisibilityPosition);//AP2
				g_error_free (error);//AP2
				error = NULL;//AP2
			}//AP2

			self->priv->cmdJustify = g_key_file_get_integer (keyFile, self->priv->widgetID, "cmdJustify", &error);//AP2
			if (error) {//AP2
				//no value? assume std//AP2
				noInstanceKeysFlag = TRUE;//AP2
				self->priv->cmdJustify = 0;//0=left

g_warning("(%p) no cmdJustify on key file, assuming %d", self, self->priv->cmdJustify);//AP2
				g_error_free (error);//AP2
				error = NULL;//AP2
			}//AP2

			self->priv->cmdFontName = g_key_file_get_integer (keyFile, self->priv->widgetID, "cmdFontName", &error);//AP1
			if (error) {//AP1
				//no value? assume std//AP1
				noInstanceKeysFlag = TRUE;//AP1
				self->priv->cmdFontName = 3;//3=(Nokia Sans, Italic, Bold)

g_warning("(%p) no cmdFontName on key file, assuming %d", self, self->priv->cmdFontName);//AP1
				g_error_free (error);//AP1
				error = NULL;//AP1
			}//AP1

			self->priv->cmdFontSize = g_key_file_get_double (keyFile, self->priv->widgetID, "cmdFontSize", &error);//AP1
			if (error) {//AP1
				//no value? assume std//AP1
				noInstanceKeysFlag = TRUE;//AP1
				self->priv->cmdFontSize = 12;//

g_warning("(%p) no cmdFontSize on key file, assuming %f", self, self->priv->cmdFontSize);//AP1
				g_error_free (error);//AP1
				error = NULL;//AP1
			}//AP1

			self->priv->resFgRGB = g_key_file_get_integer (keyFile, self->priv->widgetID, "resFgRGB", &error);//AP3
			if (error) {//AP3
				//no value? assume std//AP3
				noInstanceKeysFlag = TRUE;//AP3
				self->priv->resFgRGB = 1;//1=White

g_warning("(%p) no resFgRGB on key file, assuming %d", self, self->priv->resFgRGB);//AP3
				g_error_free (error);//AP3
				error = NULL;//AP3
			}//AP3

			self->priv->resVisibilityPosition = g_key_file_get_integer (keyFile, self->priv->widgetID, "resVisibilityPosition", &error);//AP2
			if (error) {//AP2
				//no value? assume std//AP2
				noInstanceKeysFlag = TRUE;//AP2
				self->priv->resVisibilityPosition = 5;//AP2

g_warning("(%p) no resVisibilityPosition on key file, assuming %d", self, self->priv->resVisibilityPosition);//AP2
				g_error_free (error);//AP2
				error = NULL;//AP2
			}//AP2

			self->priv->resJustify = g_key_file_get_integer (keyFile, self->priv->widgetID, "resJustify", &error);//AP2
			if (error) {//AP2
				//no value? assume std//AP2
				noInstanceKeysFlag = TRUE;//AP2
				self->priv->resJustify = 0;//0=left

g_warning("(%p) no resJustify on key file, assuming %d", self, self->priv->resJustify);//AP2
				g_error_free (error);//AP2
				error = NULL;//AP2
			}//AP2

			self->priv->resFontName = g_key_file_get_integer (keyFile, self->priv->widgetID, "resFontName", &error);//AP1
			if (error) {//AP1
				//no value? assume std//AP1
				noInstanceKeysFlag = TRUE;//AP1
				self->priv->resFontName = 2;//2=(Nokia Sans, Bold)

g_warning("(%p) no resFontName on key file, assuming %d", self, self->priv->resFontName);//AP1
				g_error_free (error);//AP1
				error = NULL;//AP1
			}//AP1

			self->priv->resFontSize = g_key_file_get_double (keyFile, self->priv->widgetID, "resFontSize", &error);//AP1
			if (error) {//AP1
				//no value? assume std//AP1
				noInstanceKeysFlag = TRUE;//AP1
				self->priv->resFontSize = 12;//AP1

g_warning("(%p) no resFontSize on key file, assuming %f", self, self->priv->resFontSize);//AP1
				g_error_free (error);//AP1
				error = NULL;//AP1
			}//AP1

			g_free(self->priv->instanceTitle);
			self->priv->instanceTitle = g_key_file_get_string (keyFile, self->priv->widgetID, "instanceTitle", &error);
			if (error) {
				//no value? what now? assume one "fake" for now
				noInstanceKeysFlag = TRUE;
				self->priv->instanceTitle = NULL;

g_warning("(%p) no title found", self);

				g_error_free (error);
				error = NULL;
			}

			g_free(self->priv->instanceCmd);
			self->priv->instanceCmd = g_key_file_get_string (keyFile, self->priv->widgetID, "instanceCmd", &error);
			if (error) {
				//no value? what now? assume one "fake" for now
				noInstanceKeysFlag = TRUE;
				self->priv->instanceCmd = NULL;

g_warning("(%p) no command found", self);

				g_error_free (error);
				error = NULL;
			}

			//BEGIN update policy
			self->priv->updOnClick = g_key_file_get_boolean (keyFile, self->priv->widgetID, "updOnClick", &error);
			if (error) {

				noInstanceKeysFlag = TRUE;
				self->priv->updOnClick = TRUE;//AP1

g_warning("(%p) no updOnClick on key file, assuming %d", self, self->priv->updOnClick);//AP1
				g_error_free (error);
				error = NULL;
			}

			self->priv->updOnDesktop = g_key_file_get_boolean (keyFile, self->priv->widgetID, "updOnDesktop", &error);
			if (error) {

				noInstanceKeysFlag = TRUE;
				self->priv->updOnDesktop = TRUE;//AP1

g_warning("(%p) no updOnDesktop on key file, assuming %d", self, self->priv->updOnDesktop);//AP1
				g_error_free (error);
				error = NULL;
			}

			self->priv->delayIndex = (guint) g_key_file_get_integer (keyFile, self->priv->widgetID, "delayIndex", &error);
			if (error) {

				noInstanceKeysFlag = TRUE;
				self->priv->delayIndex = 0;//AP1

g_warning("(%p) no delayIndex on key file, assuming %d", self, self->priv->delayIndex);//AP1
				g_error_free (error);
				error = NULL;
			}
			else
				self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);

			self->priv->updNeworkPolicy = (guint) g_key_file_get_integer (keyFile, self->priv->widgetID, "updNeworkPolicy", &error);
			if (error || self->priv->updNeworkPolicy < 0 || self->priv->updNeworkPolicy > 2) {
				//Not important; in order not to break with older key-file versions, just assume NETWORK__UNRELATED and move on..
				self->priv->updNeworkPolicy = NETWORK__UNRELATED;
				noInstanceKeysFlag = TRUE;

g_warning("(%p) NETWORK_UNRELATED, assuming %d", self, self->priv->updNeworkPolicy);//AP1
				g_error_free (error);
				error = NULL;
			}

			//END
		}

		//END
		g_key_file_free (keyFile);
		g_free (filename);
	}
	else
		noSettingsFlag = TRUE;


	if(noInstanceKeysFlag)
	{
		self->priv->updOnClick = TRUE;
		self->priv->updOnDesktop = TRUE;
		self->priv->updNeworkPolicy = NETWORK__UNRELATED;
		self->priv->delayIndex = 0;
		self->priv->delaySeconds = 0;

		self->priv->widWidth = 50.0;
		self->priv->widHeight = 50.0 / SIZE_BEECON_RATIO;//AP3 Ready for beecon
		self->priv->widgetType = 0;//AP3
		self->priv->snippetBgRGB = 0;//AP3
		self->priv->beecon_lt0_BgRGB = 2;
		self->priv->beecon_eq0_BgRGB = 3;
		self->priv->beecon_eq1_BgRGB = 4;
		self->priv->beecon_ge2_BgRGB = 5;


		self->priv->cmdFgRGB = 1;//AP2
		self->priv->cmdVisibilityPosition = 1;//AP2
		self->priv->cmdJustify = 0;//AP2
		self->priv->cmdFontName = 3;//AP1
		self->priv->cmdFontSize = 12;//AP1

		self->priv->resFgRGB = 1;//AP2
		self->priv->resVisibilityPosition = 5;//AP2
		self->priv->resJustify = 0;//AP2
		self->priv->resFontName = 2;//AP1
		self->priv->resFontSize = 12;//AP1

		self->priv->instanceTitle = NULL;
		self->priv->instanceCmd = NULL;
	}

	if(noSettingsFlag)
	{
		self->priv->c_commands = NULL;
		self->priv->c_titles = NULL;
		self->priv->c_size = 0;
	}

	if(noSettingsFlag || noInstanceKeysFlag)
	{
g_warning ("(%p) Problems loading settings. Resetting all", self);
		queen_beecon_write_settings(self, noSettingsFlag, noInstanceKeysFlag, FALSE);
	} else
 g_warning("(%p) Settings file loaded successfully", self);
}

void queen_beecon_write_settings (QueenBeecon *self, gboolean newAll, gboolean newInstance, gboolean removeInstance)
{
g_warning ("(%p) queen_beecon_write_settings",self);
	GKeyFile *keyFile;
	gboolean fileExists;

	gchar *fileData;
	FILE *iniFile;
	gsize size;
	gchar *filename;

	if(self->priv->widgetID == NULL)
	{
g_warning("(%p) Widget instance not initialized, not writing settings..", self);
		return;
	}

	keyFile = g_key_file_new();
g_warning("(%p) keyfile %p", self, keyFile);

	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
g_warning("(%p) fileExists %d", self, fileExists);

	if(newAll)
	{
  g_warning("(%p) records empty, filling with pre-loaded vals", self);
		self->priv->c_size = 13;
		gchar * p_titles[] = { "appOK", "appWRN", "appERR", "sysERR", "Uptime:", "Battery(%):", "Battery(mAh):", "Boot Reason:", "Boot Count:", "External IP:", "Internal IP:", "Rootfs(%):", "Free Rootfs:", NULL};
		gchar * p_commands[] = {
		"echo test && exit 0",
		"echo test && exit 1",
		"echo test && exit 2",
		"all_work_and_no_play_makes_jack_a_dull_boy",
		"uptime|cut -d\" \" -f4-|sed 's/\\, *load.*//'",
		"hal-device bme | awk -F\"[. ]\" '$5 == \"is_charging\" {chrg = $7}; $5 == \"percentage\" {perc = $7} END if (chrg == \"false\") {print perc \"%\"} else {print \"Chrg\"}'",
		"hal-device bme | grep battery.reporting | awk -F. '{print $3}' | sort | awk '$1 == \"current\" { current = $3}; $1== \"design\" {print current \"/\" $3}'",
		"cat /proc/bootreason",
		"cat /var/lib/dsme/boot_count",
		"wget -q -O - api.myiptest.com | awk -F \"\\\"\" '{print $4}'",
		"/sbin/ifconfig | grep \"inet addr\" | awk -F: '{print $2}' | awk '{print $1}'",
		"df | awk '$1 == \"rootfs\" {print $5}'",
		"df -h | awk ' $1 == \"rootfs\" {print $4\"B\"}'",
		NULL};

		//clean possible oldies
		g_strfreev(self->priv->c_titles);
		self->priv->c_titles = NULL;
		g_strfreev(self->priv->c_commands);
		self->priv->c_commands = NULL;
		//assign new from stack values
		self->priv->c_titles = g_strdupv(p_titles);
		self->priv->c_commands = g_strdupv(p_commands);
	}

	if(newInstance)
	{
 g_warning("(%p) newInstance", self);
		g_free(self->priv->instanceTitle);
		g_free(self->priv->instanceCmd);

		if((self->priv->c_titles != NULL)
			&& (self->priv->c_commands != NULL)
			&& (self->priv->c_size > 0))
		{
			self->priv->instanceTitle = g_strdup(self->priv->c_titles[0]);
			self->priv->instanceCmd = g_strdup(self->priv->c_commands[0]);
		}

		self->priv->widgetType = 0;//AP3
		self->priv->snippetBgRGB = 0;//AP3
		self->priv->beecon_lt0_BgRGB = 2;
		self->priv->beecon_eq0_BgRGB = 3;
		self->priv->beecon_eq1_BgRGB = 4;
		self->priv->beecon_ge2_BgRGB = 5;

		self->priv->widWidth = 50.0;
		self->priv->widHeight = 50.0 / SIZE_BEECON_RATIO;//AP3 Ready for beecon

		self->priv->resFgRGB = 1;//AP2
		self->priv->cmdVisibilityPosition = 1;//AP2
		self->priv->cmdJustify = 0;//AP2
		self->priv->cmdFontName = 3;//AP1
		self->priv->cmdFontSize = 12;//AP1

		self->priv->resVisibilityPosition = 5;//AP2
		self->priv->resJustify = 0;//AP2
		self->priv->resFontName = 2;//AP1
		self->priv->resFontSize = 12;//AP1

		self->priv->updOnClick = TRUE;
		self->priv->updOnDesktop = TRUE;
		self->priv->updNeworkPolicy = NETWORK__UNRELATED;
		self->priv->delayIndex = 0;
	}

	g_key_file_set_double (keyFile, "config", "version", QUEEN_BEECON_SETTINGS_VERSION);

	if(self->priv->c_titles != NULL && self->priv->c_commands != NULL)
	{
		g_key_file_set_string_list(keyFile, "config", "c_titles", (const gchar **)(self->priv->c_titles),self->priv->c_size);
		g_key_file_set_string_list(keyFile, "config", "c_commands", (const gchar **)(self->priv->c_commands),self->priv->c_size);
	}

	g_key_file_set_integer (keyFile, self->priv->widgetID, "widgetType", self->priv->widgetType);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "snippetBgRGB", self->priv->snippetBgRGB);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_lt0_BgRGB", self->priv->beecon_lt0_BgRGB);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq0_BgRGB", self->priv->beecon_eq0_BgRGB);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq1_BgRGB", self->priv->beecon_eq1_BgRGB);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_ge2_BgRGB", self->priv->beecon_ge2_BgRGB);//AP3

	g_key_file_set_double (keyFile, self->priv->widgetID, "widWidth", self->priv->widWidth);
	g_key_file_set_double (keyFile, self->priv->widgetID, "widHeight", self->priv->widHeight);

	if(self->priv->instanceTitle != NULL && self->priv->instanceCmd != NULL)
	{
		g_key_file_set_string (keyFile, self->priv->widgetID, "instanceTitle", self->priv->instanceTitle);
		g_key_file_set_string (keyFile, self->priv->widgetID, "instanceCmd", self->priv->instanceCmd);
	}

	g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdFgRGB", self->priv->cmdFgRGB);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdVisibilityPosition", self->priv->cmdVisibilityPosition);//AP2
	g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdJustify", self->priv->cmdJustify);//AP2
	g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdFontName", self->priv->cmdFontName);//AP1
	g_key_file_set_double (keyFile, self->priv->widgetID, "cmdFontSize", self->priv->cmdFontSize);//AP1

	g_key_file_set_integer (keyFile, self->priv->widgetID, "resFgRGB", self->priv->resFgRGB);//AP3
	g_key_file_set_integer (keyFile, self->priv->widgetID, "resVisibilityPosition", self->priv->resVisibilityPosition);//AP2
	g_key_file_set_integer (keyFile, self->priv->widgetID, "resJustify", self->priv->resJustify);//AP2
	g_key_file_set_integer (keyFile, self->priv->widgetID, "resFontName", self->priv->resFontName);//AP1
	g_key_file_set_double (keyFile, self->priv->widgetID, "resFontSize", self->priv->resFontSize);//AP1

	g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnClick", self->priv->updOnClick);
	g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnDesktop", self->priv->updOnDesktop);
	g_key_file_set_integer (keyFile, self->priv->widgetID, "delayIndex", self->priv->delayIndex);
	g_key_file_set_integer (keyFile, self->priv->widgetID, "updNeworkPolicy", self->priv->updNeworkPolicy);

	if (removeInstance)
		g_key_file_remove_group (keyFile, self->priv->widgetID, NULL);



	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
g_warning("(%p) filename %s", self, filename);

	fileData = g_key_file_to_data (keyFile, &size, NULL);
g_warning("(%p) fileData %p", self, fileData);

	iniFile = fopen (filename, "w");
	fputs (fileData, iniFile);
	fclose (iniFile);
	g_key_file_free (keyFile);
	g_free (fileData);
	g_free (filename);

	if(newAll || newInstance)
	{
		g_strfreev(self->priv->c_titles);
		self->priv->c_titles = NULL;
		g_strfreev(self->priv->c_commands);
		self->priv->c_commands = NULL;

		g_free(self->priv->instanceTitle);
		self->priv->instanceTitle = NULL;
		g_free(self->priv->instanceCmd);
		self->priv->instanceCmd = NULL;
		queen_beecon_read_settings(self);
	}
}



//widget/touchscreen interaction callbacks
void queen_beecon_button_press (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_button_press",self);
	if (self->priv->updOnClick) {
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

void queen_beecon_button_release (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_button_release",self);
	if (self->priv->updOnClick) {
		self->priv->isPressed = FALSE;
		queen_beecon_update_content(self);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

void queen_beecon_leave_event (GtkWidget *widget, GdkEventCrossing *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_leave_event",self);
	if (self->priv->updOnClick) {
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

static void queen_beecon_check_desktop (GObject *gobject, GParamSpec *pspec, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_check_desktop",self);
	if (self->priv->updOnDesktop) {
		queen_beecon_update_content(self);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}


gboolean queen_beecon_connection_event (ConIcConnection *connection, ConIcConnectionEvent *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_connection_event",self);
	ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
	if(status == CON_IC_STATUS_CONNECTED)
	{
		self->priv->isConnected = TRUE;
	}
	else
	{
		self->priv->isConnected = FALSE;
	}
	queen_beecon_update_content(self);
	return TRUE;
}


//Content/widget creation/update
void queen_beecon_content_create (QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_content_create",self);
	GdkColor color;
	self->priv->contents = gtk_event_box_new ();
	gtk_event_box_set_visible_window (GTK_EVENT_BOX (self->priv->contents), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->contents), 0);

	self->priv->tableLayout = gtk_table_new(1, 1, FALSE);

	self->priv->cmdTitle_lb = gtk_label_new ("title:");
	self->priv->cmdResult_lb = gtk_label_new ("result");

	gtk_widget_set_size_request(self->priv->cmdTitle_lb, self->priv->widWidth, self->priv->widHeight);
	gtk_widget_set_size_request(self->priv->cmdResult_lb, self->priv->widWidth, self->priv->widHeight);

	gdk_color_parse(p_colors[self->priv->cmdFgRGB].colorRGB,&color);
	gtk_widget_modify_fg (self->priv->cmdTitle_lb, GTK_STATE_NORMAL, &color);

	gdk_color_parse(p_colors[self->priv->resFgRGB].colorRGB,&color);
	gtk_widget_modify_fg (self->priv->cmdResult_lb, GTK_STATE_NORMAL, &color);

g_warning ("(%p) Absolute Alignment cX=%d cY=%d rX=%d rY=%d", self,self->priv->cmdVisibilityPosition,self->priv->cmdVisibilityPosition,self->priv->resVisibilityPosition,self->priv->resVisibilityPosition);
g_warning ("(%p) Relative Alignment cX=%f cY=%f rX=%f rY=%f", self,((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5,((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);

	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_lb),((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);

	gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 2, 2);//AP1
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdResult_lb), 2, 2);//AP1

	gtk_label_set_justify(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdJustify);
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resJustify);

	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_lb, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdResult_lb, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	GtkWidget *box = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), self->priv->tableLayout, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self->priv->contents), box);

	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->contents, FALSE, FALSE, 0);

	//widget drawing signal connections
	g_signal_connect (self->priv->contents, "button-release-event", G_CALLBACK (queen_beecon_button_release), self);
	g_signal_connect (self->priv->contents, "button-press-event", G_CALLBACK (queen_beecon_button_press), self);
	g_signal_connect (self->priv->contents, "leave-notify-event", G_CALLBACK (queen_beecon_leave_event), self);

	gtk_widget_show_all (self->priv->homeWidget);
	gtk_widget_show (self->priv->cmdTitle_lb);
	gtk_widget_show (self->priv->cmdResult_lb);
}


gboolean queen_beecon_resize_hack(QueenBeecon *self)
{
g_warning("(%p) queen_beecon_resize_hack",self);
	if(self->priv->widgetID != NULL) {
		queen_beecon_read_settings (self);

		queen_beecon_content_create (self);

		queen_beecon_update_content (self);

		gtk_widget_set_size_request (GTK_WIDGET (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP3
		gtk_window_resize (GTK_WINDOW (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP3
		gtk_widget_set_size_request(self->priv->cmdTitle_lb, self->priv->widWidth, self->priv->widHeight);
		gtk_widget_set_size_request(self->priv->cmdResult_lb, self->priv->widWidth, self->priv->widHeight);

	} else {
 g_warning("HACK unsuccessful");
 	}

	return FALSE;
}

static void queen_beecon_dispose (GObject *object)
{
g_warning ("(%p) queen_beecon_dispose",object);

	G_OBJECT_CLASS (queen_beecon_parent_class)->dispose (object);
}

static void queen_beecon_finalize (GObject *object)
{
g_warning ("(%p) queen_beecon_finalize",object);
	QueenBeecon *self = QUEEN_BEECON (object);

//g_warning ("(%p) removing settings group for [%s] instance", object, self->priv->widgetID);
//	queen_beecon_write_settings (self, FALSE, FALSE, TRUE); //Remove Instance data from settings file

	if (self->priv->updateTimerID) {
		g_source_remove (self->priv->updateTimerID);
	}

	g_object_unref (self->priv->connection);

	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;

	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;


	g_free(self->priv->instanceTitle);
	self->priv->instanceTitle = NULL;
	g_free(self->priv->instanceCmd);
	self->priv->instanceCmd = NULL;

	G_OBJECT_CLASS (queen_beecon_parent_class)->finalize (object);
}

static void queen_beecon_realize (GtkWidget *widget)
{
g_warning ("(%p) queen_beecon_realize",widget);
	GdkScreen *screen;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (queen_beecon_parent_class)->realize (widget);

	QueenBeecon *self = QUEEN_BEECON (widget);
	self->priv->widgetID = hd_home_plugin_item_get_applet_id (HD_HOME_PLUGIN_ITEM (widget));
}

static gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
g_warning ("(%p) queen_beecon_expose_event event=%p", widget, event);
	QueenBeecon *self = QUEEN_BEECON (widget);

	GdkColor color;
	cairo_t *cr;

	cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));
g_warning ("(%p,%p) Populating canvas...", widget, event);

	if (self->priv->widgetType!=0) {//AP3
		gdk_color_parse(p_colors[self->priv->snippetBgRGB].colorRGB,&color);
		if (!self->priv->isPressed) {
			cairo_set_source_rgba (cr, color.red, color.green, color.blue, 0.75);
		} else {
			cairo_set_source_rgba (cr, color.red, color.green, color.blue, 0.6);
		}
	} else {//AP3
		switch (self->priv->cmdExitStatus) {
		case -1:
			gdk_color_parse(p_colors[self->priv->beecon_lt0_BgRGB].colorRGB, &color);
			break;
		case 0:
			gdk_color_parse(p_colors[self->priv->beecon_eq0_BgRGB].colorRGB, &color);
			break;
		case 1:
			gdk_color_parse(p_colors[self->priv->beecon_eq1_BgRGB].colorRGB, &color);
			break;
		default:
			gdk_color_parse(p_colors[self->priv->beecon_ge2_BgRGB].colorRGB, &color);
		}
		if (!self->priv->isPressed) {
			cairo_set_source_rgba (cr, color.red, color.green, color.blue, 0.85);
		} else {
			cairo_set_source_rgba (cr, color.red, color.green, color.blue, 0.65);
		}
	}//AP3

 	gint width, height, x, y;
	gint radius = 5;

	width = widget->allocation.width;
	height = widget->allocation.height;
	x = widget->allocation.x;
	y = widget->allocation.y;

	if (self->priv->widgetType!=0) {//AP3
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
	} else {//AP3
		cairo_set_line_join(cr, CAIRO_LINE_JOIN_ROUND);//AP3
		gint l= width / 4;//AP3
		gint h= height / 2;//AP3


		cairo_move_to(cr, x, y + h - 1);
		cairo_line_to(cr, x + l - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 3 - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 4 - 1, y + h - 1);
		cairo_line_to(cr, x + l * 3 - 1 , y);
		cairo_line_to(cr, x + l - 1 , y);
		cairo_line_to(cr, x, y + h - 1);
	}//AP3

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_fill_preserve(cr);

	// Set drawing color same as cmdLabel foreground color
	gdk_color_parse(p_colors[self->priv->cmdFgRGB].colorRGB,&color);
	cairo_set_source_rgba (cr, color.red, color.green, color.blue, 1);

	cairo_set_line_width (cr, 1);
	cairo_stroke (cr);

	cairo_destroy(cr);

	return GTK_WIDGET_CLASS (queen_beecon_parent_class)->expose_event (widget, event);
}

static void queen_beecon_class_init (QueenBeeconClass *klass)
{
g_warning ("(%p) queen_beecon_class_init",klass);
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->dispose = queen_beecon_dispose;
	object_class->finalize = queen_beecon_finalize;

	widget_class->realize = queen_beecon_realize;
	widget_class->expose_event = queen_beecon_expose_event;

	g_type_class_add_private (klass, sizeof (QueenBeeconPrivate));
}

static void queen_beecon_class_finalize (QueenBeeconClass *klass G_GNUC_UNUSED)
{
g_warning ("(%p) queen_beecon_class_finalize",klass);
}

static void queen_beecon_init (QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_init",self);
	self->priv = QUEEN_BEECON_GET_PRIVATE (self);
	self->priv->cmdExitStatus = -1;
	self->priv->updateTimerID = 0;
	self->priv->isPressed = FALSE;

	self->priv->widgetID = NULL;

	self->priv->connection = con_ic_connection_new ();
	g_signal_connect (self->priv->connection, "connection-event", G_CALLBACK (queen_beecon_connection_event), self);
	g_object_set (self->priv->connection, "automatic-connection-events", TRUE);
	self->priv->isConnected = FALSE;

	self->priv->cmdResult_lb = NULL;

	hd_home_plugin_item_set_settings (&self->parent, TRUE);
	g_signal_connect (&self->parent, "show-settings", G_CALLBACK (queen_beecon_settings), self);

	gtk_window_set_default_size (GTK_WINDOW (self), 5.0, 5.0 / SIZE_BEECON_RATIO);

	self->priv->homeWidget = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);
	gtk_widget_show (self->priv->homeWidget);

	gtk_window_get_position (GTK_WINDOW (self), &self->priv->widXOrigin, &self->priv->widYOrigin);
g_warning ("(%p) Window Position Init x=%d y=%d",self, self->priv->widXOrigin, self->priv->widYOrigin);

	GdkGeometry hints;

	hints.min_width = (int)(50);//AP3
	hints.min_height = (int)(50 / SIZE_BEECON_RATIO);//AP3
	hints.max_width = (int)(SIZE_WIDTH_ALL);//AP3
	hints.max_height = (int)(SIZE_HEIGHT_ALL);//AP3

	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);

	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(50), (int)(50 / SIZE_BEECON_RATIO));//AP3
	gtk_window_resize (GTK_WINDOW (self), (int)(100), (int)(100 / SIZE_BEECON_RATIO));//AP3

	g_timeout_add (500, (GSourceFunc)queen_beecon_resize_hack, self);

//	queen_beecon_content_create (self);//AP!!!!!!!!!

	g_signal_connect (self, "notify::is-on-current-desktop", G_CALLBACK (queen_beecon_check_desktop), self);
}

QueenBeecon* queen_beecon_new (void)
{
g_warning ("queen_beecon_new");
	return g_object_new (QUEEN_BEECON_TYPE, NULL);
}

gboolean queen_beecon_update_content (QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_update_content",self);
	GdkColor color;

	if(self->priv->widgetID == NULL)
	{
g_warning("(%p) Widget instance unknown... aborting",self);
		return(FALSE);
	}

    //Font Mod//AP1v
	gchar cmdTtl[256];//AP1
	gchar resTtl[256];//AP1

	PangoFontDescription *fd;//AP1
	g_sprintf(cmdTtl,"%s %s %ld", p_fonts[self->priv->cmdFontName/4], p_fonts_types[self->priv->cmdFontName%4], (long) self->priv->cmdFontSize);//AP1
	fd = pango_font_description_from_string(cmdTtl);//AP1
	gtk_widget_modify_font(self->priv->cmdTitle_lb, fd);//AP1
g_warning("(%p) Title Font: %s",self, cmdTtl);

	g_sprintf(resTtl,"%s %s %ld", p_fonts[self->priv->resFontName/4], p_fonts_types[self->priv->resFontName%4], (long) self->priv->resFontSize);//AP1
	fd = pango_font_description_from_string(resTtl);//AP1
	gtk_widget_modify_font(self->priv->cmdResult_lb, fd);//AP1
g_warning("(%p) Result Font: %s",self, resTtl);
	//Font Mod//AP1^

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_CONNECTED && self->priv->isConnected == FALSE)
		return TRUE;

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_DISCONNECTED && self->priv->isConnected == TRUE)
		return FALSE;


	FILE *fp;
	gchar line[4096]="";//AP Big Big command output buffer//AP
	size_t l;//AP

	gboolean found = FALSE;

	if(self->priv->instanceCmd == NULL || self->priv->instanceTitle == NULL)
	{
		gtk_label_set_text (GTK_LABEL (self->priv->cmdTitle_lb), "Error:");
		gtk_label_set_text (GTK_LABEL (self->priv->cmdResult_lb), "No commands");
		return 0;
	}

	if (self->priv->cmdVisibilityPosition==0)//AP2
		gtk_widget_hide (self->priv->cmdTitle_lb);//AP3
	else
		gtk_widget_show (self->priv->cmdTitle_lb);//AP3
	if (self->priv->resVisibilityPosition==0)//AP2
		gtk_widget_hide (self->priv->cmdResult_lb);//AP3
	else
		gtk_widget_show (self->priv->cmdResult_lb);//AP3

g_warning ("(%p) Absolute Alignment cX=%d cY=%d rX=%d rY=%d", self,	self->priv->cmdVisibilityPosition, self->priv->cmdVisibilityPosition, self->priv->resVisibilityPosition, self->priv->resVisibilityPosition);
g_warning ("(%p) Relative Alignment cX=%f cY=%f rX=%f rY=%f", self,	((self->priv->cmdVisibilityPosition-1)%3)*0.5, ((self->priv->cmdVisibilityPosition-1)/3)*0.5, ((self->priv->resVisibilityPosition-1)%3)*0.5, ((self->priv->resVisibilityPosition-1)/3)*0.5);
g_warning ("(%p) Justification cmd=%d res=%d",self, self->priv->cmdJustify, self->priv->resJustify);

	gdk_color_parse(p_colors[self->priv->cmdFgRGB].colorRGB,&color);
	gtk_widget_modify_fg (self->priv->cmdTitle_lb, GTK_STATE_NORMAL, &color);

	gdk_color_parse(p_colors[self->priv->resFgRGB].colorRGB,&color);
	gtk_widget_modify_fg (self->priv->cmdResult_lb, GTK_STATE_NORMAL, &color);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_lb),((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdJustify);
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resJustify);

	gtk_label_set_text (GTK_LABEL (self->priv->cmdTitle_lb), self->priv->instanceTitle);

	fp = popen (self->priv->instanceCmd, "r");
g_warning("(%p) popen(%s) returned 0x%08X", self, self->priv->instanceCmd, (guint)fp);//AP >> 8 & 0xFF);//AP

	if ((l=fread (line, 1, sizeof line, fp))!=0) {//to this "buffer-based" for multiline handling in widget //AP
		line[l-1]='\000';//AP
		found = TRUE;
	}

	gint exitCode=pclose(fp);
g_warning("(%p) ppclose(fp) returned 0x%08X", self, exitCode);

	if ((self->priv->cmdExitStatus=(exitCode >> 8 & 0xff)) > 0x70) {
		self->priv->cmdExitStatus=-1;
		g_sprintf(line,"!?%08x",exitCode);
	}

	gtk_label_set_text (GTK_LABEL (self->priv->cmdResult_lb), line);//AP

	queen_beecon_expose_event(GTK_WIDGET (self), NULL);

	if( (self->priv->updateTimerID == 0) && (self->priv->delaySeconds > 0))
	{
g_warning("(%p) re-arming timer, delaySeconds=%d", self, self->priv->delaySeconds);
		self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
	}

	return found;
}

//Separate window dialogs
void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self)
{
g_warning ("queen_beecon_settings(%p)",self);

	int settingsRunning = 1;
	int i;
	gtk_window_get_position (GTK_WINDOW (self), &self->priv->widXOrigin, &self->priv->widYOrigin);
g_warning ("(%p) Window Position Current x=%d y=%d",self, self->priv->widXOrigin, self->priv->widYOrigin);

	while(settingsRunning)
	{
		GtkWidget *dialog = gtk_dialog_new_with_buttons ("Queen BeeCon Widget Settings", NULL, 0,
																										 _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT,
																										 "Add Cmd", NON_GTK_RESPONSE_ADD_CMD,
																										 "Edit Cmd", NON_GTK_RESPONSE_EDIT_CMD,
//																										 "Widget<small>Send to Back</small>", NON_GTK_RESPONSE_SEND_TO_BACK,
																										 NULL);

		GtkWidget *settingsArea = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
		GtkWidget *scroll = hildon_pannable_area_new ();
		g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);

		GtkWidget *content_area = gtk_vbox_new (FALSE, 0);
		hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (scroll), content_area);
		gtk_container_add (GTK_CONTAINER (settingsArea), scroll);
		gtk_window_set_default_size (GTK_WINDOW (dialog), -1, 380);

		queen_beecon_read_settings(self);

		GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

		//BEGIN Command Selector

		GtkWidget *selector = hildon_touch_selector_new_text ();
		for(i=0;i<self->priv->c_size;i++)
		{
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), self->priv->c_titles[i]);
			if(g_strcmp0(self->priv->c_titles[i],self->priv->instanceTitle) == 0)
				if(g_strcmp0(self->priv->c_commands[i],self->priv->instanceCmd) == 0)
					hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, i);
		}

		GtkWidget *cmdSelectionLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (cmdSelectionLabel), "<small>Command Selection:</small>");
		gtk_container_add (GTK_CONTAINER (content_area), cmdSelectionLabel);

		GtkWidget * cmdSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		hildon_button_set_title (HILDON_BUTTON (cmdSelector), "Commands: ");
		hildon_button_add_title_size_group (HILDON_BUTTON (cmdSelector), group);
		hildon_button_set_alignment (HILDON_BUTTON (cmdSelector), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdSelector), HILDON_TOUCH_SELECTOR (selector));
		gtk_container_add (GTK_CONTAINER (content_area), cmdSelector);
		//END

		GtkWidget *widgetTypeLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (widgetTypeLabel), "<small>Widget Type</small>");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), widgetTypeLabel);//AP1

		GtkWidget * widgetType = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (widgetType), "Beecon");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (widgetType), "Snippet");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (widgetType), 0, self->priv->widgetType);//AP1

		GtkWidget * widgetTypeSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (widgetTypeSelector), "Type: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (widgetTypeSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (widgetTypeSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (widgetTypeSelector), HILDON_TOUCH_SELECTOR (widgetType));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), widgetTypeSelector);//AP1

		GtkWidget *widHelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (widHelpLabel), "<small><b><u>Beecons</u></b> are small hexagonal cells whose background color changes according to command exit status.\n<b><u>Snippets</u></b> are normal text boxes with fixed background color which is not influenced by the command exit status</small>\n");
		gtk_misc_set_alignment (GTK_MISC (widHelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (widHelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), widHelpLabel);

		GtkWidget *widgetBgLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (widgetBgLabel), "<small>Widget Background Colors:</small>");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), widgetBgLabel);//AP1

		GtkWidget *snippetBgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (snippetBgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (snippetBgRGB), 0, self->priv->snippetBgRGB);//AP1

		GtkWidget * snippetBgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (snippetBgRGBSelector), "Snippet:");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (snippetBgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (snippetBgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (snippetBgRGBSelector), HILDON_TOUCH_SELECTOR (snippetBgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), snippetBgRGBSelector);//AP1

		GtkWidget *snipHelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (snipHelpLabel), "<small><b><u>Not affected</u></b> by Command Exit Status)</small>\n");
		gtk_misc_set_alignment (GTK_MISC (snipHelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (snipHelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), snipHelpLabel);

		GtkWidget *beecon_lt0_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB), 0, self->priv->beecon_lt0_BgRGB);//AP1

		GtkWidget * beecon_lt0_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_lt0_BgRGBSelector), "Beecon Status  <0");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (beecon_lt0_BgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_lt0_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_lt0_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), beecon_lt0_BgRGBSelector);//AP1

		GtkWidget *bee_lt0_HelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (bee_lt0_HelpLabel), "<small>When Command Exit Status <b><u>&lt;0</u></b></small>\n");
		gtk_misc_set_alignment (GTK_MISC (bee_lt0_HelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (bee_lt0_HelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), bee_lt0_HelpLabel);

		GtkWidget *beecon_eq0_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB), 0, self->priv->beecon_eq0_BgRGB);//AP1

		GtkWidget * beecon_eq0_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_eq0_BgRGBSelector), "Beecon Status  =0");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (beecon_eq0_BgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_eq0_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_eq0_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), beecon_eq0_BgRGBSelector);//AP1

		GtkWidget *bee_eq0_HelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (bee_eq0_HelpLabel), "<small>When Command Exit Status <b><u>=0</u></b></small>\n");
		gtk_misc_set_alignment (GTK_MISC (bee_eq0_HelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (bee_eq0_HelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), bee_eq0_HelpLabel);

		GtkWidget *beecon_eq1_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB), 0, self->priv->beecon_eq1_BgRGB);//AP1

		GtkWidget * beecon_eq1_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_eq1_BgRGBSelector), "Beecon Status  =1");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (beecon_eq1_BgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_eq1_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_eq1_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), beecon_eq1_BgRGBSelector);//AP1

		GtkWidget *bee_eq1_HelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (bee_eq1_HelpLabel), "<small>When Command Exit Status <b><u>=1</u></b></small>\n");
		gtk_misc_set_alignment (GTK_MISC (bee_eq1_HelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (bee_eq1_HelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), bee_eq1_HelpLabel);

		GtkWidget *beecon_ge2_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB), 0, self->priv->beecon_ge2_BgRGB);//AP1

		GtkWidget * beecon_ge2_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_ge2_BgRGBSelector), "Beecon Status >=2");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (beecon_ge2_BgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_ge2_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_ge2_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), beecon_ge2_BgRGBSelector);//AP1

		GtkWidget *bee_ge2_HelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (bee_ge2_HelpLabel), "<small>When Command Exit Status <b><u>&gt;=2</u></b></small>\n");
		gtk_misc_set_alignment (GTK_MISC (bee_ge2_HelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (bee_ge2_HelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), bee_ge2_HelpLabel);

		//BEGIN
		//layout opts

		GtkWidget *widgetSizeLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (widgetSizeLabel), "<small>Widget Size &amp; Position Tuning:</small>");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), widgetSizeLabel);//AP1

		GtkWidget *widPositionBox = gtk_hbox_new (FALSE, 0);//AP1

		GtkWidget *widPositionLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (widPositionLabel), "Fine Tune (X,Y):\n<small>(0,0) is Top-Left</small>");
		gtk_misc_set_alignment (GTK_MISC (widPositionLabel), 0, 0.5);//AP1
		gtk_misc_set_padding (GTK_MISC (widPositionLabel), HILDON_MARGIN_DOUBLE, 0);//AP1
		gtk_size_group_add_widget (group, widPositionLabel);//AP1

		GtkWidget *widPositionX = gtk_hscale_new_with_range ((gdouble)self->priv->widXOrigin-5, (gdouble)self->priv->widXOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(widPositionX), self->priv->widXOrigin);//AP1

		GtkWidget *widPositionY = gtk_hscale_new_with_range ((gdouble)self->priv->widYOrigin-5, (gdouble)self->priv->widYOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(widPositionY), self->priv->widYOrigin);//AP1

g_warning ("(%p) Window Position New x=%d y=%d",self, self->priv->widXOrigin, self->priv->widYOrigin);

		gtk_box_pack_start (GTK_BOX (widPositionBox), widPositionLabel, FALSE, FALSE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (widPositionBox), widPositionX, TRUE, TRUE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (widPositionBox), widPositionY, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), widPositionBox);//AP1

		GtkWidget *widthBox = gtk_hbox_new (FALSE, 0);

		GtkWidget *widthLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (widthLabel), "Width:\n<small>Pixels [10-800]</small>");
		gtk_misc_set_alignment (GTK_MISC (widthLabel), 0, 0.5);
		gtk_misc_set_padding (GTK_MISC (widthLabel), HILDON_MARGIN_DOUBLE, 0);
		gtk_size_group_add_widget (group, widthLabel);

		GtkWidget * widthSelect = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_WIDTH_ALL, (gdouble)5.0);
		gtk_range_set_value(GTK_RANGE(widthSelect), self->priv->widWidth);

		gtk_box_pack_start (GTK_BOX (widthBox), widthLabel, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (widthBox), widthSelect, TRUE, TRUE, 0);

		gtk_container_add (GTK_CONTAINER (content_area), widthBox);

		//layout opts heightBox //AP
		GtkWidget *heightBox = gtk_hbox_new (FALSE, 0);//AP

		GtkWidget *heightLabel = gtk_label_new ("");//AP

		gtk_label_set_markup (GTK_LABEL (heightLabel), "Height:\n<small>Pixels [10-400]</small>");

		gtk_misc_set_alignment (GTK_MISC (heightLabel), 0, 0.5);//AP
		gtk_misc_set_padding (GTK_MISC (heightLabel), HILDON_MARGIN_DOUBLE, 0);//AP
		gtk_size_group_add_widget (group, heightLabel);//AP

		GtkWidget * heightSelect = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_HEIGHT_ALL, (gdouble)5.0);//AP
		gtk_range_set_value(GTK_RANGE(heightSelect), self->priv->widHeight);//AP
		gtk_box_pack_start (GTK_BOX (heightBox), heightLabel, FALSE, FALSE, 0);//AP
		gtk_box_pack_start (GTK_BOX (heightBox), heightSelect, TRUE, TRUE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), heightBox);//AP

		GtkWidget *LayoutCmdLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (LayoutCmdLabel), "<small>Command Label Settings:</small>");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), LayoutCmdLabel);//AP1

		GtkWidget *cmdFgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdFgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdFgRGB), 0, self->priv->cmdFgRGB);//AP1

		GtkWidget * cmdFgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdFgRGBSelector), "Color: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (cmdFgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdFgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdFgRGBSelector), HILDON_TOUCH_SELECTOR (cmdFgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), cmdFgRGBSelector);//AP1

		GtkWidget *cmdVisibilityPosition = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdVisibilityPosition), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdVisibilityPosition), 0, self->priv->cmdVisibilityPosition);//AP1

		GtkWidget * cmdVisibilityPositionSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdVisibilityPositionSelector), "Visibility & Position: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (cmdVisibilityPositionSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdVisibilityPositionSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdVisibilityPositionSelector), HILDON_TOUCH_SELECTOR (cmdVisibilityPosition));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), cmdVisibilityPositionSelector);//AP1

		GtkWidget *cmdJustify = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdJustify), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdJustify), 0, self->priv->cmdJustify);//AP1

		GtkWidget * cmdJustifySelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdJustifySelector), "Justification: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (cmdJustifySelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdJustifySelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdJustifySelector), HILDON_TOUCH_SELECTOR (cmdJustify));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), cmdJustifySelector);//AP1

		GtkWidget *cmdFontFam = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_fonts[i]!=NULL;i++) {//AP1
			int j;
			for (j=0;j<4;j++) {//AP1
				gchar fs[256];//AP1
				g_sprintf(fs, "%s %s",p_fonts[i], p_fonts_types[j]);//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdFontFam), fs);//AP1
			}//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdFontFam), 0, self->priv->cmdFontName);//AP1

		GtkWidget * cmdFontSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdFontSelector), "Font Face: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (cmdFontSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdFontSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdFontSelector), HILDON_TOUCH_SELECTOR (cmdFontFam));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), cmdFontSelector);//AP1

		GtkWidget *cmdFontBox = gtk_hbox_new (FALSE, 0);//AP1
		GtkWidget *cmdFontSzLabel = gtk_label_new ("Font Size:");//AP1
		gtk_misc_set_alignment (GTK_MISC (cmdFontSzLabel), 0, 0.5);//AP1
		gtk_misc_set_padding (GTK_MISC (cmdFontSzLabel), HILDON_MARGIN_DOUBLE, 0);//AP1
		gtk_size_group_add_widget (group, cmdFontSzLabel);//AP1
		GtkWidget *cmdFontSz = gtk_hscale_new_with_range ((gdouble)8, (gdouble)48, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(cmdFontSz), self->priv->cmdFontSize);//AP1
		gtk_box_pack_start (GTK_BOX (cmdFontBox), cmdFontSzLabel, FALSE, FALSE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (cmdFontBox), cmdFontSz, TRUE, TRUE, 0);//AP1
		gtk_container_add (GTK_CONTAINER (content_area), cmdFontBox);//AP1

		GtkWidget *LayoutResLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (LayoutResLabel), "<small>Results Text Settings:</small>");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), LayoutResLabel);//AP1

		GtkWidget *resFgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resFgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resFgRGB), 0, self->priv->resFgRGB);//AP1

		GtkWidget * resFgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resFgRGBSelector), "Color: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (resFgRGBSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resFgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resFgRGBSelector), HILDON_TOUCH_SELECTOR (resFgRGB));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), resFgRGBSelector);//AP1

		GtkWidget *resVisibilityPosition = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resVisibilityPosition), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resVisibilityPosition), 0, self->priv->resVisibilityPosition);//AP1

		GtkWidget * resVisibilityPositionSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resVisibilityPositionSelector), "Visibility & Position: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (resVisibilityPositionSelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resVisibilityPositionSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resVisibilityPositionSelector), HILDON_TOUCH_SELECTOR (resVisibilityPosition));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), resVisibilityPositionSelector);//AP1

		GtkWidget *resJustify = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resJustify), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resJustify), 0, self->priv->resJustify);//AP1

		GtkWidget * resJustifySelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resJustifySelector), "Justification: ");//AP1
		hildon_button_add_title_size_group (HILDON_BUTTON (resJustifySelector), group);//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resJustifySelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resJustifySelector), HILDON_TOUCH_SELECTOR (resJustify));//AP1
		gtk_container_add (GTK_CONTAINER (content_area), resJustifySelector);//AP1

		GtkWidget *resFontFam = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_fonts[i]!=NULL;i++) {//AP1
			int j;
			for (j=0;j<4;j++) {//AP1
				gchar fs[256];//AP1
				g_sprintf(fs, "%s %s",p_fonts[i], p_fonts_types[j]);//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resFontFam), fs);//AP1
			}//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resFontFam), 0, self->priv->resFontName);//AP1

		GtkWidget * resFontSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		hildon_button_set_title (HILDON_BUTTON (resFontSelector), "Font Face: ");
		hildon_button_add_title_size_group (HILDON_BUTTON (resFontSelector), group);
		hildon_button_set_alignment (HILDON_BUTTON (resFontSelector), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resFontSelector), HILDON_TOUCH_SELECTOR (resFontFam));
		gtk_container_add (GTK_CONTAINER (content_area), resFontSelector);

		GtkWidget *resFontBox = gtk_hbox_new (FALSE, 0);//AP1
		GtkWidget *resFontSzLabel = gtk_label_new ("Font Size:");//AP1
		gtk_misc_set_alignment (GTK_MISC (resFontSzLabel), 0, 0.5);//AP1
		gtk_misc_set_padding (GTK_MISC (resFontSzLabel), HILDON_MARGIN_DOUBLE, 0);//AP1
		gtk_size_group_add_widget (group, resFontSzLabel);//AP1
		GtkWidget *resFontSz = gtk_hscale_new_with_range ((gdouble)8, (gdouble)48, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(resFontSz), self->priv->resFontSize);//AP1
		gtk_box_pack_start (GTK_BOX (resFontBox), resFontSzLabel, FALSE, FALSE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (resFontBox), resFontSz, TRUE, TRUE, 0);//AP1
		gtk_container_add (GTK_CONTAINER (content_area), resFontBox);//AP1
		//END

		//BEGIN Update Policy
		GtkWidget *updPolicyLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (updPolicyLabel), "<small>Update Policy:</small>");
		gtk_container_add (GTK_CONTAINER (content_area), updPolicyLabel);

		GtkWidget *checkBtClick = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (checkBtClick), "Update when clicked");
		gtk_container_add (GTK_CONTAINER (content_area), checkBtClick);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (checkBtClick), self->priv->updOnClick);

		GtkWidget *checkBtDesktop = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (checkBtDesktop), "Update when switched to the desktop");
		gtk_container_add (GTK_CONTAINER (content_area), checkBtDesktop);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (checkBtDesktop), self->priv->updOnDesktop);

		GtkWidget *intervalSelector = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "0");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "30 Seconds");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "1 Minute");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "5 Minutes");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "30 Minutes");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "1 Hour");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "6 Hours");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "12 Hours");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "Daily");

		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (intervalSelector), 0, self->priv->delayIndex);

		GtkWidget * intervalSelBt = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		hildon_button_set_title (HILDON_BUTTON (intervalSelBt), "Update Interval: ");
		hildon_button_add_title_size_group (HILDON_BUTTON (intervalSelBt), group);
		hildon_button_set_alignment (HILDON_BUTTON (intervalSelBt), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (intervalSelBt), HILDON_TOUCH_SELECTOR (intervalSelector));
		gtk_container_add (GTK_CONTAINER (content_area), intervalSelBt);


		GtkWidget *updIntervalLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (updIntervalLabel), "<small>'0' disables periodic updating</small>");
		gtk_container_add (GTK_CONTAINER (content_area), updIntervalLabel);


		GtkWidget *networkPolicySel = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (networkPolicySel), "Doesn't Matter");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (networkPolicySel), "Only when connected");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (networkPolicySel), "Only when disconnected");
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (networkPolicySel), 0, self->priv->updNeworkPolicy);

		GtkWidget * networkPolBt = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		hildon_button_set_title (HILDON_BUTTON (networkPolBt), "Network Presence: ");
		hildon_button_add_title_size_group (HILDON_BUTTON (networkPolBt), group);
		hildon_button_set_alignment (HILDON_BUTTON (networkPolBt), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (networkPolBt), HILDON_TOUCH_SELECTOR (networkPolicySel));
		gtk_container_add (GTK_CONTAINER (content_area), networkPolBt);
		//END

		gtk_widget_show_all (dialog);

		//BEGIN result processing

		int setDialogReturn = 0;

		setDialogReturn = gtk_dialog_run (GTK_DIALOG (dialog));
	    g_warning ("(%p) setDialogReturn() = %d",self, setDialogReturn);
		if (setDialogReturn == GTK_RESPONSE_ACCEPT)
		{
			int cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0);
			if(cmdSel < self->priv->c_size && cmdSel >= 0)
			{
				self->priv->instanceTitle = g_strdup(self->priv->c_titles[cmdSel]);
				self->priv->instanceCmd = g_strdup(self->priv->c_commands[cmdSel]);
			}

			self->priv->widgetType = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (widgetType), 0);//AP2
			self->priv->snippetBgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (snippetBgRGB), 0);//AP2
			self->priv->beecon_lt0_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB), 0);//AP2
			self->priv->beecon_eq0_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB), 0);//AP2
			self->priv->beecon_eq1_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB), 0);//AP2
			self->priv->beecon_ge2_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB), 0);//AP2

			self->priv->widXOrigin = gtk_range_get_value(GTK_RANGE(widPositionX));
			self->priv->widYOrigin = gtk_range_get_value(GTK_RANGE(widPositionY));
g_warning ("(%p) Moving Window Position x=%d y=%d",self, self->priv->widXOrigin, self->priv->widYOrigin);
			gtk_window_move (GTK_WINDOW (self), (int)(self->priv->widXOrigin), (int)(self->priv->widYOrigin));//AP

			self->priv->widWidth = gtk_range_get_value(GTK_RANGE(widthSelect));
			if (self->priv->widgetType!=0)//AP3
				self->priv->widHeight = gtk_range_get_value(GTK_RANGE(heightSelect));
			else//AP3
				self->priv->widHeight = self->priv->widWidth / SIZE_BEECON_RATIO;//Keep height aspect ration for beecon//AP3

			gtk_widget_set_size_request (GTK_WIDGET (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP
			gtk_window_resize (GTK_WINDOW (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP
			gtk_widget_set_size_request(self->priv->cmdTitle_lb, self->priv->widWidth, self->priv->widHeight);
			gtk_widget_set_size_request(self->priv->cmdResult_lb, self->priv->widWidth, self->priv->widHeight);

			self->priv->cmdFgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdFgRGB), 0);//AP2
			self->priv->cmdVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdVisibilityPosition), 0);//AP2
			self->priv->cmdJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdJustify), 0);//AP2

			self->priv->cmdFontName = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdFontFam), 0);//AP1
			self->priv->cmdFontSize = gtk_range_get_value(GTK_RANGE(cmdFontSz));//AP1

			self->priv->resFgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resFgRGB), 0);//AP2
			self->priv->resVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resVisibilityPosition), 0);//AP2
			self->priv->resJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resJustify), 0);//AP2

			self->priv->resFontName = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resFontFam), 0);//AP1
			self->priv->resFontSize = gtk_range_get_value(GTK_RANGE(resFontSz));//AP1

			self->priv->updOnClick = hildon_check_button_get_active (HILDON_CHECK_BUTTON (checkBtClick));
			self->priv->updOnDesktop = hildon_check_button_get_active (HILDON_CHECK_BUTTON (checkBtDesktop));

			self->priv->delayIndex = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (intervalSelector), 0);
			self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);

			self->priv->updNeworkPolicy = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (networkPolicySel), 0);

			if (self->priv->updateTimerID != 0) {
				g_source_remove (self->priv->updateTimerID);
				self->priv->updateTimerID = 0;
			}
			else

			queen_beecon_write_settings (self, FALSE, FALSE, FALSE);
			queen_beecon_update_content (self);
			settingsRunning = 0;
		}
		else if(setDialogReturn == NON_GTK_RESPONSE_ADD_CMD)
		{
			queen_beecon_edit_add_dialog(self, TRUE, 0);
			queen_beecon_write_settings (self, FALSE, FALSE, FALSE);
		}
		else if(setDialogReturn == NON_GTK_RESPONSE_EDIT_CMD)
		{
			int cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0);
			if(cmdSel < self->priv->c_size && cmdSel >= 0)
			{
				queen_beecon_edit_add_dialog(self, FALSE, cmdSel);
				queen_beecon_write_settings (self, FALSE, FALSE, FALSE);
			}
		}
		else if(setDialogReturn == NON_GTK_RESPONSE_SEND_TO_BACK)
		{

			gtk_window_set_keep_below (GTK_WINDOW (self), TRUE);
			settingsRunning = 0;
		}
		else
			settingsRunning = 0;

		gtk_widget_destroy (dialog);
		gtk_widget_queue_draw (GTK_WIDGET (self));//AP3
		//END
	}
}

void queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr)
{
g_warning ("(%p) queen_beecon_edit_add_dialog new=%d curr=%d", self, new, curr);
	GtkWidget *dialog;
	gchar * title;
	if(new)
		title = g_strconcat ("Add new command", NULL);
	else
		title = g_strconcat ("Edit ", self->priv->c_titles[curr] ," command", NULL);

	if(new)
		dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, NULL);
	else
		dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, _("wdgt_bd_delete"), NON_GTK_RESPONSE_DELETE_CMD, NULL);

	GtkWidget *content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	//BEGIN title
	GtkWidget *titleBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *titleLabel = gtk_label_new ("Title:");
	gtk_misc_set_alignment (GTK_MISC (titleLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (titleLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, titleLabel);

	GtkWidget *titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_box_pack_start (GTK_BOX (titleBox), titleLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (titleBox), titleEntry, TRUE, TRUE, 0);
	if(!new)
		hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->c_titles[curr]);

	gtk_container_add (GTK_CONTAINER (content_area), titleBox);
	//END

	//BEGIN command
	GtkWidget *commandBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *commandLabel = gtk_label_new ("Command:");
	gtk_misc_set_alignment (GTK_MISC (commandLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (commandLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, commandLabel);

	GtkWidget *commandEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_box_pack_start (GTK_BOX (commandBox), commandLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (commandBox), commandEntry, TRUE, TRUE, 0);
	if(!new)
		hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->c_commands[curr]);

	gtk_container_add (GTK_CONTAINER (content_area), commandBox);
	//END

	gtk_widget_show_all (dialog);
	int dialogRunResponse = gtk_dialog_run (GTK_DIALOG (dialog));
	switch(dialogRunResponse)
	{
		case GTK_RESPONSE_ACCEPT:
			if(new)
			{
				AddCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))));
			}
			else
			{
				EditCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), curr);
			}
			break;

		case NON_GTK_RESPONSE_DELETE_CMD:
			DelCommand(self,curr);
			break;

	}
	gtk_widget_destroy (dialog);
	g_free(title);
}

//Auxiliary functions
void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command)
{
g_warning ("(%p) AddCommand title=[%s] command=[%s]", self, s_title, s_command);
	gchar ** newTitles = malloc( sizeof(gchar*)*(self->priv->c_size+2) );
	gchar ** newCommands = malloc( sizeof(gchar*)*(self->priv->c_size+2) );

	int i;
	for(i=0;i<self->priv->c_size;i++)
	{
		newTitles[i] = g_strdup(self->priv->c_titles[i]);
		newCommands[i] = g_strdup(self->priv->c_commands[i]);
	}

	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;
	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	newTitles[self->priv->c_size] = s_title;
	newCommands[self->priv->c_size] = s_command;

	newTitles[self->priv->c_size+1] = NULL;
	newCommands[self->priv->c_size+1] = NULL;

	g_free(self->priv->instanceTitle);
	self->priv->instanceTitle = NULL;
	g_free(self->priv->instanceCmd);
	self->priv->instanceCmd = NULL;

	self->priv->instanceTitle = g_strdup(newTitles[self->priv->c_size]);
	self->priv->instanceCmd = g_strdup(newCommands[self->priv->c_size]);


	self->priv->c_size += 1;

	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;
}

void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, int index)
{
g_warning ("(%p) EditCommand title=[%s] command=[%s] index=[%d]", self, s_title, s_command, index);
	//Clean old
	g_free(self->priv->c_titles[index]);
	g_free(self->priv->c_commands[index]);

	self->priv->c_titles[index] = s_title;
	self->priv->c_commands[index] = s_command;
}

void DelCommand(QueenBeecon *self, int index)
{
g_warning ("(%p) DelCommand index=%d", self, index);
	gchar ** newTitles = malloc( sizeof(gchar*)*(self->priv->c_size) );
	gchar ** newCommands = malloc( sizeof(gchar*)*(self->priv->c_size) );

	int i;
	for(i=0;i<self->priv->c_size;i++)
	{
		//index is the delete target
		if(i < index)
		{
			newTitles[i] = g_strdup(self->priv->c_titles[i]);
			newCommands[i] = g_strdup(self->priv->c_commands[i]);
		}
		else if(i > index)
		{
			newTitles[i-1] = g_strdup(self->priv->c_titles[i]);
			newCommands[i-1] = g_strdup(self->priv->c_commands[i]);
		}
	}
	newTitles[self->priv->c_size-1] = NULL;
	newCommands[self->priv->c_size-1] = NULL;

	//clear old
	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;
	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	//assign new
	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;

	g_free(self->priv->instanceTitle);
	self->priv->instanceTitle = NULL;
	g_free(self->priv->instanceCmd);
	self->priv->instanceCmd = NULL;

	if(self->priv->c_size > 1)
	{
		self->priv->instanceTitle = g_strdup(newTitles[0]);
		self->priv->instanceCmd = g_strdup(newCommands[0]);
	}

	self->priv->c_size -= 1;//decrement size
}

guint GetSeconds(guint index)
{
g_warning ("GetSeconds index=%d", index);
	if(index > 0 && index < 9)
	{
		guint intervalTimes[] = {0, 30, 60, 300, 1800, 3600, 21600, 43200, 86400};
		return intervalTimes[index];
	}
	return 0;
}
