#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QDomDocument>
#include <QSignalMapper>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QResizeEvent>
#include <QUrl>
#include <QSettings>
#include "progressdialog.h"
#include "stackedwindow.h"
#include "dayperiod.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    virtual void resizeEvent(QResizeEvent * event);

signals:
    void uiReady();

private:
    Ui::MainWindow *ui;
    QSettings* settings;
    QDomDocument *doc;
    QNetworkAccessManager *manager;
    QSignalMapper* mapper;
    QString zipCode;
    QString zipCache;
    QString *latlon;
    QString *wfo;
    QString *zcode;
    QList<DayPeriod*>* dayPeriods;
    QPixmap** iconCache; //array of icon pointers
    QIcon *icon;
    int iconCount;
    bool needShowList;
    bool justStarted;
    ProgressDialog *pg;

    void detailWindow(int day);
    void setDomDocument(QString* reply);
    void deleteCache();
    QList<QString*>* parse_for_temps(QDomElement* domElement);
    QList<QString*>* parse_for_days(QDomElement* domElement);
    QList<QString*>* parse_for_precip(QDomElement* domElement);
    QString* parse_for_city(QDomElement* domElement);

private slots:
    void gotCoordinates();
    void gotXML();
    void setDayIcons(int dayIndex);
    void setFIcon();
    void setTempGraph();

    void dayClick(QModelIndex index);
    void changeZip();
    void setSettings();
    void visitNAOO();
    void zipEvent(){
        changeZip();
    }


};

#endif // MAINWINDOW_H
