#ifndef STACKEDWINDOW_H
#define STACKEDWINDOW_H

#include <QMainWindow>
#include <QResizeEvent>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkReply>
#include <QSignalMapper>

namespace Ui {
    class StackedWindow;
}

class StackedWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit StackedWindow(QString* latlong, QString* wso, QString* zcode,
                           QString* offset, QPixmap* dayIcon, QString* dayURL,
                           QPixmap* nightIcon, QString* nightURL, QWidget *parent = 0);
    ~StackedWindow();
    void setInfo(QString &day, QString &hi, QString &lo, QString &precip, QString &dayFor, QString &nightFor);


protected:
    virtual void resizeEvent(QResizeEvent * event);

private slots:
    void setIcons(int mapping);

private:
    Ui::StackedWindow *ui;
    QSignalMapper* mapper;
    QNetworkAccessManager *manager;
};

#endif // STACKEDWINDOW_H
