#include "noaaparser.h"



/**
  get the "wfo" (weather forecast office) parameter
  that is required for downlaoding graph images
  */
QString* NOAAParser::parse_for_wfo(QDomElement *docEle){
	QString* wfo = new QString(docEle->elementsByTagName("wordedForecast").at(0).toElement().attribute("dataSource"));
	wfo->truncate(3);
	return wfo;
}


/**
  Takes a DomElement and creates a QList of QStrings containing the temperatures
  !!You must delete the return value yourself
  */
QList<QString*>* NOAAParser::parse_for_temps(QDomElement *docEle){

	QDomNodeList hiList;
	QDomNodeList lowList;
	QDomNodeList tempList = docEle->elementsByTagName("temperature"); //temperature list
	for(int i = 0; i < tempList.size(); i++){
		if(tempList.at(i).toElement().attribute("type") == "maximum"){
			hiList = tempList.at(i).toElement().elementsByTagName("value");
		}else{
			lowList = tempList.at(i).toElement().elementsByTagName("value");
		}
	}

	/*merge temps into one day period ordered list*/
	QList<QString*>* hiloList = new QList<QString*>();

	if(hiList.size() > lowList.size()){
		for(int i = 0; i < lowList.size(); i++){
			hiloList->append(new QString("Hi: " + QString(hiList.at(i).toElement().text()) + " F"));
			hiloList->append(new QString("Lo: " + QString(lowList.at(i).toElement().text()) + " F"));
		}hiloList->append(new QString("Hi: " + QString(hiList.at(lowList.size()).toElement().text()) + " F"));
	}else{
		for(int i = 0; i < hiList.size(); i++){
			hiloList->append(new QString("Lo: " + QString(lowList.at(i).toElement().text()) + " F"));
			hiloList->append(new QString("Hi: " + QString(hiList.at(i).toElement().text()) + " F"));
		}hiloList->append(new QString("Lo: " + QString(lowList.at(hiList.size()).toElement().text()) + " F"));
	}

	return hiloList;
}


/**
  National Weather service does not have a consistent xml feed. Sometimes the days
  of the week are the second 'time-layout' tag, sometimes they're the third, we have
  have to search for them
  !!You must delete the return value yourself
  */
QList<QString*>* NOAAParser::parse_for_days(QDomElement *docEle){
	QDomNodeList weekList = docEle->elementsByTagName("time-layout");
	for(int i = 0; i < weekList.size(); i++){
		if( (weekList.at(i).firstChildElement().text() == "k-p12h-n15-1") | (weekList.at(i).firstChildElement().text() == "k-p12h-n14-1") | (weekList.at(i).firstChildElement().text() == "k-p12h-n13-1") ){
			weekList = weekList.at(i).toElement().elementsByTagName("start-valid-time");
		}
	}

	QList<QString*>* days = new QList<QString*>();
	for(int i = 0; i < weekList.size(); i++){
		days->append(new QString(weekList.at(i).toElement().attribute("period-name")));
	}

	return days;
}


/**
  Parse the xml file for the city that represents the zipcode. Not all
  xml files will contains the same city zipcode (one of two choices...so far)
  so we need to see which one it has
  !!You must delete the return value yourself
  */
QString* NOAAParser::parse_for_city(QDomElement *docEle){
	QDomNodeList locList(docEle->firstChild().nextSibling().toElement().elementsByTagName("location"));
	QString location;
	if(locList.at(0).toElement().elementsByTagName("city").size() > 0){
		location = QString(locList.at(0).toElement().elementsByTagName("city").at(0).toElement().text());
	}else{
		location = QString(locList.at(0).toElement().elementsByTagName("area-description").at(0).toElement().text());
	}

	QString* city = new QString(location);
	return city;
}



/**
  Parse the dom document for the precipitations and return them
  in a new QList of QStrings. Also format the string's to include
  "Precipitation: " so setting label's is easier later
  !!You must delete the return value yourself
  */
QList<QString*>* NOAAParser::parse_for_precip(QDomElement *docEle){
	QDomNodeList precipList = docEle->elementsByTagName("probability-of-precipitation").at(0).toElement().elementsByTagName("value");
	QList<QString*>* returnPrecips = new QList<QString*>();

	for(int i = 0 ; i < precipList.size(); i++){
		QString str("Precipitation: " + precipList.at(i).toElement().text() + "%");
		if(precipList.at(i).toElement().text().isEmpty()){
			str = "Precipitation: Effectively 0%";
		}
		returnPrecips->append(new QString(str));
	}
	return returnPrecips;

}
