import QtQuick 1.0

Rectangle {
	property alias opt1Text: option1Text.text
	property alias opt2Text: option2Text.text

	property int selected: 0

	Component.onCompleted: startup()
	function startup(){
		if(selected == 1)
			toggle.state = "opt1"
		else if(selected == 2)
			toggle.state = "opt2"
	}

	id: toggle
	width: 400
	height: 80
	color: "#00000000"

	Rectangle {
		id: option1
		y: 0
		width: 202
		height: 80
		radius: 10
		anchors.left: parent.left
		anchors.leftMargin: 0
		gradient: Gradient {
			GradientStop {
	   id: gradientstop1
				position: 0
				color: "#3e3e3e"
			}

			GradientStop {
	   id: gradientstop2
				position: 1
				color: "#3e3e3e"
			}

			GradientStop {
	   id: gradientstop3
				position: 0.5
				color: "#000000"
			}
		}

		MouseArea {
			id: option1Area
			anchors.fill: parent
			drag.minimumY: -1000
			drag.minimumX: -1000
			drag.maximumY: 1000
			drag.maximumX: 1000
			onClicked: {
				if( toggle.state == "opt1")
					toggle.state = ""
				else
					toggle.state = "opt1"
			}
		}

		Text {
			id: option1Text
			color: "#ffffff"
			text: "opt1"
			horizontalAlignment: Text.AlignHCenter
			verticalAlignment: Text.AlignVCenter
			anchors.fill: parent
			font.pixelSize: 40
		}
	}

	Rectangle {
		id: option2
		x: 204
		y: 0
		width: 202
		height: 80
		radius: 10
		anchors.right: parent.right
		anchors.rightMargin: 0
		MouseArea {
			id: option2Area
			anchors.fill: parent
			drag.minimumY: -1000
			drag.minimumX: -1000
			drag.maximumY: 1000
			drag.maximumX: 1000
			onClicked: {
				if(toggle.state == "opt2")
					toggle.state = ""
				else
					toggle.state = "opt2"
			}
		}

		Text {
			id: option2Text
			color: "#ffffff"
			text: "opt2"
			font.pixelSize: 40
			anchors.fill: parent
			horizontalAlignment: Text.AlignHCenter
			verticalAlignment: Text.AlignVCenter
		}
		gradient: Gradient {
			GradientStop {
	   id: gradientstop4
				position: 0
				color: "#3e3e3e"
			}

			GradientStop {
	   id: gradientstop5
				position: 1
				color: "#3e3e3e"
			}

			GradientStop {
	   id: gradientstop6
				position: 0.5
				color: "#000000"
			}
		}
	}

	Rectangle {
		id: cover
		x: -5
		width: 20
		radius: 2
	  anchors.bottom: parent.bottom
	  anchors.bottomMargin: 0
	  anchors.top: parent.top
	  anchors.topMargin: 0
	  anchors.horizontalCenter: parent.horizontalCenter
		gradient: Gradient {
			GradientStop {
				position: 0
				color: "#3e3e3e"
			}

			GradientStop {
				position: 1
				color: "#3e3e3e"
			}

			GradientStop {
				position: 0.5
				color: "#000000"
			}
		}
	}
 states: [
	 State {
		 name: "opt1"

		 PropertyChanges {
			 target: toggle
			 selected: 1
		 }

		 PropertyChanges {
			 target: gradientstop1
			 position: 0
			 color: "#000000"
		 }

		 PropertyChanges {
			 target: gradientstop2
			 position: 1
			 color: "#000000"
		 }

		 PropertyChanges {
			 target: gradientstop3
			 position: 0.5
			 color: "#0f0055"
		 }
	 },
	 State {
		 name: ""
		 PropertyChanges {
			 target: toggle
			 selected: 0

		 }
	 },
	 State {
		 name: "opt2"

		 PropertyChanges {
			 target: toggle
			 selected: 2
		 }

		 PropertyChanges {
			 target: gradientstop4
			 position: 0
			 color: "#000000"
		 }

		 PropertyChanges {
			 target: gradientstop5
			 position: 1
			 color: "#000000"
		 }

		 PropertyChanges {
			 target: gradientstop6
			 position: 0.5
			 color: "#0f0055"
		 }
	 }
 ]
}
