#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QClipboard>
#include <QHash>
#include <QHashIterator>
#include <QMessageBox>
#include <QHttp>
#include <QtCore/QBuffer>
#include <QUrl>
#include <QtDebug>
#include <QDesktopServices>
#include <QCloseEvent>
#include <QSettings>

namespace Ui {
    class MainWindow;
    //class MainWindowVert;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void loadSettings();
    void saveSettings();

public slots:
    void leftFromClipboard();
    void leftToClipboard();
    void rightFromClipboard();
    void rightToClipboard();
    void leftAsEmail();
    void rightAsEmail();
    void leftAsSms();
    void rightAsSms();
    void leftClear();
    void rightClear();
    void translateLeftToRight();
    void translateRightToLeft();
    void aboutQTranslate();
    void donate();

protected:
    void changeEvent(QEvent *e);
    void resizeEvent(QResizeEvent *e);
    void closeEvent(QCloseEvent *event);

private:
    Ui::MainWindow *ui;
    //Ui::MainWindowVert *uiVert;
    void fromClipboard(int);
    void toClipboard(int);
    void initLangCodes();
    void googleTranslate(QString, QString, QString);
    QHttp *_http;
    QBuffer *_translation;
    int _toWindow;
    bool inResizeEvent;

private slots:
    void translateRequestFinished(int requestId, bool error);
};

#endif // MAINWINDOW_H
