#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QProcess>
#include <QMessageBox>
#include <QFile>
#include <QTextStream>
#include <QComboBox>
#include <iostream>
#include <fstream>

using namespace std;

namespace Ui
{
    class PianobarQtClass;
}

class PianobarQt : public QMainWindow
{
    Q_OBJECT

public:
    PianobarQt(QWidget *parent = 0);
    ~PianobarQt();

private:
    Ui::PianobarQtClass *ui;
    QProcess process;
    QString output;
    QString btnTxt;
    QFile control;
    ofstream ctrl;
    QStringList stationList;
    bool stationsPopulated;
    bool playing;
    bool paused;
    bool stationChanged;
    QIcon pause;
    QIcon play;
    QIcon skip;
    QIcon skipping;
    QIcon favour;
    QIcon fav;
    QIcon banning;
    QIcon ban;
    QByteArray selected;
    QRegExp stripSong;
    QRegExp songFavoured;
    QRegExp rxlen;
    QRegExp stripTimeLeft;
     QStringList stations;

private slots:
    void on_pushButton_next_clicked();
    void on_pushButton_next_pressed();
    void on_pushButton_next_released();

    void on_pushButton_ban_clicked();
    void on_pushButton_ban_released();
    void on_pushButton_ban_pressed();

    void on_pushButton_favourite_released();
    void on_pushButton_favourite_pressed();
    void on_pushButton_favourite_clicked();

    void on_pushButton_playpause_clicked();
    //    void on_pushButton_quit_clicked();

    void on_cmdExec_finish();
    void on_cmdExec_data_available();

    void comboxBox_stations_currentIndexChanged(QString);
};

#endif // MAINWINDOW_H
