#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "pluginconfiguration.h"


PluginConfiguration::PluginConfiguration(MobileHotspotPluginHelper *helper){
	this->helper = helper; // register our helper, it is useful for loading/saving and such
}

PluginConfiguration::~PluginConfiguration(){
	// helper deletion is handled by plugin itself, no need to destroy it here
}

void PluginConfiguration::reset(){
	// Reset the plugin's configuration, by deleting the saved one and calling load()
	helper->deleteConfiguration(); // Delete saved configuration

	// You may want to do some things here before calling load, such as freeing memory
	// Type here your customized code
	// delete myVariable;

	load(); // Load configuration (the default one, as none is saved)
}

void PluginConfiguration::load(){
	// Load the plugin's configuration, please use the helper function load("settingName", "defaultValue")
	// some_variable = helper->load("settingName", "default value").toString();
	disablePowerSaving = helper->load("disablePowerSaving", "false").toString() == "true";
	internetPing = helper->load("internetPing", "false").toString() == "true";
	internetPingIP = helper->load("internetPingIP", "example.com").toString();
	wlanCheck = helper->load("wlanCheck", "true") == "true";

	QString enf = helper->load("enforcement2g3g", "ignore").toString();
	if(enf == "2g")
		enforcement2g3g = ENFORCEMENT_2G3G_2G;
	else if(enf == "3g")
		enforcement2g3g = ENFORCEMENT_2G3G_3G;
	else if(enf == "2g3g")
		enforcement2g3g = ENFORCEMENT_2G3G_DOUBLE;
	else
		enforcement2g3g = ENFORCEMENT_2G3G_IGNORE;
}

void PluginConfiguration::save(){
	// Save the plugin's configuration, please use the helper function save("settingName", value)
	// helper->save("settingName", some_variable);
	helper->save("disablePowerSaving", disablePowerSaving ? "true" : "false");
	helper->save("internetPing", internetPing ? "true" : "false");
	helper->save("internetPingIP", internetPingIP);
	helper->save("wlanCheck", wlanCheck ? "true" : "false");

	if(enforcement2g3g == ENFORCEMENT_2G3G_2G)
		helper->save("enforcement2g3g", "2g");
	else if(enforcement2g3g == ENFORCEMENT_2G3G_3G)
		helper->save("enforcement2g3g", "3g");
	else if(enforcement2g3g == ENFORCEMENT_2G3G_DOUBLE)
		helper->save("enforcement2g3g", "2g3g");
	else
		helper->save("enforcement2g3g", "ignore");
}
