#include <QtCore/QString>
#include <QtCore/QVariant>
#include <gq/gconfitem.h>
#include "mobilehotspotconfiguration.h"
#include "mobilehotspotplugin.h"
#include "mobilehotspotpluginhelper.h"


MobileHotspotPluginHelper::MobileHotspotPluginHelper(MobileHotspotPlugin *plug){
	plugin = plug;
}

MobileHotspotPluginHelper::~MobileHotspotPluginHelper(){
}

QString MobileHotspotPluginHelper::gconfKey(){
	return QString(GCONF) + "/" + plugin->name();
}

void MobileHotspotPluginHelper::save(QString name, QVariant value){
	/** Supports (GConfItem) :
	 * - QVariant::Int, QVariant::Double, QVariant::Bool
	 * - QVariant::String (UTF8 only)
	 * - QVariant::StringList
	 * - QVariant::List
	 */
	GConfItem item(gconfKey() + "/" + name);
	item.set(value);
}

QVariant MobileHotspotPluginHelper::load(QString name, QVariant def){
	/** Supports (GConfItem) :
	 * - QVariant::Int, QVariant::Double, QVariant::Bool
	 * - QVariant::String (UTF8 only)
	 * - QVariant::StringList
	 * - QVariant::List
	 */
	GConfItem item(gconfKey() + "/" + name);
	return item.value(def);
}

