#ifndef MOBILEHOTSPOTGUI_H
#define MOBILEHOTSPOTGUI_H

#include <QtGui/QMainWindow>
#include <QtCore/QStringList>
#include <QtCore/QString>
#include <QtGui/QCloseEvent>
#include <QtCore/QProcess>
#include <QtCore/QMap>
#include <QtGui/QAction>
#include <QtCore/QList>
#include <QtDBus/QDBusMessage>
#include "dbushelper.h"
#include "mobilehotspotconfiguration.h"
#include "mobilehotspotplugin.h"
#include "ui_mobilehotspotgui.h"


class MobileHotspotGUI : public QMainWindow
{
    Q_OBJECT

public:
    MobileHotspotGUI(QWidget *parent = 0);
    ~MobileHotspotGUI();

private:
	void updateDisplayedConfiguration();
	void loadPlugins();
	void sortPlugins();
	void displayPlugins();
	void previousConnectionEnableSignal();
	void previousConnectionDisableSignal();
	void previousConnectionRequest();

	Ui::MobileHotspotGUIClass ui;
    QMap<QString, MobileHotspotPlugin*> plugins;
    MobileHotspotConfiguration configuration;
    QStringList alreadyLoadedModules;
    int scanInterval;
    QProcess dnsmasqProcess;
    int ipforward;
    bool showNotifications;
    bool successStarting;
    QList<QString> sortedPlugins;
    bool waitingForPreviousConnection;
    QString previousConnectionID;
    QString previousConnectionType;
    Enforcement2G3G previousEnforcement;

protected :
        void closeEvent(QCloseEvent* event);

private slots:
	void configureAccessPoint();
	void configureInternetAccess();
	void configureInterface(int index);
	void pluginTriggered();
	void about();
	void start(bool notification = true);
	void startProcedure();
	void stop(bool notification = true);
	void stopProcedure();
	void previousConnectionSignal(const QDBusMessage &message);
};

#endif // MOBILEHOTSPOTGUI_H
