#include <QtCore/QObject>
#include <QtCore/QString>
#include <gq/gconfitem.h>
#include "mobilehotspotconfiguration.h"

const QString MobileHotspotConfiguration::ENCRYPTION_NONE = QString("None");
const QString MobileHotspotConfiguration::ENCRYPTION_WEP = QString("WEP");
const QString MobileHotspotConfiguration::INTERFACE_USB = QString("usb0");
const QString MobileHotspotConfiguration::INTERFACE_WLAN = QString("wlan0");


MobileHotspotConfiguration::MobileHotspotConfiguration(QObject *parent)
	:	QObject(parent){
	internet = true;
}

MobileHotspotConfiguration::~MobileHotspotConfiguration(){
}

void MobileHotspotConfiguration::load(){
	GConfItem *item;

	item = new GConfItem(GCONF_APNAME);
	apname = item->value("N900 Hotspot").toString();
	delete item;

	item = new GConfItem(GCONF_ENCRYPTION);
	encryption = item->value(ENCRYPTION_NONE).toString();
	delete item;

	item = new GConfItem(GCONF_KEY);
	key = item->value("0000000000000").toString();
	delete item;

	item = new GConfItem(GCONF_INTERFACE);
	interface = item->value(INTERFACE_WLAN).toString();
	delete item;

	item = new GConfItem(GCONF_APN);
	apn = item->value("").toString();
	delete item;

	item = new GConfItem(GCONF_APID);
	apid = item->value("").toString();
	delete item;

	item = new GConfItem(GCONF_NETWORK);
	network = item->value("192.168.254.").toString();
	delete item;

	item = new GConfItem(GCONF_INTERNET);
	internet = item->value("true").toString() == "true";
	delete item;

	item = new GConfItem(GCONF_2G3G);
	QString enf = item->value("ignore").toString();
	if(enf == "2g")
		enforcement2g3g = ENFORCE_2G;
	else if(enf == "3g")
		enforcement2g3g = ENFORCE_3G;
	else if(enf == "2g3g")
		enforcement2g3g = ENFORCE_2G3G;
	else
		enforcement2g3g = IGNORE;
	delete item;
}

void MobileHotspotConfiguration::save(){
	GConfItem *item;

	item = new GConfItem(GCONF_APNAME);
	item->set(apname);
	delete item;

	item = new GConfItem(GCONF_ENCRYPTION);
	item->set(encryption);
	delete item;

	item = new GConfItem(GCONF_KEY);
	item->set(key);
	delete item;

	item = new GConfItem(GCONF_INTERFACE);
	item->set(interface);
	delete item;

	item = new GConfItem(GCONF_APN);
	item->set(apn);
	delete item;

	item = new GConfItem(GCONF_APID);
	item->set(apid);
	delete item;

	item = new GConfItem(GCONF_NETWORK);
	item->set(network);
	delete item;

	item = new GConfItem(GCONF_INTERNET);
	item->set(internet ? "true" : "false");
	delete item;

	item = new GConfItem(GCONF_2G3G);
	if(enforcement2g3g == ENFORCE_2G)
		item->set("2g");
	else if(enforcement2g3g == ENFORCE_3G)
		item->set("3g");
	else if(enforcement2g3g == ENFORCE_2G3G)
		item->set("2g3g");
	else
		item->set("ignore");
	delete item;
}

