#include "mobilehotspotconfiguration.h"
#include "accesspointgui.h"
#include <QtGui/QDialog>
#include <QtGui/QMessageBox>

AccessPointGUI::AccessPointGUI(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
}

AccessPointGUI::~AccessPointGUI()
{

}

void AccessPointGUI::setConfiguration(MobileHotspotConfiguration &configuration){
	ui.txtAPName->setText(configuration.apname);
	ui.chkEncryption->setChecked(configuration.encryption == configuration.ENCRYPTION_WEP);
	ui.txtKey->setText(configuration.key);
}

void AccessPointGUI::getConfiguration(MobileHotspotConfiguration *configuration){
	QString name = ui.txtAPName->text().replace("\\", "").replace("\"", "");
	configuration->apname = name == "" ? "N900 Hotspot" : name;
	configuration->encryption = ui.chkEncryption->isChecked() ? configuration->ENCRYPTION_WEP : configuration->ENCRYPTION_NONE;
	configuration->key = validKey();
}

QString AccessPointGUI::validKey(){
	QString res;
	QString entered = ui.txtKey->text();
	try{
		if(entered.size() != 5 && entered.size() != 13)
			throw QString("fail");
		res = entered;
	}
	catch(QString fail){
		QMessageBox::warning(this, tr("Invalid key"), tr("Keys must have a length of 5 or 13. Your key has been tweaked according to this."));
		if(entered.size() < 5)
			res = entered + QString(5 - entered.size(), '0');
		else if(entered.size() < 13)
			res = entered + QString(13 - entered.size(), '0');
		else
			res = entered.left(13);
	}
	return res;
}
