/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QSettings>

#include "dataresource.h"


Resource::Resource()
    : settings(new QSettings()),
      pixmapPrefix(":/")
{

}

Resource::~Resource()
{
    delete settings;
}

Resource *Resource::instance()
{
    static Resource result;
    return &result;
}

void Resource::setIniFile(const QString &fileName)
{
    Resource *d = instance();

    if (d->settings)
        delete d->settings;

    d->settings = new QSettings(fileName, QSettings::IniFormat);
}

QPixmap Resource::pixmap(const QString &path)
{
    Resource *d = instance();
    return QPixmap(QString("%1%2").arg(d->pixmapPrefix, path));
}

void Resource::setPixmapPrefix(const QString &prefix)
{
    Resource *d = instance();
    d->pixmapPrefix = prefix;
}

bool Resource::containsValue(const QString &key)
{
    Resource *d = instance();
    return d->settings->contains(key);
}

QVariant Resource::value(const QString &key, const QVariant &value)
{
    Resource *d = instance();

    if (d->settings->contains(key))
        return d->settings->value(key, value);
    else {
        qWarning("Resource: key '%s' not found", key.toLatin1().data());
        return QVariant();
    }
}

int Resource::intValue(const QString &key, int value)
{
    return Resource::value(key, value).toInt();
}

double Resource::doubleValue(const QString &key, double value)
{
    return Resource::value(key, value).toDouble();
}

QString Resource::stringValue(const QString &key, const QString &value)
{
    return Resource::value(key, value).toString();
}
