/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QApplication>
#include <QGraphicsScene>
#include <QGraphicsView>
#include <QPixmapCache>
#include <QSettings>
#include <QDebug>

#include "system.h"
#include "mainview.h"
#include "forecastdata.h"
#include "settings.h"

#include "forecastprovider.h"
#include "demoforecastsource.h"
#include "networkforecastsource.h"

#if defined (Q_OS_SYMBIAN)
#include "symbiannetwork.h"
#endif


int main(int argc, char **argv)
{
    qRegisterMetaType<ForecastData>("ForecastData");

    QApplication app(argc, argv);
    QCoreApplication::setOrganizationName("openBossa");
    QCoreApplication::setOrganizationDomain("openbossa.org");
    QCoreApplication::setApplicationName("weather");

#ifdef Q_OS_SYMBIAN
    const bool connected = connect();
#else
    const bool connected = true;
#endif

    if (connected)
        ForecastProvider::setForecastSource(new NetworkForecastSource());
    else
        ForecastProvider::setForecastSource(new DemoForecastSource(1500));

    MainView mainView(connected);

    System::setViewMode(&mainView, System::PortraitMode);

#if defined(Q_OS_SYMBIAN) || defined(Q_WS_MAEMO_5)
    mainView.showFullScreen();
#else
    mainView.show();
#endif

    return app.exec();
}
