/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTSNOW_H
#define FORECASTSNOW_H

#include <QObject>
#include <QGraphicsItem>
#include <QBasicTimer>
#include <QTime>

class ForecastSnow : public QObject
{
    Q_OBJECT
public:
    ForecastSnow(int count, const QRectF &bounds, QGraphicsItem *parent);

    static int loadImages();

    void paint(QPainter *painter);

public slots:
    void start();
    void stop();
    void show() { m_visible = true; }
    void hide() { m_visible = false; }

protected:
    void timerEvent(QTimerEvent *event);

private:
    class SnowFlake
    {
    public:
        SnowFlake(int type, const QSizeF &bounds);
        void timerEvent(int interval_ms);

        qreal width() const { return m_pixmap.width(); }
        qreal height() const { return m_pixmap.height(); }

        void setPos(qreal x, qreal y) { m_pos = QPointF(x, y); }
        void setWaitingTime(int value) { m_waitingTime = value; }

        bool isVisible() const { return !m_pixmap.isNull(); }

        inline void paint(QPainter *painter);

    private:
        QPixmap m_pixmap;
        const QSizeF m_bounds;
        QPointF m_speed;
        QPointF m_pos;
        int m_waitingTime;
    };

    const QRectF m_bounds;
    QGraphicsItem *m_parent;
    QList<SnowFlake*> m_flakes;
    QBasicTimer m_ticker;
    QTime m_lastTick;

    qreal m_visible;

    void updateFLakesPositions();

};

#endif // FORECASTSNOW_H
