#ifndef DEMOFORECASTSOURCE_H
#define DEMOFORECASTSOURCE_H

#include "forecastsource.h"
#include "yahooweatherresponse.h"

#include <QList>

class DemoForecastSource : public ForecastSource
{
    Q_OBJECT
public:
    DemoForecastSource(int waitTime, QObject *parent = 0);
    int getForecast(const QString &key, bool locationId);

private:

    class Request
    {
    public:
        int m_reqId;
        QString m_locId;
        QString m_cityQuery;
    };

    const int m_waitTime;
    QList<Request> m_requests;
    QList<ForecastData> m_list;
    int m_idSeq;

    void createContentList();
    QString findCity(const QString &name);

    int getId() { return ++m_idSeq; }

    int findByLocId(const QString &locId);
    int findByQuery(const QString &query);

private slots:
    void sendResponse();

};

#endif // DEMOFORECASTSOURCE_H
