/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "citymanager.h"
#include "settings.h"

#include <QGraphicsSceneMouseEvent>
#include <QPropertyAnimation>

static inline qreal getBottomVerticalPos(qreal &bottom, QGraphicsItem *item)
{
    const qreal result = bottom - item->boundingRect().bottom();
    bottom -= item->boundingRect().height();
    return result;
}

// CityManagerContent

CityManagerContent::CityManagerContent(QList<ForecastData> &contentList, QGraphicsItem *parent)
    : QGraphicsItem(parent)
    , m_boundingRect(QPointF(0.0, 0.0), Settings::windowSize())
{
    setFlag(ItemHasNoContents);

    qreal bottom = m_boundingRect.bottom();
    m_addTool = new AddCityTool(contentList, this);
    m_addTool->setPos(0.0, getBottomVerticalPos(bottom, m_addTool));
    m_addTool->setZValue(10.0);

    m_list = new CityList(contentList, this);
    m_list->setPos(0.0, getBottomVerticalPos(bottom, m_list) + m_list->initialTop() + 1);
    m_list->setZValue(0.0);

    connect(m_addTool, SIGNAL(newForecast(ForecastData)),
            this, SLOT(forecastSelected(ForecastData)));

}

void CityManagerContent::forecastSelected(ForecastData data)
{
    m_list->addForecast(data);
}

QRectF CityManagerContent::boundingRect () const
{
    return m_boundingRect;
}

void CityManagerContent::paint(QPainter *painter,
                               const QStyleOptionGraphicsItem *opt, QWidget *widget)
{
    Q_UNUSED(painter);
    Q_UNUSED(opt);
    Q_UNUSED(widget);
}

qreal CityManagerContent::getHiddenTop()
{
    return m_boundingRect.height() - m_list->pos().y() - 5.0;
}

// CityManager

CityManager::CityManager(QList<ForecastData> contentList, QGraphicsItem *parent)
    : QGraphicsItem(parent)
    , m_boundingRect(QPointF(0.0, 0.0), Settings::windowSize())
    , m_contentList(contentList)
    , m_visible(false)
{
    m_content = new CityManagerContent(m_contentList, this);
    m_content->setPos(0.0, m_content->getHiddenTop());
}

QRectF CityManager::boundingRect () const
{
    return m_boundingRect;
}

void CityManager::paint(QPainter *painter, const QStyleOptionGraphicsItem *opt, QWidget *widget)
{
    Q_UNUSED(painter);
    Q_UNUSED(opt);
    Q_UNUSED(widget);
}

void CityManager::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    event->accept();
    startAnimation(false);
}

void CityManager::showManager(const QString &selected)
{
    m_content->select(selected);
    startAnimation(true);
}

void CityManager::startAnimation(bool show)
{
    if (show == m_visible)
        return;

    m_visible = show;

    if (m_animation)
        m_animation->stop();

    QPropertyAnimation* animation = new QPropertyAnimation(m_content, "top");

    animation->setEasingCurve(QEasingCurve::OutExpo);
    animation->setEndValue(show ? 0.0 : m_content->getHiddenTop());
    animation->setDuration(500);
    m_animation = animation;
    if (!show)
        connect(animation, SIGNAL(finished()), this, SIGNAL(terminated()));
    m_animation->start(QAbstractAnimation::DeleteWhenStopped);

}
