/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef _PDATA_H_
#define _PDATA_H_

#include <QSettings>
#include <QStringList>
#include <QString>
#include <QDateTime>

class PData : public QSettings
{
    Q_OBJECT

public:

PData() : QSettings()
        {
            categoryList << "food" << "car" << "house" << "books" << "clothes" << "fun" \
                         << "health" << "travel";

            QStringList groups = childGroups();

            if (!groups.contains("date")) {
                beginGroup("date");
                QDate date = QDate::currentDate();
                beginGroup(QString::number(date.year()));
                setValue(QString::number(date.month()), 0);
                endGroup();
                endGroup();
            }
        }

    void addValue(const QString &group, qreal v)
    {
        uint timestamp = QDateTime::currentDateTime().toTime_t();

        updateMonthValue(v);

        beginGroup(group);
        QStringList keys = allKeys();

        if (keys.size() >= 101)
            remove(keys.at(0));

        setValue(QString::number(timestamp), v);
        endGroup();

        emit valueAdded(group);
    }

    QStringList rows(const QString &group)
    {
        beginGroup(group);
        QStringList keys = allKeys();
        endGroup();

        return keys;
    }

    QList<QPair<uint, qreal> > loadCategory(const QString &group)
    {
        QList<QPair<uint, qreal> >data;

        beginGroup(group);
        QStringList keys = allKeys();

        foreach (QString k, keys) {
            data << qMakePair(k.toUInt(), value(k, 0).value<qreal>());
        }
        endGroup();

        return data;
    }

    //## name
    qreal getValue(const QString &key)
    {
        return value(key, 0).value<qreal>();
    }

    QList<qreal> loadTotalsByCategory()
    {
        QList<qreal> totals;
        foreach (QString k, categoryList) {
            QList<QPair<uint, qreal> > data = loadCategory(k);
            qreal total = 0;
            QList<QPair<uint, qreal> >::const_iterator iter;

            for (iter = data.constBegin(); iter != data.constEnd(); ++iter)
                total += iter->second;

            totals << total;
        }

        return totals;
    }

signals:
    void valueAdded(const QString &group);

protected:

    void updateMonthValue(qreal v)
    {
        QDate date = QDate::currentDate();
        qreal sum = 0;

        beginGroup("date");
        beginGroup(QString::number(date.year()));
        qreal data = value(QString::number(date.month()), 0).value<qreal>();
        sum = data + v;
        setValue(QString::number(date.month()), sum);
        endGroup();
        endGroup();
    }

    QStringList categoryList;
};

Q_DECLARE_METATYPE(PData*)

#endif
