/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "calculatorengine.h"

CalculatorEngine::CalculatorEngine() : QObject(), firstOperand(0.0), secondOperand(0.0),
                                       operation(Sum), waitingForOperand(true), display("0"),
                                       digitCounter(0)
{

}

CalculatorEngine::~CalculatorEngine()
{

}

void CalculatorEngine::pressDigit(int digit)
{
    ++digitCounter;
    if (digitCounter > 6)
        return;

    if (waitingForOperand) {
        if ((digit == 0) && (display == "0")) {
            digitCounter = 0;
            return;
        }

        waitingForOperand = false;
        display.clear();
    }
    display += QString::number(digit);
    emit displayChanged(display);
}

void CalculatorEngine::pressDot()
{
    if (display.contains("."))
        return;

    // Why 4? Maximum number is 999999.99,
    // so if when we already have the 6 integer digits,
    // we need more 2 for the cents. When there are less
    // integer digits, we limit cents to 2 digits =)
    digitCounter = 4;

    if (waitingForOperand) {
         waitingForOperand = false;
         display = QString("0");
    }

    display += QString(".");
    emit displayChanged(display);
}

void CalculatorEngine::pressOperator(int op)
{
    if (!waitingForOperand)
        pressEqual();
    operation = Operator(op);
    digitCounter = 0;
}

void CalculatorEngine::pressClear()
{
    digitCounter = 0;
    waitingForOperand = true;
    display = QString("0");
    emit displayChanged(display);
}

void CalculatorEngine::pressClearAll()
{
    digitCounter = 0;
    firstOperand = 0.0;
    operation = Sum;
    waitingForOperand = true;
    display = QString("0");
    emit displayChanged(display);
}

void CalculatorEngine::pressEqual()
{
    if (waitingForOperand == false)
        secondOperand = display.toFloat();

    switch (operation) {
    case Sum:
        firstOperand += secondOperand;
        break;
    case Subtract:
        firstOperand -= secondOperand;
        break;
    case Multiply:
        firstOperand *= secondOperand;
        break;
    case Divide:
        if (secondOperand != 0)
            firstOperand /= secondOperand;
        break;
    }

    waitingForOperand = true;
    display = QString::number(firstOperand, 'f', 2);
    emit displayChanged(display);
}

qreal CalculatorEngine::currentValue()
{
    return display.toFloat();
}
