/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QPixmap>
#include <QPainter>
#include <QGraphicsSceneMouseEvent>
#include <QStyleOptionGraphicsItem>

#include "pixmapwidget.h"
#include "utils.h"


class PixmapWidgetPrivate
{
public:
    PixmapWidgetPrivate();

    int topBorder;
    int leftBorder;
    int rightBorder;
    int bottomBorder;

    QPixmap pixmap;
};

PixmapWidgetPrivate::PixmapWidgetPrivate()
    : topBorder(0), leftBorder(0), rightBorder(0), bottomBorder(0)
{

}


PixmapWidget::PixmapWidget(const QPixmap &pixmap, QGraphicsItem *parent)
    : QGraphicsWidget(parent),
      d(new PixmapWidgetPrivate)
{
    setPixmap(pixmap);
    setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
}

PixmapWidget::~PixmapWidget()
{
    delete d;
}

QPixmap PixmapWidget::pixmap() const
{
    return d->pixmap;
}

void PixmapWidget::setPixmap(const QPixmap &pixmap)
{
    d->pixmap = pixmap;

    if (pixmap.isNull())
        setPreferredSize(QSize());
    else
        setPreferredSize(pixmap.size());

    update();
    updateGeometry();
}

void PixmapWidget::getBorders(int *left, int *top, int *right, int *bottom) const
{
    if (left)
        *left = d->leftBorder;
    if (top)
        *top = d->topBorder;
    if (right)
        *right = d->rightBorder;
    if (bottom)
        *bottom = d->bottomBorder;
}

void PixmapWidget::setBorders(int left, int top, int right, int bottom)
{
    d->leftBorder = left;
    d->topBorder = top;
    d->rightBorder = right;
    d->bottomBorder = bottom;
    update();
}

void PixmapWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                         QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    bDrawPixmap(painter, d->pixmap, boundingRect(), d->leftBorder,
                d->topBorder, d->rightBorder, d->bottomBorder);
}
