/* Copyright (c) 2010, Nokia Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * * Neither the name of the Nokia Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QTMM_ERRORS_H_
#define QTMM_ERRORS_H_

#include <glib.h>
#include <glib-object.h>

/* Autogenerated header */
#include "qtmm-enums-gen.h"

G_BEGIN_DECLS

/* Error defines, the nicks are defined for qlib-mkenums, so don't remove */
typedef enum {
    QTMM_ERROR_NO_ERROR,          /*< nick=NoError >*/
    QTMM_ERROR_NO_RECIPIENTS,     /*< nick=NoRecipients >*/
    QTMM_ERROR_INVALID_ACCOUNT,   /*< nick=InvalidAccount >*/
    QTMM_ERROR_INVALID_FOLDER,    /*< nick=InvalidFolder >*/
    QTMM_ERROR_INVALID_MESSAGE,   /*< nick=InvalidMessage >*/
    QTMM_ERROR_INVALID_MIME_PART, /*< nick=InvalidMimePart >*/
    QTMM_ERROR_UNKNOWN            /*< nick=Unknown >*/
} QtmmErrors;

/* Get error domain */
GQuark
qtmm_errors_domain (void);

G_END_DECLS

#endif /* QTMM_ERRORS_H_ */
