//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsmedianextbutton.h"

LsMediaNextButton::LsMediaNextButton(QString name, SystemPlayer* player) :
        LsButton(name.isEmpty() ? "MediaNextButton": name)
{
    m_Player = player;
    applySettings();
}

void LsMediaNextButton::applySettings()
{
    m_Bkg = QPixmap(getSetting("BackGroundImage", "/opt/qtlockscreen/default/forward.png").toString());
    m_BkgPressed = QPixmap(getSetting("BackGroundImagePressed", "/opt/qtlockscreen/default/forwardPressed.png").toString());
    m_BkgPressed = m_BkgPressed.scaled(m_Bkg.size());

    setSizeAndPosition(m_Bkg.size(), QPoint(0, 0));
}

void LsMediaNextButton::clicked()
{
    qDebug() << "Button " << name() << "clicked";
    if (m_Player)
        m_Player->next();
}
