//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSCALENDAR_H
#define LSCALENDAR_H
#include "lstext.h"
#include "backends/systemprofiles.h"
#include <QDateTime>
#ifdef Q_WS_MAEMO_5
#include <alarmd/libalarm.h>
#include <calendar-backend/Common.h>
#include <calendar-backend/CalendarErrors.h>
#include <clockd/libtime.h>
#endif

class CalendarEntry
{
public:
    QPixmap Icon;
    int CalendarId;
    int Type;
    QDateTime DateStart;
    QDateTime DateEnd;
    QString Text;
};

class LsCalendar : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsCalendar(QString name="");

    void applySettings();
    void startUpdate();
    void stopUpdate();
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);

private:
    int m_NumberOfEntries;

    QString m_NoEventsText;
    QString m_DateFormat;
    QFont m_DateFont;
    QColor m_DateColor;

    QFont m_TextFont;
    QColor m_TextColor;

    QList<CalendarEntry*> m_Entries;

    void getEntries();
#ifdef Q_WS_MAEMO_5
    void addEntry(QList<CalendarEntry*>* entries, CComponent *componentEntry);
    QString GetIconPath(CComponent* component);
#endif

private slots:
    void updateCalendarEntries();

};

#endif // LSCALENDAR_H
