//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsalarm.h"
#include "lockscreen.h"
#ifdef Q_WS_MAEMO_5
#include <alarmd/libalarm.h>
#endif

LsAlarm::LsAlarm(QString name) :
        LsText(name.isEmpty() ? "Alarm": name)
{
    applySettings();
}

void LsAlarm::applySettings()
{
	LsText::applySettings();
    m_Label = getSetting("Label", "Next alarm:").toString();
    m_Format = getSetting("Format", "dd/MM/yyyy hh:mm").toString();

    setSizeAndPosition(QSize(24, 24),QPoint(0, 0));
}

void LsAlarm::startUpdate()
{
	QDateTime next = getFirstAlarm();
	QString text;
	if (!next.isNull())
        text = QString("%1 %2").arg(m_Label).arg(next.toString(m_Format));

	if (m_Text != text){
		m_Text = text;
		update();
	}
}

void LsAlarm::stopUpdate()
{

}

QDateTime LsAlarm::getFirstAlarm()
{
    QDateTime result;
#ifdef Q_WS_MAEMO_5
    cookie_t *list, *iter;
    list = alarmd_event_query(0, 0, 0, 0, "worldclock_alarmd_id");

    if (list[0] != (cookie_t) 0) {
        for (iter = list; *iter != (cookie_t) 0; iter++)
        {
            alarm_event_t * aevent = alarmd_event_get (*iter);
            time_t ttime = alarm_event_get_trigger(aevent);

            QDateTime qdtm = QDateTime::fromTime_t(ttime);
            if (result.isNull() || qdtm < result)
                result = qdtm;
        }
    }
    free(list);
#else
    result = QDateTime::currentDateTime();
    result = result.addSecs(3600);
#endif
    return result;
}
