//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsbutton.h"

LsButton::LsButton(QString name) :
    LsWidget(name.isEmpty() ? "Button": name)
{
    m_Pressed = false;
    setAcceptHoverEvents(true);
}

void LsButton::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                           QWidget*)
{
    if (m_Pressed && !m_BkgPressed.isNull())
        painter->drawPixmap(0, 0, m_BkgPressed);
    else
        painter->drawPixmap(0, 0, m_Bkg);
}

void LsButton::mousePressEvent(QGraphicsSceneMouseEvent*)
{
    m_Pressed = true;
    pressed();
    update();
}

void LsButton::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
{
    if (m_Pressed && isUnderMouse())
        clicked();
    m_Pressed = false;
    released();
    update();
}

void LsButton::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
{
    m_Pressed = false;
    released();
    update();
}
