//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSBATTERY_H
#define LSBATTERY_H
#include "lswidget.h"

class LsBattery : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsBattery(QString name="");

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    void stopUpdate();
    void startUpdate();
    void applySettings();

private:
    float m_Percentage;
    QList<QPixmap> m_Images;
    QFont m_PercFont;

private slots:
#ifdef Q_WS_MAEMO_5
    void bmePropertyModifiedSlot(QDBusMessage);
#endif
};

#endif // LSBATTERY_H
