#ifndef CENTRALWIDGET_H
#define CENTRALWIDGET_H

#include <QWidget>

#include "reversigame.h"

class QGridLayout;
class QVBoxLayout;
class FieldView;
class InfoPanel;
class ModePanel;

class CentralWidget : public QWidget
{
    Q_OBJECT
public:
    explicit CentralWidget(QWidget *parent, ReversiGame &reversiGame);
    void showInfoPanels();
    /** 
     * @brief Starts new game
     */
    void newGame();

private:
    QGridLayout *layout_;
    QVBoxLayout *infoLayout_;
    FieldView *fieldView_;
    InfoPanel *infoPanel_;
    ModePanel *modePanel_;
    //InfoPanel *infoPanelPortrait_;

    ReversiGame &reversiGame_;

signals:

private slots:
     void slotOrientationChanged();

};

#endif // CENTRALWIDGET_H
