#include <QApplication>
#include <QDesktopWidget>
#include <QGridLayout>
#include <QVBoxLayout>
#include <QMessageBox>
#include <QPair>

#include "centralwidget.h"
#include "fieldview.h"
#include "infopanel.h"
#include "modepanel.h"

CentralWidget::CentralWidget(QWidget *parent, ReversiGame &reversiGame):
    QWidget(parent),
    reversiGame_(reversiGame)
{
    layout_ = new QGridLayout(this);
    fieldView_ = new FieldView(reversiGame_, this);
    layout_->addWidget(fieldView_, 0, 0);

    infoLayout_ = new QVBoxLayout();
    infoLayout_->addStretch(1);

    infoPanel_ = new InfoPanel(reversiGame_, this);
    infoLayout_->addWidget(infoPanel_);

    modePanel_ = new ModePanel(this);
    infoLayout_->addWidget(modePanel_);
    infoLayout_->addStretch(1);

    layout_->addItem(infoLayout_, 0, 1);

    showInfoPanels();
}

void CentralWidget::slotOrientationChanged()
{
    showInfoPanels();
}

void CentralWidget::showInfoPanels()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height())
    {
        layout_->removeItem(infoLayout_);
        layout_->addItem(infoLayout_, 0, 1);
    }
    else
    {
        layout_->removeItem(infoLayout_);
        layout_->addItem(infoLayout_, 1, 0);
    }
}//showInfoPanels

void
CentralWidget::newGame()
{
    QPair<int, int> mode = modePanel_->mode();
    reversiGame_.init(mode.first, mode.second + 1);
}//newGame
