/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QDialog>
#include <QLayout>
#include <QListWidget>
#include <QAbstractButton>
#include <QDialogButtonBox>
#include <QGtkStyle>
#include <QMaemo5KineticScroller>

#include <qmaemo5listpickselector.h>
#include <private/qmaemo5listpickselector_p.h>


QT_BEGIN_NAMESPACE


QMaemo5ListPickSelector::QMaemo5ListPickSelector(QObject *parent)
    : QMaemo5AbstractPickSelector(*new QMaemo5ListPickSelectorPrivate, parent)
{
    Q_D(QMaemo5ListPickSelector);
    d->init();
}

QMaemo5ListPickSelector::QMaemo5ListPickSelector(QMaemo5ListPickSelectorPrivate &dd, QObject *parent)
    : QMaemo5AbstractPickSelector(dd, parent)
{
    Q_D(QMaemo5ListPickSelector);
    d->init();
}

QMaemo5ListPickSelector::~QMaemo5ListPickSelector()
{
}



QMaemo5ListPickSelectorPrivate::QMaemo5ListPickSelectorPrivate()
{
    model = 0;
    currentIndex = -1;
}

void QMaemo5ListPickSelectorPrivate::emitSelected(const QVariant &var, const QString &str)
{
    Q_Q(QMaemo5ListPickSelector);
    emit q->selected(var, str);
}

/*  The dialog used to display the list (with the previously set model) and
    the buttons.
    Actually the real construction is done by QMaemo5ListPickSelectorPrivate.
*/
class ListDialog : public QDialog {
public:
    ListDialog(QMaemo5ListPickSelectorPrivate *picker, QWidget *parent)
        : QDialog(parent), listPickSelectorPrivate(picker)
    { }

    void accept()
    {
        int oldIndex = listPickSelectorPrivate->currentIndex;

        QModelIndexList indexList = list->selectionModel()->selectedIndexes();
        if (indexList.count() > 0)
            listPickSelectorPrivate->currentIndex = indexList.first().row();
        else
            listPickSelectorPrivate->currentIndex = -1;

        if (indexList.count() > 0)
            listPickSelectorPrivate->emitSelected( list->model()->data(indexList.first()),
                    list->model()->data(indexList.first()).toString());

        QDialog::accept();
    }

    QMaemo5ListPickSelectorPrivate *listPickSelectorPrivate;
    QListView *list;
};

QWidget *QMaemo5ListPickSelector::widget(QWidget *parent)
{
    Q_D(QMaemo5ListPickSelector);

    ListDialog *td = new ListDialog(d, parent);
    if (QAbstractButton *pb = qobject_cast<QAbstractButton *>(parent))
        td->setWindowTitle(pb->text());
    td->setAttribute(Qt::WA_DeleteOnClose);
    QHBoxLayout *layout = new QHBoxLayout(td);

    td->list = new QListView();
    new QMaemo5KineticScroller(td->list);
    td->list->setModel(d->model);
    td->list->selectionModel()->select(d->model->index(d->currentIndex, 0),
            QItemSelectionModel::Select | QItemSelectionModel::Rows);
    layout->addWidget(td->list);

    connect(td->list, SIGNAL(clicked(const QModelIndex&)), td, SLOT(accept()) );

    if (td->list->sizeHintForRow(0)>0)
        td->list->setMinimumHeight(td->list->sizeHintForRow(0) * 5);
    return td;
}



/*!
    \property QMaemo5ListPickSelector::model
    \brief the model used in the list picker.

    The default Maemo list have centered text in lists so it makes sense
    to call setTextAlignment(Qt::AlignCenter) on all item.
    Also you might want to disable editing on the items with setEditable(false).

    Setting a tree model here is untested.
    Oh, and changing the model while the list dialog is displayed might lead
    to undefined results.

    Note: the model will not be deleted by the selector.
*/
QAbstractItemModel *QMaemo5ListPickSelector::model() const
{
    Q_D(const QMaemo5ListPickSelector);
    return d->model;
}

void QMaemo5ListPickSelector::setModel(QAbstractItemModel *model)
{
    Q_D(QMaemo5ListPickSelector);

    if (model == d->model)
        return;

    if (d->model)
        disconnect(d->model, SIGNAL(destroyed()), this, SLOT(modelDestroyed()));

    d->model = model;

    if (d->model) {
        if (d->model->rowCount() < d->currentIndex && d->currentIndex >= 0)
            d->currentIndex = d->model->rowCount();

        connect(d->model, SIGNAL(destroyed()), this, SLOT(modelDestroyed()));

    } else {
        d->currentIndex = -1;
    }

    emit selected(currentValue(), currentValueAsText());
}

void QMaemo5ListPickSelector::modelDestroyed()
{
    Q_D(QMaemo5ListPickSelector);

    d->model = 0;
    d->currentIndex = -1;
}

/*!
    \property QMaemo5ListPickSelector::currentIndex
    \brief the index of the current item in the list picker.

    The current index can change when setting a new model with a lower row
    count as the previous one.

    By default, for an empty list picker or a list picker in which no current
    item is set, this property has a value of -1.
*/
int QMaemo5ListPickSelector::currentIndex() const
{
    Q_D(const QMaemo5ListPickSelector);
    return d->currentIndex;
}

void QMaemo5ListPickSelector::setCurrentIndex(int index)
{
    Q_D(QMaemo5ListPickSelector);

    int oldIndex = d->currentIndex;
    if (index < 0 || index > d->model->rowCount())
        d->currentIndex = 0;
    else
        d->currentIndex = index;

    if (oldIndex != d->currentIndex)
        emit selected(currentValue(), currentValueAsText());
}


/*! Returns the currently selected value which in this case is a QModelIndex */
QVariant QMaemo5ListPickSelector::currentValue() const
{
    Q_D(const QMaemo5ListPickSelector);
    if (d->currentIndex >= 0)
        return d->model->data(d->model->index(d->currentIndex, 0));
    else
        return QVariant();
}

QString QMaemo5ListPickSelector::currentValueAsText() const
{
    return currentValue().toString();
}

QT_END_NAMESPACE
