/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>
#include <QtMaemo5>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    enum { ItemCount = 50 };

    QStandardItemModel model(0, 1);
    for (int i = 0; i < ItemCount; ++i)
        model.appendRow(new QStandardItem(QString("Value %1").arg(i)));

    QWidget toplevel;
    QVBoxLayout *layout = new QVBoxLayout(&toplevel);

    QMaemo5ValueButton *button1 = new QMaemo5ValueButton("Value besides text");
    button1->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QMaemo5ListPickSelector *selector1 = new QMaemo5ListPickSelector;
    selector1->setModel(&model);
    button1->setPickSelector(selector1);


    QMaemo5ValueButton *button2 = new QMaemo5ValueButton("Value under text");
    button2->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    QMaemo5ListPickSelector *selector2 = new QMaemo5ListPickSelector;
    selector2->setModel(&model);
    button2->setPickSelector(selector2);


    QMaemo5ValueButton *button3 = new QMaemo5ValueButton("Value centered under text");
    button3->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    QMaemo5ListPickSelector *selector3 = new QMaemo5ListPickSelector;
    selector3->setModel(&model);
    button3->setPickSelector(selector3);

    layout->addWidget(button1);
    layout->addWidget(button2);
    layout->addWidget(button3);

    toplevel.show();

    return app.exec();
}

