/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QMaemo5InformationBox>

#ifdef Q_WS_MAEMO_5

#include <QLabel>
#include <QLayout>
#include <QMaemo5Style>
#include <QStyleOption>

#include <private/qdialog_p.h>
#include <private/qt_x11_p.h>

QT_BEGIN_NAMESPACE

class QMaemo5InformationBoxPrivate : public QDialogPrivate
{
    Q_DECLARE_PUBLIC(QMaemo5InformationBox)

public:
    QMaemo5InformationBoxPrivate()
        : m_timeout(QMaemo5InformationBox::DefaultTimeout),
          m_timer_id(0), m_layout(0), m_widget(0)
    { }

    int m_timeout;
    int m_timer_id;
    QBoxLayout *m_layout;
    QWidget *m_widget;
};

QMaemo5InformationBox::QMaemo5InformationBox(QWidget *parent)
    : QDialog(*new QMaemo5InformationBoxPrivate, parent, Qt::CustomizeWindowHint)
{
    Q_D(QMaemo5InformationBox);

    setAttribute(Qt::WA_DeleteOnClose);
    setAttribute(Qt::WA_X11NetWmWindowTypeNotification);
    d->m_layout = new QHBoxLayout(this);
    d->m_layout->setContentsMargins(8, 0, 8, 0); // 8 == HILDON_MARGIN_DEFAULT
    setFixedWidth(QApplication::desktop()->screenGeometry().width());
    //move(0, 56 /*HILDON_WINDOW_TITLEBAR_HEIGHT*/);
}

QMaemo5InformationBox::~QMaemo5InformationBox()
{ }

void QMaemo5InformationBox::enforceInformationType()
{
    Q_D(QMaemo5InformationBox);

    const char *type = (d->m_timeout != NoTimeout) ? "_HILDON_NOTIFICATION_TYPE_BANNER"
                                                   : "_HILDON_NOTIFICATION_TYPE_INFO";

    XChangeProperty(X11->display, winId(), ATOM(_HILDON_NOTIFICATION_TYPE), XA_STRING, 8,
                    PropModeReplace, (unsigned char *) type, qstrlen(type));
}

int QMaemo5InformationBox::timeout() const
{
    Q_D(const QMaemo5InformationBox);
    return d->m_timeout;
}

void QMaemo5InformationBox::setTimeout(int ms)
{
    Q_D(QMaemo5InformationBox);
    d->m_timeout = qBound(0, ms, 10000);
}

QWidget *QMaemo5InformationBox::widget() const
{
    Q_D(const QMaemo5InformationBox);
    return d->m_widget;
}

void QMaemo5InformationBox::setWidget(QWidget *widget)
{
    Q_D(QMaemo5InformationBox);
    delete d->m_widget;
    d->m_widget = widget;
    if (widget) {
        d->m_layout->addWidget(widget);
        widget->show();
    }
}

void QMaemo5InformationBox::information(QWidget *parent, const QString &message, int timeout)
{
    QMaemo5InformationBox *box = new QMaemo5InformationBox(parent);
    box->setAttribute(Qt::WA_DeleteOnClose);
    box->setTimeout(timeout);
    QLabel *label = new QLabel();
    label->setAlignment(Qt::AlignCenter);
    label->setWordWrap(true);
    label->setTextInteractionFlags(Qt::NoTextInteraction);
    label->setText(message);
    box->setWidget(label);

    if (timeout > 0)
        box->show();
    else
        box->exec();
}

void QMaemo5InformationBox::showEvent(QShowEvent *)
{
    Q_D(QMaemo5InformationBox);

    enforceInformationType();
    if (d->m_timeout != QMaemo5InformationBox::NoTimeout)
        d->m_timer_id = startTimer(d->m_timeout);
}

void QMaemo5InformationBox::timerEvent(QTimerEvent *te)
{
    Q_D(QMaemo5InformationBox);

    if (te->timerId() == d->m_timer_id) {
        killTimer(d->m_timer_id);
        close();
    }
}

void QMaemo5InformationBox::mousePressEvent(QMouseEvent *me)
{
    if (me->button() == Qt::LeftButton) {
        close();
        emit clicked();
    }
}

void QMaemo5InformationBox::paintEvent(QPaintEvent *)
{
    if (qobject_cast<QMaemo5Style*>(style())) {
        QPainter painter(this);
        QStyleOption option;
        option.initFrom(this);
        style()->drawPrimitive(static_cast<QStyle::PrimitiveElement>(QMaemo5Style::PE_Maemo5InformationBox),
                               &option, &painter, this);
    }
}

QT_END_NAMESPACE

#endif // Q_WS_MAEMO_5
