/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <qtest.h>
#include <private/qmlcompiler_p.h>

class tst_qmlinstruction : public QObject
{
    Q_OBJECT
public:
    tst_qmlinstruction() {}

private slots:
    void dump();
};

static QStringList messages;
static void msgHandler(QtMsgType, const char *msg)
{
    messages << QLatin1String(msg);
}

void tst_qmlinstruction::dump()
{
    QmlCompiledData *data = new QmlCompiledData;
    {
        QmlInstruction i;
        i.line = 0;
        i.type = QmlInstruction::Init;
        data->bytecode << i;
    }

    {
        QmlCompiledData::TypeReference ref;
        ref.className = "Test";
        data->types << ref;

        QmlInstruction i;
        i.line = 1;
        i.type = QmlInstruction::CreateObject;
        i.create.type = 0;
        i.create.data = -1;
        i.create.bindingBits = -1;
        i.create.column = 10;
        data->bytecode << i;
    }

    {
        data->primitives << "testId";

        QmlInstruction i;
        i.line = 2;
        i.type = QmlInstruction::SetId;
        i.setId.value = 0;
        i.setId.index = 0;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 3;
        i.type = QmlInstruction::SetDefault;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 4;
        i.type = QmlInstruction::CreateComponent;
        i.createComponent.count = 3;
        i.createComponent.column = 4;
        i.createComponent.endLine = 14;
        i.createComponent.metaObject = 0;

        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 5;
        i.type = QmlInstruction::StoreMetaObject;
        i.storeMeta.data = 3;
        i.storeMeta.aliasData = 6;
        i.storeMeta.propertyCache = 7;

        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 6;
        i.type = QmlInstruction::StoreFloat;
        i.storeFloat.propertyIndex = 3;
        i.storeFloat.value = 11.3;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 7;
        i.type = QmlInstruction::StoreDouble;
        i.storeDouble.propertyIndex = 4;
        i.storeDouble.value = 14.8;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 8;
        i.type = QmlInstruction::StoreInteger;
        i.storeInteger.propertyIndex = 5;
        i.storeInteger.value = 9;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 9;
        i.type = QmlInstruction::StoreBool;
        i.storeBool.propertyIndex = 6;
        i.storeBool.value = true;

        data->bytecode << i;
    }

    {
        data->primitives << "Test String";
        QmlInstruction i;
        i.line = 10;
        i.type = QmlInstruction::StoreString;
        i.storeString.propertyIndex = 7;
        i.storeString.value = 1;
        data->bytecode << i;
    }

    {
        data->primitives << "http://www.nokia.com";
        QmlInstruction i;
        i.line = 11;
        i.type = QmlInstruction::StoreUrl;
        i.storeUrl.propertyIndex = 8;
        i.storeUrl.value = 2;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 12;
        i.type = QmlInstruction::StoreColor;
        i.storeColor.propertyIndex = 9;
        i.storeColor.value = 0xFF00FF00;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 13;
        i.type = QmlInstruction::StoreDate;
        i.storeDate.propertyIndex = 10;
        i.storeDate.value = 9;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 14;
        i.type = QmlInstruction::StoreTime;
        i.storeTime.propertyIndex = 11;
        i.storeTime.valueIndex = 33;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 15;
        i.type = QmlInstruction::StoreDateTime;
        i.storeDateTime.propertyIndex = 12;
        i.storeDateTime.valueIndex = 44;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 16;
        i.type = QmlInstruction::StorePoint;
        i.storeRealPair.propertyIndex = 13;
        i.storeRealPair.valueIndex = 3;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 17;
        i.type = QmlInstruction::StorePointF;
        i.storeRealPair.propertyIndex = 14;
        i.storeRealPair.valueIndex = 9;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 18;
        i.type = QmlInstruction::StoreSize;
        i.storeRealPair.propertyIndex = 15;
        i.storeRealPair.valueIndex = 8;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 19;
        i.type = QmlInstruction::StoreSizeF;
        i.storeRealPair.propertyIndex = 16;
        i.storeRealPair.valueIndex = 99;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 20;
        i.type = QmlInstruction::StoreRect;
        i.storeRect.propertyIndex = 17;
        i.storeRect.valueIndex = 2;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 21;
        i.type = QmlInstruction::StoreRectF;
        i.storeRect.propertyIndex = 18;
        i.storeRect.valueIndex = 19;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 22;
        i.type = QmlInstruction::StoreVector3D;
        i.storeVector3D.propertyIndex = 19;
        i.storeVector3D.valueIndex = 9;
        data->bytecode << i;
    }

    {
        data->primitives << "color(1, 1, 1, 1)";
        QmlInstruction i;
        i.line = 23;
        i.type = QmlInstruction::StoreVariant;
        i.storeString.propertyIndex = 20;
        i.storeString.value = 3;

        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 24;
        i.type = QmlInstruction::StoreObject;
        i.storeObject.propertyIndex = 21;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 25;
        i.type = QmlInstruction::StoreVariantObject;
        i.storeObject.propertyIndex = 22;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 26;
        i.type = QmlInstruction::StoreInterface;
        i.storeObject.propertyIndex = 23;
        data->bytecode << i;
    }

    {
        data->primitives << "console.log(1921)";

        QmlInstruction i;
        i.line = 27;
        i.type = QmlInstruction::StoreSignal;
        i.storeSignal.signalIndex = 2;
        i.storeSignal.value = 4;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 28;
        i.type = QmlInstruction::StoreScript;
        i.storeScript.value = 2;
        //i.storeScript.fileName = 18;
        //i.storeScript.lineNumber = 28;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 29;
        i.type = QmlInstruction::StoreScriptString;
        i.storeScriptString.propertyIndex = 24;
        i.storeScriptString.value = 3;
        i.storeScriptString.scope = 1;
        data->bytecode << i;
    }

    {
        data->datas << "mySignal";

        QmlInstruction i;
        i.line = 30;
        i.type = QmlInstruction::AssignSignalObject;
        i.assignSignalObject.signal = 0;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 31;
        i.type = QmlInstruction::AssignCustomType;
        i.assignCustomType.propertyIndex = 25;
        i.assignCustomType.valueIndex = 4;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 32;
        i.type = QmlInstruction::StoreBinding;
        i.assignBinding.property = 26;
        i.assignBinding.value = 3;
        i.assignBinding.context = 2;
        i.assignBinding.owner = 0;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 33;
        i.type = QmlInstruction::StoreIdOptBinding;
        i.assignIdOptBinding.property = 27;
        i.assignIdOptBinding.id = 2;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 34;
        i.type = QmlInstruction::StoreObjPropBinding;
        i.assignObjPropBinding.property = 28;
        i.assignObjPropBinding.contextIdx = 3;
        i.assignObjPropBinding.context = 7;
        i.assignObjPropBinding.notifyIdx = 4;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 35;
        i.type = QmlInstruction::StoreValueSource;
        i.assignValueSource.property = 29;
        i.assignValueSource.owner = 1;
        i.assignValueSource.castValue = 4;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 36;
        i.type = QmlInstruction::StoreValueInterceptor;
        i.assignValueInterceptor.property = 30;
        i.assignValueInterceptor.owner = 2;
        i.assignValueInterceptor.castValue = -4;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 37;
        i.type = QmlInstruction::BeginObject;
        i.begin.castValue = 4;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 38;
        i.type = QmlInstruction::StoreObjectQmlList;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 39;
        i.type = QmlInstruction::StoreObjectQList;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 40;
        i.type = QmlInstruction::AssignObjectList;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 41;
        i.type = QmlInstruction::FetchAttached;
        i.fetchAttached.id = 23;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 42;
        i.type = QmlInstruction::FetchQmlList;
        i.fetchQmlList.property = 31;
        i.fetchQmlList.type = 3;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 43;
        i.type = QmlInstruction::FetchQList;
        i.fetch.property = 32;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 44;
        i.type = QmlInstruction::FetchObject;
        i.fetch.property = 33;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 45;
        i.type = QmlInstruction::FetchValueType;
        i.fetchValue.property = 34;
        i.fetchValue.type = 6;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 46;
        i.type = QmlInstruction::PopFetchedObject;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 47;
        i.type = QmlInstruction::PopQList;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 48;
        i.type = QmlInstruction::PopValueType;
        i.fetchValue.property = 35;
        i.fetchValue.type = 8;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 49;
        i.type = QmlInstruction::Defer;
        i.defer.deferCount = 7;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = -1;
        i.type = QmlInstruction::Defer;
        i.defer.deferCount = 7;
        data->bytecode << i;
    }

    {
        QmlInstruction i;
        i.line = 50;
        i.type = (QmlInstruction::Type)(QmlInstruction::Defer + 1); // Non-existant
        data->bytecode << i;
    }

    QStringList expect;
    expect 
        << "Index\tLine\tOperation\t\tData1\tData2\tData3\tComments"
        << "-------------------------------------------------------------------------------"
        << "0\t\t0\tINIT"
        << "1\t\t1\tCREATE\t\t\t0\t\t\t\"Test\""
        << "2\t\t2\tSETID\t\t\t0\t\t\t\"testId\""
        << "3\t\t3\tSET_DEFAULT"
        << "4\t\t4\tCREATE_COMPONENT\t3"
        << "5\t\t5\tSTORE_META\t\t3"
        << "6\t\t6\tSTORE_FLOAT\t\t3\t11.3"
        << "7\t\t7\tSTORE_DOUBLE\t\t4\t14.8"
        << "8\t\t8\tSTORE_INTEGER\t\t5\t9"
        << "9\t\t9\tSTORE_BOOL\t\t6\ttrue"
        << "10\t\t10\tSTORE_STRING\t\t7\t1\t\t\"Test String\""
        << "11\t\t11\tSTORE_URL\t\t8\t2\t\t\"http://www.nokia.com\""
        << "12\t\t12\tSTORE_COLOR\t\t9\t\t\t\"ff00ff00\""
        << "13\t\t13\tSTORE_DATE\t\t10\t9"
        << "14\t\t14\tSTORE_TIME\t\t11\t33"
        << "15\t\t15\tSTORE_DATETIME\t\t12\t44"
        << "16\t\t16\tSTORE_POINT\t\t13\t3"
        << "17\t\t17\tSTORE_POINTF\t\t14\t9"
        << "18\t\t18\tSTORE_SIZE\t\t15\t8"
        << "19\t\t19\tSTORE_SIZEF\t\t16\t99"
        << "20\t\t20\tSTORE_RECT\t\t17\t2"
        << "21\t\t21\tSTORE_RECTF\t\t18\t19"
        << "22\t\t22\tSTORE_VECTOR3D\t\t19\t9"
        << "23\t\t23\tSTORE_VARIANT\t\t20\t3\t\t\"color(1, 1, 1, 1)\""
        << "24\t\t24\tSTORE_OBJECT\t\t21"
        << "25\t\t25\tSTORE_VARIANT_OBJECT\t22"
        << "26\t\t26\tSTORE_INTERFACE\t\t23"
        << "27\t\t27\tSTORE_SIGNAL\t\t2\t4\t\t\"console.log(1921)\""
        << "28\t\t28\tSTORE_SCRIPT\t\t2"
        << "29\t\t29\tSTORE_SCRIPT_STRING\t24\t3\t1"
        << "30\t\t30\tASSIGN_SIGNAL_OBJECT\t0\t\t\t\"mySignal\""
        << "31\t\t31\tASSIGN_CUSTOMTYPE\t25\t4"
        << "32\t\t32\tSTORE_COMPILED_BINDING\t26\t3\t2"
        << "33\t\t33\tSTORE_ID_OPT_BINDING\t27\t2"
        << "34\t\t34\tSTORE_OBJ_PROP_BINDING\t28\t3\t7\t4"
        << "35\t\t35\tSTORE_VALUE_SOURCE\t29\t4"
        << "36\t\t36\tSTORE_VALUE_INTERCEPTOR\t30\t-4"
        << "37\t\t37\tBEGIN\t\t\t4"
        << "38\t\t38\tSTORE_OBJECT_QMLLIST"
        << "39\t\t39\tSTORE_OBJECT_QLIST"
        << "40\t\t40\tASSIGN_OBJECT_LIST"
        << "41\t\t41\tFETCH_ATTACHED\t\t23"
        << "42\t\t42\tFETCH_QMLLIST\t\t31\t3"
        << "43\t\t43\tFETCH_QLIST\t\t32"
        << "44\t\t44\tFETCH\t\t\t33"
        << "45\t\t45\tFETCH_VALUE\t\t34\t6"
        << "46\t\t46\tPOP"
        << "47\t\t47\tPOP_QLIST"
        << "48\t\t48\tPOP_VALUE\t\t35\t8"
        << "49\t\t49\tDEFER\t\t\t7"
        << "50\t\tNA\tDEFER\t\t\t7"
        << "51\t\t50\tXXX UNKOWN INSTRUCTION\t50"
        << "-------------------------------------------------------------------------------";

    messages = QStringList();
    QtMsgHandler old = qInstallMsgHandler(msgHandler);
    data->dumpInstructions();
    qInstallMsgHandler(old);

    QCOMPARE(messages.count(), expect.count());
    for (int ii = 0; ii < messages.count(); ++ii) {
        QCOMPARE(messages.at(ii), expect.at(ii));
    }

    data->release();
}

QTEST_MAIN(tst_qmlinstruction)

#include "tst_qmlinstruction.moc"
