/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt QML Debugger of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef QMLINSPECTORPLUGIN_H
#define QMLINSPECTORPLUGIN_H

#include <extensionsystem/iplugin.h>

#include <QtCore/QObject>
#include <QtCore/QPointer>

QT_BEGIN_NAMESPACE

class QStringList;


class QmlInspectorRunControlFactory;
class QmlInspectorMode;
class InspectorOutputPane;

namespace ProjectExplorer
{
    class RunControl;
}

class QmlInspectorPlugin : public ExtensionSystem::IPlugin
{
    Q_OBJECT

public:
    QmlInspectorPlugin();
    ~QmlInspectorPlugin();

    virtual bool initialize(const QStringList &arguments, QString *errorString);
    virtual void extensionsInitialized();
    virtual void shutdown();

private slots:
    void startViewer();
    void stopViewer();

private:
    QmlInspectorMode *m_inspectMode;
    InspectorOutputPane *m_outputPane;
    
    QmlInspectorRunControlFactory *m_runControlFactory;
    QPointer<ProjectExplorer::RunControl> m_runControl;
};


QT_END_NAMESPACE

#endif // QMLINSPECTORPLUGIN_H
