/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

QT_BEGIN_NAMESPACE

// NOT derived from QPushButtonPrivate on purpose, so we can
// move the Maemo5 classes into a separate project that may
// not have access to private QtGui classes/symbols.

class QMaemo5ValueButtonPrivate
{
    Q_DECLARE_PUBLIC(QMaemo5ValueButton)
public:
    QMaemo5ValueButtonPrivate()
        : q_ptr(0), valueLayout(QMaemo5ValueButton::ValueUnderText),
          groupValueWidth(-1), groupTextWidth(-1),
          pickSelector(0)
    { }

    virtual ~QMaemo5ValueButtonPrivate()
    { }

    void init();

    void _q_clicked();
    void _q_selected(const QString &);

    QMaemo5ValueButton *q_ptr;
    QString valueText;
    QMaemo5ValueButton::ValueLayout valueLayout;

    // all these metrics are set in sizeHint(), which is const
    mutable QSize valueSize;
    mutable QSize textSize;
    mutable int groupValueWidth;
    mutable int groupTextWidth;
    mutable QSize sizeHint;

    QMaemo5AbstractPickSelector *pickSelector;
};

QT_END_NAMESPACE
